/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.itemsettree;

import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.AssociationRuleIT;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.HashTableIT;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.ItemsetTreeNode;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

abstract class AbstractItemsetTree {
    ItemsetTreeNode root = null;
    int nodeCount;
    long totalItemCountInNodes;
    long startTimestamp;
    long endTimestamp;

    AbstractItemsetTree() {
    }

    protected int[] getLargestCommonAncestor(int[] itemset1, int[] itemset2) {
        if (itemset2 == null || itemset1 == null) {
            return null;
        }
        int minI = itemset1.length < itemset2.length ? itemset1.length : itemset2.length;
        int count = 0;
        for (int i = 0; i < minI && itemset1[i] == itemset2[i]; ++i) {
            ++count;
        }
        if (count > 0 && count < minI) {
            int[] common = new int[count];
            System.arraycopy(itemset1, 0, common, 0, count);
            return common;
        }
        return null;
    }

    protected boolean ancestorOf(int[] itemset1, int[] itemset2) {
        if (itemset2 == null) {
            return false;
        }
        if (itemset1 == null) {
            return true;
        }
        if (itemset1.length >= itemset2.length) {
            return false;
        }
        for (int i = 0; i < itemset1.length; ++i) {
            if (itemset1[i] == itemset2[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean same(int[] itemset1, int[] itemset2) {
        if (itemset2 == null || itemset1 == null) {
            return false;
        }
        if (itemset1.length != itemset2.length) {
            return false;
        }
        for (int i = 0; i < itemset1.length; ++i) {
            if (itemset1[i] == itemset2[i]) continue;
            return false;
        }
        return true;
    }

    public HashTableIT getFrequentItemsetSubsuming(int[] is, int minsup) {
        HashTableIT hashTable = this.getFrequentItemsetSubsuming(is);
        for (List<Itemset> list : hashTable.table) {
            if (list == null) continue;
            Iterator<Itemset> it = list.iterator();
            while (it.hasNext()) {
                Itemset itemset2 = it.next();
                if (itemset2.support >= minsup) continue;
                it.remove();
            }
        }
        return hashTable;
    }

    protected abstract HashTableIT getFrequentItemsetSubsuming(int[] var1);

    public List<AssociationRuleIT> generateRules(int[] s, int minsup, double minconf) {
        ArrayList<AssociationRuleIT> rules = new ArrayList<AssociationRuleIT>();
        HashSet<Integer> seti = new HashSet<Integer>();
        for (int i = 0; i < s.length; ++i) {
            seti.add(s[i]);
        }
        int suppS = this.getSupportOfItemset(s);
        HashTableIT frequentItemsets = this.getFrequentItemsetSubsuming(s, minsup);
        for (List<Itemset> list : frequentItemsets.table) {
            if (list == null) continue;
            for (Itemset c : list) {
                if (c.size() == s.length) continue;
                int[] l = new int[c.itemset.length - s.length];
                int pos = 0;
                int[] nArray = c.itemset;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer item = nArray[i];
                    if (seti.contains(item)) continue;
                    l[pos++] = item;
                }
                int suppC = this.getSupportOfItemset(c.itemset);
                double conf = (double)suppC / (double)suppS;
                if (!(conf >= minconf)) continue;
                AssociationRuleIT rule = new AssociationRuleIT();
                rule.itemset1 = s;
                rule.itemset2 = l;
                rule.support = suppC;
                rule.confidence = conf;
                rules.add(rule);
            }
        }
        return rules;
    }

    public abstract int getSupportOfItemset(int[] var1);
}

