/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.itemsettree;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.AbstractItemsetTree;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.HashTableIT;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.ItemsetTreeNode;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MemoryEfficientItemsetTree
extends AbstractItemsetTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    long sumBranchesLength;
    int totalNumberOfBranches;

    public void buildTree(String input) throws IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        this.root = new ItemsetTreeNode(null, 0);
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            int[] itemset2 = new int[lineSplited.length];
            for (int i = 0; i < lineSplited.length; ++i) {
                itemset2[i] = Integer.parseInt(lineSplited[i]);
            }
            this.construct(null, this.root, itemset2, null);
        }
        reader.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void addTransaction(int[] transaction) {
        this.construct(null, this.root, transaction, null);
    }

    private void construct(ItemsetTreeNode parentOfR, ItemsetTreeNode r, int[] s, int[] prefix) {
        if (this.same(s, prefix, r.itemset)) {
            ++r.support;
            return;
        }
        int[] rprefix = this.append(prefix, r.itemset);
        if (this.ancestorOf(s, rprefix)) {
            int[] sprime = this.copyItemsetWithoutItemsFrom(s, prefix);
            int[] rprime = this.copyItemsetWithoutItemsFrom(rprefix, sprime);
            ItemsetTreeNode newNodeS = new ItemsetTreeNode(sprime, r.support + 1);
            newNodeS.childs.add(r);
            parentOfR.childs.remove(r);
            parentOfR.childs.add(newNodeS);
            r.itemset = rprime;
            return;
        }
        int[] l = this.getLargestCommonAncestor(s, rprefix);
        if (l != null) {
            int[] sprime = this.copyItemsetWithoutItemsFrom(s, l);
            int[] rprime = this.copyItemsetWithoutItemsFrom(r.itemset, l);
            ItemsetTreeNode newNode = new ItemsetTreeNode(l, r.support + 1);
            newNode.childs.add(r);
            parentOfR.childs.remove(r);
            parentOfR.childs.add(newNode);
            r.itemset = rprime;
            ItemsetTreeNode newNode2 = new ItemsetTreeNode(sprime, 1);
            newNode.childs.add(newNode2);
            return;
        }
        int indexLastItemOfR = rprefix == null ? 0 : rprefix.length;
        ++r.support;
        for (ItemsetTreeNode ci : r.childs) {
            int[] ciprefix = this.append(rprefix, ci.itemset);
            if (this.same(s, ciprefix)) {
                ++ci.support;
                return;
            }
            if (this.ancestorOf(s, ciprefix)) {
                int[] sprime = this.copyItemsetWithoutItemsFrom(s, rprefix);
                int[] ciprime = this.copyItemsetWithoutItemsFrom(ci.itemset, s);
                ItemsetTreeNode newNode = new ItemsetTreeNode(sprime, ci.support + 1);
                newNode.childs.add(ci);
                r.childs.remove(ci);
                r.childs.add(newNode);
                ci.itemset = ciprime;
                return;
            }
            if (this.ancestorOf(ciprefix, s)) {
                this.construct(r, ci, s, rprefix);
                return;
            }
            if (ciprefix[indexLastItemOfR] != s[indexLastItemOfR]) continue;
            int[] ancestor = this.getLargestCommonAncestor(s, ciprefix);
            int[] ancestorprime = this.copyItemsetWithoutItemsFrom(ancestor, rprefix);
            ItemsetTreeNode newNode = new ItemsetTreeNode(ancestorprime, ci.support + 1);
            r.childs.add(newNode);
            ci.itemset = this.copyItemsetWithoutItemsFrom(ci.itemset, ancestorprime);
            newNode.childs.add(ci);
            r.childs.remove(ci);
            int[] sprime = this.copyItemsetWithoutItemsFromArrays(s, ancestorprime, rprefix);
            ItemsetTreeNode newNode2 = new ItemsetTreeNode(sprime, 1);
            newNode.childs.add(newNode2);
            return;
        }
        int[] sprime = this.copyItemsetWithoutItemsFrom(s, rprefix);
        ItemsetTreeNode newNode = new ItemsetTreeNode(sprime, 1);
        r.childs.add(newNode);
    }

    private int[] copyItemsetWithoutItemsFromArrays(int[] r, int[] prefix, int[] s) {
        ArrayList<Integer> rprime = new ArrayList<Integer>(r.length);
        int[] nArray = r;
        int n = nArray.length;
        block0: for (int i = 0; i < n; ++i) {
            Integer rvalue = nArray[i];
            if (prefix != null) {
                for (int pvalue : prefix) {
                    if (pvalue == rvalue) continue block0;
                    if (pvalue > rvalue) break;
                }
            }
            if (s != null) {
                for (int svalue : s) {
                    if (rvalue == svalue) continue block0;
                    if (svalue > rvalue) break;
                }
            }
            rprime.add(rvalue);
        }
        int[] rprimeArray = new int[rprime.size()];
        for (int i = 0; i < rprime.size(); ++i) {
            rprimeArray[i] = (Integer)rprime.get(i);
        }
        return rprimeArray;
    }

    private int[] copyItemsetWithoutItemsFrom(int[] itemset1, int[] itemset2) {
        if (itemset2 == null) {
            return itemset1;
        }
        ArrayList<Integer> itemset1prime = new ArrayList<Integer>(itemset1.length);
        block0: for (int i1value : itemset1) {
            for (int i2value : itemset2) {
                if (i2value == i1value) continue block0;
                if (i2value > i1value) break;
            }
            itemset1prime.add(i1value);
        }
        int[] itemset1primeArray = new int[itemset1prime.size()];
        for (int i = 0; i < itemset1prime.size(); ++i) {
            itemset1primeArray[i] = (Integer)itemset1prime.get(i);
        }
        return itemset1primeArray;
    }

    private boolean same(int[] itemset1, int[] prefix, int[] itemset2) {
        int i;
        if (prefix == null) {
            return this.same(itemset1, itemset2);
        }
        if (itemset2 == null || itemset1 == null) {
            return false;
        }
        if (itemset1.length != itemset2.length + prefix.length) {
            return false;
        }
        for (i = 0; i < prefix.length; ++i) {
            if (itemset1[i] == prefix[i]) continue;
            return false;
        }
        int j = 0;
        while (j < itemset2.length) {
            if (itemset1[j++] == itemset2[i++]) continue;
            return false;
        }
        return true;
    }

    public int[] append(int[] a1, int[] a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        int[] newArray = new int[a1.length + a2.length];
        for (int i = 0; i < a1.length; ++i) {
            newArray[i] = a1[i];
        }
        for (int j = 0; j < a2.length; ++j) {
            newArray[i++] = a2[j];
        }
        return newArray;
    }

    public void printStatistics() {
        System.gc();
        System.out.println("========== MEMORY EFFICIENT ITEMSET TREE CONSTRUCTION - STATS ============");
        System.out.println(" Tree construction time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        this.nodeCount = 0;
        this.totalItemCountInNodes = 0L;
        this.sumBranchesLength = 0L;
        this.totalNumberOfBranches = 0;
        this.recursiveStats(this.root, 1);
        System.out.println(" Node count: " + this.nodeCount);
        System.out.println(" Sum of items in all node: " + this.totalItemCountInNodes + " avg per node :" + (double)this.totalItemCountInNodes / (double)this.nodeCount);
        System.out.println("=====================================");
    }

    private void recursiveStats(ItemsetTreeNode root, int length) {
        if (root != null && root.itemset != null) {
            ++this.nodeCount;
            this.totalItemCountInNodes += (long)root.itemset.length;
        }
        for (ItemsetTreeNode node : root.childs) {
            this.recursiveStats(node, ++length);
        }
        if (root.childs.size() == 0) {
            this.sumBranchesLength += (long)length;
            ++this.totalNumberOfBranches;
        }
    }

    public void printTree() {
        System.out.println(this.root.toString(new StringBuilder(), ""));
    }

    public String toString() {
        return this.root.toString(new StringBuilder(), "");
    }

    @Override
    public int getSupportOfItemset(int[] s) {
        return this.count(s, this.root, new int[0]);
    }

    private int count(int[] s, ItemsetTreeNode root, int[] prefix) {
        int count = 0;
        for (ItemsetTreeNode ci : root.childs) {
            int[] ciprefix = this.append(prefix, ci.itemset);
            if (ciprefix[0] > s[0]) continue;
            if (ArraysAlgos.includedIn(s, ciprefix)) {
                count += ci.support;
                continue;
            }
            if (ciprefix[ciprefix.length - 1] >= s[s.length - 1]) continue;
            count += this.count(s, ci, ciprefix);
        }
        return count;
    }

    @Override
    public HashTableIT getFrequentItemsetSubsuming(int[] is, int minsup) {
        HashTableIT hashTable = this.getFrequentItemsetSubsuming(is);
        for (List<Itemset> list : hashTable.table) {
            if (list == null) continue;
            Iterator<Itemset> it = list.iterator();
            while (it.hasNext()) {
                Itemset itemset2 = it.next();
                if (itemset2.support >= minsup) continue;
                it.remove();
            }
        }
        return hashTable;
    }

    @Override
    public HashTableIT getFrequentItemsetSubsuming(int[] s) {
        HashTableIT hash = new HashTableIT(1000);
        HashSet<Integer> seti = new HashSet<Integer>();
        for (int i = 0; i < s.length; ++i) {
            seti.add(s[i]);
        }
        this.selectiveMining(s, seti, this.root, hash, null);
        return hash;
    }

    private int selectiveMining(int[] s, HashSet<Integer> seti, ItemsetTreeNode t, HashTableIT hash, int[] prefix) {
        int childrenSup = 0;
        for (ItemsetTreeNode ci : t.childs) {
            childrenSup += ci.support;
            int[] ciprefix = this.append(prefix, ci.itemset);
            if (ciprefix[0] > s[0]) continue;
            if (ArraysAlgos.includedIn(s, ciprefix)) {
                if (ci.childs.size() == 0) {
                    hash.put(s, ci.support);
                    this.recursiveAdd(s, seti, ciprefix, ci.support, hash, 0);
                    continue;
                }
                int remainingSup = ci.support - this.selectiveMining(s, seti, ci, hash, ciprefix);
                if (remainingSup <= 0) continue;
                hash.put(s, remainingSup);
                this.recursiveAdd(s, seti, ciprefix, remainingSup, hash, 0);
                continue;
            }
            if (ciprefix[ciprefix.length - 1] >= s[s.length - 1]) continue;
            this.selectiveMining(s, seti, ci, hash, ciprefix);
        }
        return childrenSup;
    }

    private void recursiveAdd(int[] s, HashSet<Integer> seti, int[] ci, int cisupport, HashTableIT hash, int pos) {
        if (pos >= ci.length) {
            return;
        }
        if (!seti.contains(ci[pos])) {
            int[] newS = new int[s.length + 1];
            int j = 0;
            boolean added = false;
            int[] nArray = s;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer item = nArray[i];
                if (added || item < ci[pos]) {
                    newS[j++] = item;
                    continue;
                }
                newS[j++] = ci[pos];
                newS[j++] = item;
                added = true;
            }
            if (j < s.length + 1) {
                newS[j++] = ci[pos];
            }
            hash.put(newS, cisupport);
            this.recursiveAdd(newS, seti, ci, cisupport, hash, pos + 1);
        }
        this.recursiveAdd(s, seti, ci, cisupport, hash, pos + 1);
    }
}

