/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lhui;

import ca.pfv.spmf.algorithms.frequentpatterns.lhui.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.lhui.Period;
import ca.pfv.spmf.algorithms.frequentpatterns.lhui.UtilityListPeak;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoPHUIMiner {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    Map<Integer, TWUPair> mapItemToTWU;
    BufferedWriter writer = null;
    private int joinCount;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    ArrayList<Long> timeTid = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, long minUtility, long window, double lambda) throws IOException {
        String frontLine;
        MemoryLogger.getInstance().reset();
        this.itemsetBuffer = new int[200];
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, TWUPair>();
        String rearLine = "";
        try (BufferedReader myInput = null;){
            TWUPair twup;
            Integer item;
            int i;
            long transactionUtility;
            String[] items;
            String[] split;
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            BufferedReader bufr = new BufferedReader(new FileReader(input));
            long beginTime = 0L;
            long endTime = 0L;
            long preBeginTime = 0L;
            while ((frontLine = myInput.readLine()) != null) {
                if (frontLine.isEmpty() || frontLine.charAt(0) == '#' || frontLine.charAt(0) == '%' || frontLine.charAt(0) == '@') continue;
                split = frontLine.split(":");
                items = split[0].split(" ");
                transactionUtility = Integer.parseInt(split[1]);
                endTime = Long.parseLong(split[3]);
                if (beginTime == 0L) {
                    beginTime = endTime;
                }
                if (endTime >= beginTime + window) break;
                this.timeTid.add(endTime);
                for (i = 0; i < items.length; ++i) {
                    item = Integer.parseInt(items[i]);
                    twup = this.mapItemToTWU.get(item);
                    if (twup == null) {
                        twup = new TWUPair();
                        twup.currentTWU = transactionUtility;
                    } else {
                        twup.currentTWU += transactionUtility;
                    }
                    if (twup.maxTWU < twup.currentTWU) {
                        twup.maxTWU = twup.currentTWU;
                    }
                    this.mapItemToTWU.put(item, twup);
                }
            }
            preBeginTime = beginTime;
            block12: while (frontLine != null) {
                do {
                    if (rearLine.isEmpty() || rearLine.charAt(0) == '#' || rearLine.charAt(0) == '%' || rearLine.charAt(0) == '@') continue;
                    split = rearLine.split(":");
                    items = split[0].split(" ");
                    transactionUtility = Integer.parseInt(split[1]);
                    beginTime = Long.parseLong(split[3]);
                    if (preBeginTime != beginTime) {
                        preBeginTime = beginTime;
                        break;
                    }
                    for (i = 0; i < items.length; ++i) {
                        item = Integer.parseInt(items[i]);
                        twup = this.mapItemToTWU.get(item);
                        twup.currentTWU -= transactionUtility;
                        this.mapItemToTWU.put(item, twup);
                    }
                } while ((rearLine = bufr.readLine()) != null);
                do {
                    if (frontLine.isEmpty() || frontLine.charAt(0) == '#' || frontLine.charAt(0) == '%' || frontLine.charAt(0) == '@') continue;
                    split = frontLine.split(":");
                    items = split[0].split(" ");
                    transactionUtility = Integer.parseInt(split[1]);
                    endTime = Long.parseLong(split[3]);
                    if (endTime >= beginTime + window) continue block12;
                    this.timeTid.add(endTime);
                    for (i = 0; i < items.length; ++i) {
                        item = Integer.parseInt(items[i]);
                        twup = this.mapItemToTWU.get(item);
                        if (twup == null) {
                            twup = new TWUPair();
                            twup.currentTWU = transactionUtility;
                        } else {
                            twup.currentTWU += transactionUtility;
                        }
                        if (twup.currentTWU > twup.maxTWU) {
                            twup.maxTWU = twup.currentTWU;
                        }
                        this.mapItemToTWU.put(item, twup);
                    }
                } while ((frontLine = myInput.readLine()) != null);
            }
        }
        ArrayList<UtilityListPeak> listOfUtilityListPeaks = new ArrayList<UtilityListPeak>();
        HashMap<Integer, UtilityListPeak> mapItemToUtilityListPeak = new HashMap<Integer, UtilityListPeak>();
        for (Integer item : this.mapItemToTWU.keySet()) {
            if (this.mapItemToTWU.get((Object)item).maxTWU < minUtility) continue;
            UtilityListPeak uList = new UtilityListPeak(item);
            mapItemToUtilityListPeak.put(item, uList);
            listOfUtilityListPeaks.add(uList);
        }
        Collections.sort(listOfUtilityListPeaks, new Comparator<UtilityListPeak>(){

            @Override
            public int compare(UtilityListPeak o1, UtilityListPeak o2) {
                return AlgoPHUIMiner.this.compareItems(o1.item, o2.item);
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((frontLine = myInput.readLine()) != null) {
                if (frontLine.isEmpty() || frontLine.charAt(0) == '#' || frontLine.charAt(0) == '%' || frontLine.charAt(0) == '@') continue;
                String[] split = frontLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                long remainingUtility = 0L;
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                for (int i = 0; i < items.length; ++i) {
                    Pair pair = new Pair();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    if (this.mapItemToTWU.get((Object)Integer.valueOf((int)pair.item)).maxTWU < minUtility) continue;
                    revisedTransaction.add(pair);
                    remainingUtility += pair.utility;
                }
                Collections.sort(revisedTransaction, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        return AlgoPHUIMiner.this.compareItems(o1.item, o2.item);
                    }
                });
                for (Pair pair : revisedTransaction) {
                    UtilityListPeak UtilityListPeakOfItem = (UtilityListPeak)mapItemToUtilityListPeak.get(pair.item);
                    Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                    UtilityListPeakOfItem.addElement(element);
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        for (UtilityListPeak ulp : listOfUtilityListPeaks) {
            this.generatePeak(ulp, minUtility, window, lambda);
        }
        MemoryLogger.getInstance().checkMemory();
        this.phuiMiner(this.itemsetBuffer, 0, null, listOfUtilityListPeaks, minUtility, window, lambda);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        long compare = this.mapItemToTWU.get((Object)Integer.valueOf((int)item1)).maxTWU - this.mapItemToTWU.get((Object)Integer.valueOf((int)item2)).maxTWU;
        return compare == 0L ? item1 - item2 : (int)compare;
    }

    private void phuiMiner(int[] prefix, int prefixLength, UtilityListPeak pUL, List<UtilityListPeak> ULs, long minUtility, long window, double lambda) throws IOException {
        for (int i = 0; i < ULs.size(); ++i) {
            UtilityListPeak X = ULs.get(i);
            if (!X.peak.isEmpty()) {
                this.writeOut(prefix, prefixLength, X);
            }
            if (X.utilPeriod.isEmpty()) continue;
            ArrayList<UtilityListPeak> exULs = new ArrayList<UtilityListPeak>();
            for (int j = i + 1; j < ULs.size(); ++j) {
                UtilityListPeak Y = ULs.get(j);
                UtilityListPeak pXY = this.construct(pUL, X, Y);
                this.generatePeak(pXY, minUtility, window, lambda);
                exULs.add(pXY);
                ++this.joinCount;
            }
            this.itemsetBuffer[prefixLength] = X.item;
            this.phuiMiner(this.itemsetBuffer, prefixLength + 1, X, exULs, minUtility, window, lambda);
        }
    }

    private UtilityListPeak construct(UtilityListPeak P, UtilityListPeak px, UtilityListPeak py) {
        UtilityListPeak pxyUL = new UtilityListPeak(py.item);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityListPeak ulist, int tid) {
        ArrayList list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (((Element)list.get((int)middle)).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (((Element)list.get((int)middle)).tid > tid) {
                last = middle - 1;
                continue;
            }
            return (Element)list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, UtilityListPeak ulp) throws IOException {
        int i;
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        for (i = 0; i < prefixLength; ++i) {
            buffer.append(prefix[i]);
            buffer.append(' ');
        }
        buffer.append(ulp.item);
        buffer.append(" #UTIL: ");
        buffer.append(ulp.sumIutils);
        buffer.append(" peak windows: ");
        for (i = 0; i < ulp.peak.size(); ++i) {
            Period p = ulp.peak.get(i);
            buffer.append("[" + this.timeTid.get(((Element)ulp.elements.get((int)p.beginIndex)).tid) + "," + this.timeTid.get(((Element)ulp.elements.get((int)p.endIndex)).tid) + "] ");
        }
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void generatePeak(UtilityListPeak ulp, long minutil, long window, double lambda) {
        int winEnd;
        long win2len;
        long iutil = 0L;
        long rutil = 0L;
        long putil = 0L;
        int win2start = 0;
        boolean iutilPreflag = false;
        boolean utilPreflag = false;
        boolean putilPreflag = false;
        long l = win2len = (long)((double)window / lambda) > 0L ? (long)((double)window / lambda) : 1L;
        for (winEnd = 0; winEnd < ulp.elements.size() && this.timeTid.get(((Element)ulp.elements.get((int)winEnd)).tid) < this.timeTid.get(((Element)ulp.elements.get((int)0)).tid) + (window - win2len); ++winEnd) {
            iutil += ((Element)ulp.elements.get((int)winEnd)).iutils;
            rutil += ((Element)ulp.elements.get((int)winEnd)).rutils;
        }
        win2start = winEnd;
        while (winEnd < ulp.elements.size() && this.timeTid.get(((Element)ulp.elements.get((int)winEnd)).tid) < this.timeTid.get(((Element)ulp.elements.get((int)0)).tid) + window) {
            iutil += ((Element)ulp.elements.get((int)winEnd)).iutils;
            putil += ((Element)ulp.elements.get((int)winEnd)).iutils;
            rutil += ((Element)ulp.elements.get((int)winEnd)).rutils;
            ++winEnd;
        }
        if (iutil > minutil) {
            iutilPreflag = true;
        }
        if (iutil + rutil > minutil) {
            utilPreflag = true;
        }
        if ((double)putil * (double)window / (double)win2len > (double)iutil && iutil > minutil) {
            putilPreflag = true;
        }
        this.slideWindow(ulp, winEnd, minutil, iutil, iutilPreflag, rutil, utilPreflag, putil, win2start, putilPreflag, window, win2len);
    }

    private void slideWindow(UtilityListPeak ulp, int winEnd, long minutil, long iutil, boolean iutilPreflag, long rutil, boolean utilPreflag, long putil, int win2start, boolean putilPreflag, long window, long win2len) {
        int beginIndex = 0;
        int endIndex = winEnd;
        int uBeginIndex = 0;
        int uEndIndex = winEnd;
        int pBeginIndex = winEnd - 1;
        int pEndIndex = winEnd - 1;
        int i = 0;
        while (i < ulp.elements.size()) {
            int y;
            for (y = i; y < ulp.elements.size() && this.timeTid.get(((Element)ulp.elements.get((int)y)).tid).longValue() == this.timeTid.get(((Element)ulp.elements.get((int)i)).tid).longValue(); ++y) {
                iutil -= ((Element)ulp.elements.get((int)y)).iutils;
                rutil -= ((Element)ulp.elements.get((int)y)).rutils;
            }
            i = y;
            while (winEnd < ulp.elements.size() && this.timeTid.get(((Element)ulp.elements.get((int)winEnd)).tid) < this.timeTid.get(((Element)ulp.elements.get((int)y)).tid) + window) {
                iutil += ((Element)ulp.elements.get((int)winEnd)).iutils;
                putil += ((Element)ulp.elements.get((int)winEnd)).iutils;
                rutil += ((Element)ulp.elements.get((int)winEnd)).rutils;
                ++winEnd;
            }
            while (win2start < ulp.elements.size() && this.timeTid.get(((Element)ulp.elements.get((int)win2start)).tid) < this.timeTid.get(((Element)ulp.elements.get((int)(winEnd - 1))).tid) - win2len) {
                putil -= ((Element)ulp.elements.get((int)win2start)).iutils;
                ++win2start;
            }
            if (iutilPreflag) {
                if (iutil < minutil) {
                    ulp.iutilPeriod.add(new Period(beginIndex, endIndex - 1));
                    iutilPreflag = false;
                } else {
                    endIndex = winEnd;
                }
            } else if (iutil > minutil) {
                iutilPreflag = true;
                beginIndex = i;
                endIndex = winEnd;
            }
            if (utilPreflag) {
                if (iutil + rutil < minutil) {
                    ulp.utilPeriod.add(new Period(uBeginIndex, uEndIndex - 1));
                    utilPreflag = false;
                } else {
                    uEndIndex = winEnd;
                }
            } else if (iutil + rutil > minutil) {
                utilPreflag = true;
                uBeginIndex = i;
                uEndIndex = winEnd;
            }
            if (putilPreflag) {
                if ((double)putil * (double)window / (double)win2len < (double)iutil || iutil < minutil) {
                    ulp.peak.add(new Period(pBeginIndex, pEndIndex));
                    putilPreflag = false;
                    continue;
                }
                pEndIndex = winEnd - 1;
                continue;
            }
            if (!((double)putil * (double)window / (double)win2len >= (double)iutil) || iutil < minutil) continue;
            putilPreflag = true;
            pBeginIndex = winEnd - 1;
            pEndIndex = winEnd - 1;
        }
    }

    public void printStats() {
        System.out.println("=============  PHUI-MINER ALGORITHM - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Peak High-utility itemsets count : " + this.huiCount);
        System.out.println(" Join count : " + this.joinCount);
        System.out.println("===================================================");
    }

    class TWUPair {
        long currentTWU;
        long maxTWU;

        TWUPair() {
        }
    }

    class Pair {
        int item = 0;
        long utility = 0L;

        Pair() {
        }
    }
}

