/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.mHUIMiner;

import ca.pfv.spmf.algorithms.frequentpatterns.mHUIMiner.IHUPTreeMod;
import ca.pfv.spmf.algorithms.frequentpatterns.mHUIMiner.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.mHUIMiner.Node;
import ca.pfv.spmf.algorithms.frequentpatterns.mHUIMiner.UtilityList;
import ca.pfv.spmf.algorithms.frequentpatterns.mHUIMiner.UtilityTuple;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoMHUIMiner {
    private long startTimestamp = 0L;
    private long endTimestamp = 0L;
    private int huiCount = 0;
    private long totalUtility = 0L;
    private int minUtility = 0;
    private int joinCount = 0;
    private Map<Integer, Integer> mapItemToTWU;
    private Map<Integer, UtilityList> mapItemToUtilityList;
    private BufferedWriter writer = null;
    private final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minimumUtility) throws IOException {
        String thisLine;
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Integer>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                this.totalUtility += (long)transactionUtility;
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Integer twu = this.mapItemToTWU.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                }
            }
        }
        MemoryLogger.getInstance().checkMemory();
        try {
            this.minUtility = minimumUtility;
            IHUPTreeMod tree = new IHUPTreeMod();
            this.mapItemToUtilityList = new HashMap<Integer, UtilityList>();
            for (Integer itemID : this.mapItemToTWU.keySet()) {
                if (this.mapItemToTWU.get(itemID) < this.minUtility) continue;
                UtilityList uList = new UtilityList(itemID);
                this.mapItemToUtilityList.put(itemID, uList);
            }
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Item> revisedTransaction = new ArrayList<Item>();
                for (int i = 0; i < items.length; ++i) {
                    int item = Integer.parseInt(items[i]);
                    int utility = Integer.parseInt(utilityValues[i]);
                    Item element = new Item(item, utility);
                    if (this.mapItemToTWU.get(item) < this.minUtility) continue;
                    revisedTransaction.add(element);
                }
                ++tid;
                Collections.sort(revisedTransaction, new Comparator<Item>(){

                    @Override
                    public int compare(Item o1, Item o2) {
                        return AlgoMHUIMiner.this.compareItemsAsc(o1.getItemID(), o2.getItemID(), AlgoMHUIMiner.this.mapItemToTWU);
                    }
                });
                int remainingUtility = 0;
                for (int i = revisedTransaction.size() - 1; i >= 0; --i) {
                    Item item = (Item)revisedTransaction.get(i);
                    UtilityTuple uTuple = new UtilityTuple(tid, item.getUtility(), remainingUtility);
                    this.mapItemToUtilityList.get(item.getItemID()).addTuple(uTuple);
                    remainingUtility += item.getUtility();
                }
                tree.addTransaction(revisedTransaction, tid);
            }
            tree.createHeaderList(this.mapItemToTWU);
            MemoryLogger.getInstance().checkMemory();
            for (int i = tree.headerList.size() - 1; i >= 0; --i) {
                Integer itemID = tree.headerList.get(i);
                ArrayList<Integer> itemset2 = new ArrayList<Integer>();
                itemset2.add(itemID);
                UtilityList ulist = this.mapItemToUtilityList.get(itemID);
                if (ulist.sumIutils >= (long)this.minUtility) {
                    this.writeOut(itemset2, ulist.sumIutils);
                }
                if (ulist.sumIutils + ulist.sumRutils < (long)this.minUtility) continue;
                IHUPTreeMod localTree = this.createLocalTree(tree, itemID);
                MemoryLogger.getInstance().checkMemory();
                if (localTree.headerList.size() <= 0) continue;
                this.mHUIMiner(localTree, this.minUtility, itemset2, ulist.uLists);
                MemoryLogger.getInstance().checkMemory();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        this.writer.close();
    }

    private int compareItemsAsc(int item1, int item2, Map<Integer, Integer> mapItemEstimatedUtility) {
        int compare = mapItemEstimatedUtility.get(item1) - mapItemEstimatedUtility.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void mHUIMiner(IHUPTreeMod tree, int minUtility, ArrayList<Integer> itemset2, List<UtilityTuple> pTuples) throws IOException {
        for (int i = tree.headerList.size() - 1; i >= 0; --i) {
            Integer itemID = tree.headerList.get(i);
            UtilityList xUL = this.mapItemToUtilityList.get(itemID);
            itemset2.add(itemID);
            UtilityList pxTuples = this.construct(pTuples, xUL.uLists);
            MemoryLogger.getInstance().checkMemory();
            ++this.joinCount;
            if (pxTuples.sumIutils >= (long)minUtility) {
                this.writeOut(itemset2, pxTuples.sumIutils);
            }
            if (pxTuples.sumIutils + pxTuples.sumRutils >= (long)minUtility) {
                IHUPTreeMod localTree = this.createLocalTree(tree, itemID);
                MemoryLogger.getInstance().checkMemory();
                if (localTree.headerList.size() > 0) {
                    this.mHUIMiner(localTree, minUtility, itemset2, pxTuples.uLists);
                    MemoryLogger.getInstance().checkMemory();
                }
            }
            itemset2.remove(itemset2.size() - 1);
        }
    }

    private IHUPTreeMod createLocalTree(IHUPTreeMod tree, Integer itemID) {
        ArrayList prefixPaths = new ArrayList();
        Node pathStart = tree.mapItemNodes.get(itemID);
        while (pathStart != null) {
            if (pathStart.parent.itemID != -1) {
                ArrayList<Integer> prefixPath = new ArrayList<Integer>();
                Node parentnode = pathStart.parent;
                while (parentnode.itemID != -1) {
                    prefixPath.add(parentnode.itemID);
                    parentnode = parentnode.parent;
                }
                prefixPaths.add(prefixPath);
            }
            pathStart = pathStart.nodeLink;
        }
        IHUPTreeMod localTree = new IHUPTreeMod();
        for (List list : prefixPaths) {
            localTree.addLocalTransaction(list);
        }
        localTree.createHeaderList(this.mapItemToTWU);
        return localTree;
    }

    private UtilityList construct(List<UtilityTuple> pUL, List<UtilityTuple> xUL) {
        UtilityList pxUL = new UtilityList();
        for (UtilityTuple ep : pUL) {
            UtilityTuple ex = this.findElementWithTID(xUL, ep.getTid());
            if (ex == null) continue;
            UtilityTuple ePX = new UtilityTuple(ep.getTid(), ep.getIutils() + ex.getIutils(), ex.getRutils());
            pxUL.addTuple(ePX);
        }
        return pxUL;
    }

    private UtilityTuple findElementWithTID(List<UtilityTuple> ulist, int tid) {
        int first = 0;
        int last = ulist.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (ulist.get(middle).getTid() < tid) {
                first = middle + 1;
                continue;
            }
            if (ulist.get(middle).getTid() > tid) {
                last = middle - 1;
                continue;
            }
            return ulist.get(middle);
        }
        return null;
    }

    private void writeOut(ArrayList<Integer> HUI2, long utility) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        Collections.sort(HUI2);
        for (int i = 0; i < HUI2.size(); ++i) {
            buffer.append(HUI2.get(i));
            buffer.append(' ');
        }
        buffer.append("#UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  AlgoMHUIMiner v. 2.019 - STATS =============");
        System.out.println(" Total utility: " + this.totalUtility);
        System.out.println(" Minimum utility: " + this.minUtility);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Join count: " + this.joinCount);
        System.out.println(" HUIs count : " + this.huiCount);
        System.out.println("===================================================");
    }
}

