/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.mHUIMiner;

import ca.pfv.spmf.algorithms.frequentpatterns.mHUIMiner.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.mHUIMiner.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IHUPTreeMod {
    List<Integer> headerList = null;
    boolean hasMoreThanOnePath = false;
    Map<Integer, Node> mapItemNodes = new HashMap<Integer, Node>();
    Node root = new Node();
    Map<Integer, Node> mapItemLastNode = new HashMap<Integer, Node>();

    public void addTransaction(List<Item> transaction, int tid) {
        Node currentNode = this.root;
        for (int i = transaction.size() - 1; i >= 0; --i) {
            int itemID = transaction.get(i).getItemID();
            Node child = currentNode.getChildWithID(itemID);
            if (child == null) {
                currentNode = this.insertNewNode(currentNode, itemID);
                continue;
            }
            ++child.count;
            currentNode = child;
        }
    }

    public void addLocalTransaction(List<Integer> localPath) {
        Node currentlocalNode = this.root;
        for (int i = localPath.size() - 1; i >= 0; --i) {
            int itemID = localPath.get(i);
            Node child = currentlocalNode.getChildWithID(itemID);
            if (child == null) {
                currentlocalNode = this.insertNewNode(currentlocalNode, itemID);
                continue;
            }
            ++child.count;
            currentlocalNode = child;
        }
    }

    private Node insertNewNode(Node currentlocalNode, int itemID) {
        Node localheadernode;
        Node newNode = new Node();
        newNode.itemID = itemID;
        newNode.count = 1;
        newNode.parent = currentlocalNode;
        currentlocalNode.childs.add(newNode);
        if (!this.hasMoreThanOnePath && currentlocalNode.childs.size() > 1) {
            this.hasMoreThanOnePath = true;
        }
        if ((localheadernode = this.mapItemNodes.get(itemID)) == null) {
            this.mapItemNodes.put(itemID, newNode);
            this.mapItemLastNode.put(itemID, newNode);
        } else {
            Node lastNode = this.mapItemLastNode.get(itemID);
            lastNode.nodeLink = newNode;
            this.mapItemLastNode.put(itemID, newNode);
        }
        return newNode;
    }

    void createHeaderList(final Map<Integer, Integer> mapItemToTWU) {
        this.headerList = new ArrayList<Integer>(this.mapItemNodes.keySet());
        Collections.sort(this.headerList, new Comparator<Integer>(){

            @Override
            public int compare(Integer id1, Integer id2) {
                int compare = (Integer)mapItemToTWU.get(id2) - (Integer)mapItemToTWU.get(id1);
                if (compare == 0) {
                    return id1 - id2;
                }
                return compare;
            }
        });
    }

    public String toString() {
        String output = "";
        output = output + "HEADER TABLE: " + this.mapItemNodes + " \n";
        output = output + "hasMoreThanOnePath: " + this.hasMoreThanOnePath + " \n";
        return output + this.toString("", this.root);
    }

    public String toString(String indent, Node node) {
        String output = indent + node.toString() + "\n";
        String childsOutput = "";
        for (Node child : node.childs) {
            childsOutput = childsOutput + this.toString(indent + " ", child);
        }
        return output + childsOutput;
    }
}

