/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.mpfps;

import ca.pfv.spmf.algorithms.frequentpatterns.mpfps.SeqTidList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoMPFPS_BFS {
    double maxStandardDeviation = 10.0;
    double minRA = 0.0;
    int maxPeriodicity = 10;
    int minimumSupport = 2;
    int numOfSequences = 0;
    List<Integer> sequenceLengths = new ArrayList<Integer>();
    Map<int[], Double> result = new HashMap<int[], Double>();
    long totalTime;
    int patternCount;

    public void runAlgorithm(double maxStandardDeviation, double minRA, int maxPeriodicity, int minimumSupport, String inputFile, String outputFile) throws Exception {
        MemoryLogger.getInstance().reset();
        long startTime = System.currentTimeMillis();
        this.maxStandardDeviation = maxStandardDeviation;
        this.maxPeriodicity = maxPeriodicity;
        this.minRA = minRA;
        this.minimumSupport = minimumSupport;
        this.result = new HashMap<int[], Double>();
        this.sequenceLengths = new ArrayList<Integer>();
        this.numOfSequences = 0;
        List<SeqTidList> periodicFrequentPatterns = this.getFreqPeriodicPattern(inputFile);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        for (SeqTidList periodicPat : periodicFrequentPatterns) {
            out.println(periodicPat);
        }
        out.println();
        out.close();
        this.patternCount = periodicFrequentPatterns.size();
        MemoryLogger.getInstance().checkMemory();
        this.totalTime = System.currentTimeMillis() - startTime;
    }

    public void printStats() {
        System.out.println("=============  MPFPS_BFS v.2.40 - STATS =============");
        System.out.println("Pattern count: " + this.patternCount);
        System.out.println("Memory : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("Total time : " + this.totalTime + " ms");
        System.out.println("===================================================");
    }

    public List<List<SeqTidList>> getSingleItemTidList(String fileName) throws IOException {
        File file = new File(fileName);
        BufferedReader reader = null;
        String tempReader = null;
        ArrayList<SeqTidList> singleItemTidList = new ArrayList<SeqTidList>();
        int currentLine = 0;
        reader = new BufferedReader(new FileReader(file));
        while ((tempReader = reader.readLine()) != null) {
            if (tempReader.isEmpty() || tempReader.charAt(0) == '#' || tempReader.charAt(0) == '%' || tempReader.charAt(0) == '@') continue;
            String[] tempSplitted = tempReader.split(" ");
            int currentTran = 0;
            for (SeqTidList tempSeqTid : singleItemTidList) {
                tempSeqTid.newLine = true;
            }
            for (int i = 0; i < tempSplitted.length - 1; ++i) {
                boolean found = false;
                int temp = Integer.parseInt(tempSplitted[i]);
                int tempOfNext = Integer.parseInt(tempSplitted[i + 1]);
                if (temp != -1 && temp != -2) {
                    for (SeqTidList current : singleItemTidList) {
                        int lengthOfSequences = current.sequenceNum.size();
                        if (temp != current.itemSet[0]) continue;
                        if (current.sequenceNum.get(lengthOfSequences - 1) != currentLine) {
                            ArrayList<Integer> newTidSet = new ArrayList<Integer>();
                            newTidSet.add(currentTran);
                            current.seqTidSet.add(newTidSet);
                            current.sequenceNum.add(currentLine);
                            current.newLine = false;
                        } else {
                            int length = current.seqTidSet.size();
                            current.seqTidSet.get(length - 1).add(currentTran);
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    SeqTidList current = new SeqTidList(1);
                    current.itemSet[0] = temp;
                    current.seqTidSet.add(new ArrayList());
                    current.seqTidSet.get(0).add(currentTran);
                    current.sequenceNum.add(currentLine);
                    singleItemTidList.add(current);
                    continue;
                }
                if (temp == -1 && tempOfNext != -2) {
                    ++currentTran;
                    continue;
                }
                if (temp != -1 || tempOfNext != -2) continue;
                this.sequenceLengths.add(currentTran);
                break;
            }
            ++currentLine;
        }
        this.numOfSequences = currentLine;
        reader.close();
        ArrayList<SeqTidList> freMaxPrSingleTidList = new ArrayList<SeqTidList>();
        ArrayList<SeqTidList> periodicSingleTidList = new ArrayList<SeqTidList>();
        for (SeqTidList singleItemSeqTid : singleItemTidList) {
            int num = 0;
            SeqTidList freSingleItemSeqTid = new SeqTidList();
            freSingleItemSeqTid.itemSet = singleItemSeqTid.itemSet;
            SeqTidList periodicSingleItemSeqTid = new SeqTidList();
            periodicSingleItemSeqTid.itemSet = singleItemSeqTid.itemSet;
            for (List<Integer> currentTidList : singleItemSeqTid.seqTidSet) {
                boolean[] periodic = this.checkPeriodicity(currentTidList, this.sequenceLengths.get(singleItemSeqTid.sequenceNum.get(num)));
                if (periodic[0]) {
                    freSingleItemSeqTid.seqTidSet.add(currentTidList);
                    freSingleItemSeqTid.sequenceNum.add(singleItemSeqTid.sequenceNum.get(num));
                }
                if (periodic[1]) {
                    periodicSingleItemSeqTid.seqTidSet.add(currentTidList);
                    periodicSingleItemSeqTid.sequenceNum.add(singleItemSeqTid.sequenceNum.get(num));
                }
                ++num;
            }
            double freSingleBoundRa = (double)freSingleItemSeqTid.sequenceNum.size() / (double)this.numOfSequences;
            double periodicSingleRa = (double)periodicSingleItemSeqTid.sequenceNum.size() / (double)this.numOfSequences;
            if (!freSingleItemSeqTid.seqTidSet.isEmpty() && freSingleBoundRa >= this.minRA) {
                freMaxPrSingleTidList.add(freSingleItemSeqTid);
            }
            if (periodicSingleItemSeqTid.seqTidSet.isEmpty() || !(periodicSingleRa >= this.minRA)) continue;
            periodicSingleItemSeqTid.ra = periodicSingleRa;
            periodicSingleTidList.add(periodicSingleItemSeqTid);
        }
        ArrayList<List<SeqTidList>> freMaxPrAndPeriodicSingle = new ArrayList<List<SeqTidList>>();
        freMaxPrAndPeriodicSingle.add(freMaxPrSingleTidList);
        freMaxPrAndPeriodicSingle.add(periodicSingleTidList);
        return freMaxPrAndPeriodicSingle;
    }

    private boolean[] checkPeriodicity(List<Integer> currentTidSet, int lengthOfSequence) {
        int lastPeriod;
        boolean[] periodic = new boolean[]{true, true};
        if (currentTidSet.size() == 0 || currentTidSet.size() < this.minimumSupport) {
            periodic[0] = false;
            periodic[1] = false;
            return periodic;
        }
        int length = currentTidSet.size();
        int[] periods = new int[length + 1];
        int temp = 0;
        double avgPr = 0.0;
        int sum = 0;
        double sumDevi = 0.0;
        double stanDevi = 0.0;
        Collections.sort(currentTidSet);
        int firstPeriod = currentTidSet.get(0);
        if (firstPeriod < 0 || firstPeriod > this.maxPeriodicity) {
            periodic[0] = false;
        } else {
            periods[0] = firstPeriod;
        }
        for (int i = 0; i < length - 1; ++i) {
            temp = currentTidSet.get(i + 1) - currentTidSet.get(i);
            if (temp < 0 || temp > this.maxPeriodicity) {
                periodic[0] = false;
                break;
            }
            periods[i + 1] = temp;
            sum += temp;
        }
        if ((lastPeriod = lengthOfSequence - currentTidSet.get(length - 1)) < 0 || lastPeriod > this.maxPeriodicity) {
            periodic[0] = false;
        } else {
            periods[length] = lastPeriod;
        }
        if (periodic[0]) {
            avgPr = sum / length;
            for (int j = 0; j < periods.length; ++j) {
                sumDevi += ((double)periods[j] - avgPr) * ((double)periods[j] - avgPr);
            }
            stanDevi = Math.sqrt(sumDevi / (double)length);
            if (periodic[0] && stanDevi > this.maxStandardDeviation) {
                periodic[1] = false;
            }
        }
        return periodic;
    }

    public List<SeqTidList> getFreqPeriodicPattern(String fileName) throws IOException {
        List<List<SeqTidList>> frePeriodicSingleSeq = this.getSingleItemTidList(fileName);
        List<SeqTidList> freSingleItemTidlist = frePeriodicSingleSeq.get(0);
        List<SeqTidList> periodicSingleTidList = frePeriodicSingleSeq.get(1);
        ArrayList<SeqTidList> periodicPatterns = new ArrayList<SeqTidList>();
        for (SeqTidList periodicPattern : periodicSingleTidList) {
            periodicPatterns.add(periodicPattern);
        }
        List<List<SeqTidList>> freSeqTid = this.periodicFrequent(freSingleItemTidlist, this.minimumSupport);
        if (freSeqTid != null) {
            if (freSeqTid.size() == 2) {
                for (SeqTidList periodicPattern : freSeqTid.get(1)) {
                    periodicPatterns.add(periodicPattern);
                }
            }
            while (freSeqTid.get(0).size() >= 2) {
                freSeqTid = this.periodicFrequent(freSeqTid.get(0), this.minimumSupport);
                for (SeqTidList periodicPattern : freSeqTid.get(1)) {
                    periodicPatterns.add(periodicPattern);
                }
            }
        }
        return periodicPatterns;
    }

    public List<Integer> intersectTids(List<Integer> list1, List<Integer> list2) {
        ArrayList<Integer> common = new ArrayList<Integer>();
        for (int i = 0; i < list1.size(); ++i) {
            if (Collections.binarySearch(list2, list1.get(i)) < 0) continue;
            common.add(list1.get(i));
        }
        return common;
    }

    public int[] unionItemsets(int[] list1, int[] list2) {
        int len = list1.length;
        int[] unionItemSet = Arrays.copyOf(list1, len + 1);
        unionItemSet[len] = list2[len - 1];
        return unionItemSet;
    }

    public List<List<SeqTidList>> periodicFrequent(List<SeqTidList> tidlistOfTemp, int minSup) {
        ArrayList<SeqTidList> tempFreMaxPrTidList = new ArrayList<SeqTidList>();
        ArrayList<SeqTidList> tempPeriodicTidList = new ArrayList<SeqTidList>();
        ArrayList<List<SeqTidList>> freMaxPrAndPeriodic = new ArrayList<List<SeqTidList>>();
        for (int i = 0; i < tidlistOfTemp.size(); ++i) {
            SeqTidList currentTidListA = tidlistOfTemp.get(i);
            block1: for (int j = i + 1; j < tidlistOfTemp.size(); ++j) {
                SeqTidList currentTidListB = tidlistOfTemp.get(j);
                if (!this.haveSamePrefix(currentTidListA, currentTidListB)) continue;
                SeqTidList freMaxPrTidListAB = new SeqTidList();
                SeqTidList periodicTidListAB = new SeqTidList();
                freMaxPrTidListAB.itemSet = this.unionItemsets(currentTidListA.itemSet, currentTidListB.itemSet);
                Arrays.sort(freMaxPrTidListAB.itemSet);
                for (int item1 : freMaxPrTidListAB.itemSet) {
                    int[] itemset2 = new int[freMaxPrTidListAB.itemSet.length - 1];
                    int index = 0;
                    boolean found = false;
                    for (int item2 : freMaxPrTidListAB.itemSet) {
                        if (item2 == item1) continue;
                        itemset2[index++] = item2;
                    }
                    Object object = tidlistOfTemp.iterator();
                    while (object.hasNext()) {
                        SeqTidList temp = (SeqTidList)object.next();
                        if (!Arrays.equals(itemset2, temp.itemSet)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue block1;
                }
                List<Integer> interSequenceNum = this.intersectTids(currentTidListA.sequenceNum, currentTidListB.sequenceNum);
                for (int serial : interSequenceNum) {
                    int serialNumA = Collections.binarySearch(currentTidListA.sequenceNum, serial);
                    int serialNumB = Collections.binarySearch(currentTidListB.sequenceNum, serial);
                    List<Integer> tidSetA = currentTidListA.seqTidSet.get(serialNumA);
                    List<Integer> tidSetB = currentTidListB.seqTidSet.get(serialNumB);
                    List<Integer> interTidsAB = this.intersectTids(tidSetA, tidSetB);
                    boolean[] periodic = this.checkPeriodicity(interTidsAB, this.sequenceLengths.get(serial));
                    if (interTidsAB.isEmpty()) continue;
                    if (periodic[0]) {
                        freMaxPrTidListAB.seqTidSet.add(interTidsAB);
                        freMaxPrTidListAB.sequenceNum.add(serial);
                    }
                    if (!periodic[1]) continue;
                    periodicTidListAB.itemSet = freMaxPrTidListAB.itemSet;
                    periodicTidListAB.seqTidSet.add(interTidsAB);
                    periodicTidListAB.sequenceNum.add(serial);
                }
                double freMaxPrRa = (double)freMaxPrTidListAB.sequenceNum.size() / (double)this.numOfSequences;
                double periodicRa = (double)periodicTidListAB.sequenceNum.size() / (double)this.numOfSequences;
                if (!freMaxPrTidListAB.seqTidSet.isEmpty() && freMaxPrRa >= this.minRA) {
                    tempFreMaxPrTidList.add(freMaxPrTidListAB);
                }
                if (periodicTidListAB.seqTidSet.isEmpty() || !(periodicRa >= this.minRA)) continue;
                periodicTidListAB.ra = periodicRa;
                tempPeriodicTidList.add(periodicTidListAB);
            }
        }
        freMaxPrAndPeriodic.add(tempFreMaxPrTidList);
        freMaxPrAndPeriodic.add(tempPeriodicTidList);
        if (freMaxPrAndPeriodic.isEmpty()) {
            return null;
        }
        return freMaxPrAndPeriodic;
    }

    public boolean haveSamePrefix(SeqTidList list1, SeqTidList list2) {
        int length = list1.itemSet.length;
        boolean havaSamePrefix = false;
        boolean temp = true;
        if (list1.itemSet.length == 1 && list2.itemSet.length == 1) {
            havaSamePrefix = true;
        } else {
            for (int i = 0; i < length - 1; ++i) {
                if (list1.itemSet[i] == list2.itemSet[i]) continue;
                temp = false;
            }
            if (temp && list1.itemSet[length - 1] != list2.itemSet[length - 1]) {
                havaSamePrefix = true;
            }
        }
        return havaSamePrefix;
    }
}

