/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.nafcp;

import ca.pfv.spmf.algorithms.frequentpatterns.nafcp.FCI;
import ca.pfv.spmf.algorithms.frequentpatterns.nafcp.IntegerByRef;
import ca.pfv.spmf.algorithms.frequentpatterns.nafcp.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.nafcp.NC;
import ca.pfv.spmf.algorithms.frequentpatterns.nafcp.Product;
import ca.pfv.spmf.algorithms.frequentpatterns.nafcp.ProductDb;
import ca.pfv.spmf.algorithms.frequentpatterns.nafcp.WPPC_Node;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoNAFCP {
    int pre;
    int post;
    int minSupport;
    List<FCI> fcis_1;
    List<FCI> fcis;
    int numOfTrans;
    int outputCount;
    Map<Integer, Integer> hashI1;
    Map<Integer, List<Integer>> hashFCIs;
    long startTimestamp;
    long endTimestamp;
    BufferedWriter writer = null;

    ProductDb readFile(String filename) throws IOException {
        String line;
        ProductDb pDb = new ProductDb();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        int i = 0;
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            Product p = new Product();
            p.pID = ++i;
            for (String itemString : lineSplited = line.split(" ")) {
                Item item = new Item();
                item.name = Integer.parseInt(itemString);
                p.items.add(item);
            }
            pDb.products.add(p);
        }
        reader.close();
        return pDb;
    }

    void insertTree(Product p, WPPC_Node root) {
        while (p.items.size() > 0) {
            Item i = p.items.get(0);
            p.items.remove(0);
            boolean flag = false;
            WPPC_Node N = new WPPC_Node();
            for (int j = 0; j < root.childNodes.size(); ++j) {
                if (root.childNodes.get((int)j).item.name != i.name) continue;
                ++root.childNodes.get((int)j).item.frequency;
                N = root.childNodes.get(j);
                flag = true;
                break;
            }
            if (!flag) {
                N.item = i;
                N.item.frequency = 1;
                root.childNodes.add(N);
            }
            this.insertTree(p, N);
        }
    }

    void generateOrder(WPPC_Node root) {
        root.preOrder = this.pre++;
        for (int i = 0; i < root.childNodes.size(); ++i) {
            this.generateOrder(root.childNodes.get(i));
        }
        root.postOrder = this.post++;
    }

    void generateNCSets(WPPC_Node root) {
        if (root.item.name != -1) {
            int stt = this.hashI1.get(root.item.name);
            NC nc = new NC();
            nc.postOrder = root.postOrder;
            nc.preOrder = root.preOrder;
            nc.frequency = root.item.frequency;
            this.fcis_1.get((int)stt).nCs.add(nc);
        }
        for (int i = 0; i < root.childNodes.size(); ++i) {
            this.generateNCSets(root.childNodes.get(i));
        }
    }

    boolean N_list_check(List<NC> a, List<NC> b) {
        int i = 0;
        int j = 0;
        while (j < b.size() && i < a.size()) {
            NC aI = a.get(i);
            NC bJ = b.get(j);
            if (aI.preOrder < bJ.preOrder && aI.postOrder > bJ.postOrder) {
                ++j;
                continue;
            }
            ++i;
        }
        return j == b.size();
    }

    List<Integer> itemUnion(List<Integer> a, List<Integer> b) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        int j = 0;
        while (i < a.size() && j < b.size()) {
            int bJ;
            int aI = a.get(i);
            if (aI > (bJ = b.get(j).intValue())) {
                result.add(aI);
                ++i;
                continue;
            }
            if (aI == bJ) {
                result.add(aI);
                ++i;
                ++j;
                continue;
            }
            result.add(bJ);
            ++j;
        }
        while (i < a.size()) {
            result.add(a.get(i));
            ++i;
        }
        while (j < b.size()) {
            result.add(b.get(j));
            ++j;
        }
        return result;
    }

    List<NC> ncCombination(List<NC> a, List<NC> b, int totalFrequency, IntegerByRef g) {
        ArrayList<NC> result = new ArrayList<NC>();
        int i = 0;
        int j = 0;
        int subFrequency = totalFrequency;
        while (i < a.size() && j < b.size()) {
            NC aI = a.get(i);
            NC bJ = b.get(j);
            if (aI.preOrder < bJ.preOrder) {
                if (aI.postOrder > bJ.postOrder) {
                    if (result.size() > 0 && ((NC)result.get((int)(result.size() - 1))).preOrder == aI.preOrder) {
                        ((NC)result.get((int)(result.size() - 1))).frequency += bJ.frequency;
                    } else {
                        NC temp = new NC();
                        temp.postOrder = aI.postOrder;
                        temp.preOrder = aI.preOrder;
                        temp.frequency = bJ.frequency;
                        result.add(temp);
                    }
                    g.value += bJ.frequency;
                    ++j;
                } else {
                    subFrequency -= aI.frequency;
                    ++i;
                }
            } else {
                subFrequency -= bJ.frequency;
                ++j;
            }
            if (subFrequency >= this.minSupport) continue;
            return null;
        }
        return result;
    }

    boolean subsetCheck(List<Integer> a, List<Integer> b) {
        if (a.size() > b.size()) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < a.size() && j < b.size()) {
            int bJ;
            int aI = a.get(i);
            if (aI > (bJ = b.get(j).intValue())) {
                return false;
            }
            if (aI == bJ) {
                ++i;
                ++j;
                continue;
            }
            ++j;
        }
        return i >= a.size();
    }

    boolean subsumptionCheck(FCI f) {
        List<Integer> arr = this.hashFCIs.get(f.frequency);
        if (arr != null) {
            for (int i = 0; i < arr.size(); ++i) {
                if (!this.subsetCheck(f.items, this.fcis.get((int)arr.get((int)i).intValue()).items)) continue;
                return true;
            }
        }
        return false;
    }

    void findFCIs(List<FCI> Is, int level) throws IOException {
        for (int i = Is.size() - 1; i >= 0; --i) {
            FCI IsI = Is.get(i);
            ArrayList<FCI> FCIs_Next = new ArrayList<FCI>();
            for (int j = i - 1; j >= 0; --j) {
                FCI IsJ = Is.get(j);
                if (this.N_list_check(IsJ.nCs, IsI.nCs)) {
                    if (IsI.frequency == IsJ.frequency) {
                        IsI.items = this.itemUnion(IsI.items, IsJ.items);
                        Is.remove(j);
                        --i;
                        continue;
                    }
                    IsI.items = this.itemUnion(IsI.items, IsJ.items);
                    for (int k = 0; k < FCIs_Next.size(); ++k) {
                        ((FCI)FCIs_Next.get((int)k)).items = this.itemUnion(((FCI)FCIs_Next.get((int)k)).items, IsJ.items);
                    }
                    continue;
                }
                FCI f = new FCI();
                f.items = this.itemUnion(IsI.items, IsJ.items);
                IntegerByRef g = new IntegerByRef(0);
                f.nCs = this.ncCombination(IsJ.nCs, IsI.nCs, IsJ.frequency + IsI.frequency, g);
                if (g.value < this.minSupport) continue;
                f.frequency = g.value;
                FCIs_Next.add(0, f);
            }
            if (!this.subsumptionCheck(IsI)) {
                this.fcis.add(IsI);
                this.writer.write(IsI.toString());
                this.writer.write("\n");
                if (this.hashFCIs.get(IsI.frequency) == null) {
                    ArrayList<Integer> ar = new ArrayList<Integer>();
                    ar.add(this.fcis.size() - 1);
                    this.hashFCIs.put(IsI.frequency, ar);
                } else {
                    List<Integer> ar = this.hashFCIs.get(IsI.frequency);
                    ar.add(this.fcis.size() - 1);
                    this.hashFCIs.put(IsI.frequency, ar);
                }
            }
            this.findFCIs(FCIs_Next, level + 1);
        }
    }

    void getData(String filename, double minSupport) throws IOException {
        String line;
        this.numOfTrans = 0;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            ++this.numOfTrans;
            for (String itemString : lineSplited = line.split(" ")) {
                Integer item = Integer.parseInt(itemString);
                Integer count = (Integer)mapItemCount.get(item);
                if (count == null) {
                    mapItemCount.put(item, 1);
                    continue;
                }
                count = count + 1;
                mapItemCount.put(item, count);
            }
        }
        reader.close();
        this.minSupport = (int)Math.ceil(minSupport * (double)this.numOfTrans);
        int numOfItems = mapItemCount.size();
        Item[] tempItems = new Item[numOfItems];
        int i = 0;
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() < this.minSupport) continue;
            tempItems[i] = new Item();
            tempItems[i].name = (Integer)entry.getKey();
            tempItems[i].frequency = (Integer)entry.getValue();
            ++i;
        }
        Item[] item = new Item[i];
        System.arraycopy(tempItems, 0, item, 0, i);
    }

    public void runAlgorithm(String filename, double minSupport, String output) throws IOException {
        int i;
        MemoryLogger.getInstance().reset();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.startTimestamp = System.currentTimeMillis();
        this.fcis_1 = new ArrayList<FCI>();
        this.fcis = new ArrayList<FCI>();
        this.hashI1 = new HashMap<Integer, Integer>();
        this.hashFCIs = new HashMap<Integer, List<Integer>>();
        this.pre = 0;
        this.post = 0;
        ProductDb pDB = this.readFile(filename);
        this.numOfTrans = pDB.products.size();
        this.minSupport = (int)Math.ceil((double)pDB.products.size() * minSupport);
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        for (i = 0; i < pDB.products.size(); ++i) {
            Product pi = pDB.products.get(i);
            for (int j = pi.items.size() - 1; j >= 0; --j) {
                Integer item = pi.items.get((int)j).name;
                Integer count = (Integer)mapItemCount.get(item);
                if (count == null) {
                    mapItemCount.put(item, 1);
                    continue;
                }
                count = count + 1;
                mapItemCount.put(item, count);
            }
        }
        i = 0;
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() < this.minSupport) continue;
            FCI f = new FCI();
            f.items.add((Integer)entry.getKey());
            f.frequency = (Integer)entry.getValue();
            this.fcis_1.add(f);
            ++i;
        }
        Collections.sort(this.fcis_1, FCI.fc);
        for (i = 0; i < this.fcis_1.size(); ++i) {
            this.hashI1.put(this.fcis_1.get((int)i).items.get(0), i);
        }
        WPPC_Node root = new WPPC_Node();
        root.item.name = -1;
        for (i = 0; i < pDB.products.size(); ++i) {
            Product product = pDB.products.get(i);
            for (int l = product.items.size() - 1; l >= 0; --l) {
                Item il = product.items.get(l);
                if (this.hashI1.get(il.name) == null) {
                    product.items.remove(l);
                    continue;
                }
                il.frequency = this.fcis_1.get((int)this.hashI1.get((Object)Integer.valueOf((int)il.name)).intValue()).frequency;
            }
            product.Sort();
            this.insertTree(product, root);
        }
        pDB = null;
        this.generateOrder(root);
        this.generateNCSets(root);
        this.findFCIs(this.fcis_1, 1);
        this.outputCount = this.fcis.size();
        this.writer.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void printStats() {
        System.out.println("========== NAFCP - STATS ============");
        System.out.println(" Minsup : " + this.minSupport);
        System.out.println(" Number of transactions: " + this.numOfTrans);
        System.out.println(" Number of frequent 1-items  : " + this.fcis_1.size());
        System.out.println(" Number of closed  itemsets: " + this.outputCount);
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("=====================================");
    }
}

