/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.negFIN;

class MyBitVector {
    static long[] TWO_POWER = new long[64];
    long[] bits;
    private int cardinality;

    public MyBitVector(int numOfBits) {
        this.bits = new long[(numOfBits - 1) / 64 + 1];
        this.cardinality = 0;
    }

    public MyBitVector(int[] itemset2, int last) {
        int length = itemset2[0];
        this.bits = new long[length / 64 + 1];
        this.cardinality = last;
        for (int i = 0; i < last; ++i) {
            int item = itemset2[i];
            int n = item / 64;
            this.bits[n] = this.bits[n] | TWO_POWER[item % 64];
        }
    }

    public Object clone() {
        MyBitVector result = new MyBitVector(this.bits.length * 64);
        result.cardinality = this.cardinality;
        System.arraycopy(this.bits, 0, result.bits, 0, result.bits.length);
        return result;
    }

    public void set(int bitIndex) {
        int n = bitIndex / 64;
        this.bits[n] = this.bits[n] | TWO_POWER[bitIndex % 64];
    }

    public boolean isSet(int bitIndex) {
        return (this.bits[bitIndex / 64] & TWO_POWER[bitIndex % 64]) != 0L;
    }

    public boolean isSubSet(MyBitVector q) {
        if (this.cardinality >= q.cardinality) {
            return false;
        }
        for (int i = 0; i < this.bits.length; ++i) {
            if ((this.bits[i] & (q.bits[i] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < TWO_POWER.length; ++i) {
            MyBitVector.TWO_POWER[i] = (long)Math.pow(2.0, i);
        }
    }
}

