/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.opusminer;

import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.FilterItemsets;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.FindItemsets;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.Global;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.LoadData;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.PrintItemsets;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.itemsetRec;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.PriorityQueue;

public class AlgoOpusMiner {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    BufferedWriter writer = null;
    static PriorityQueue<itemsetRec> itemsets = new PriorityQueue();
    private int nonRedundantProductiveItemsetsCount;
    boolean DEBUG = false;

    public void runAlgorithm(String inputFileName, String outputFileName, boolean printClosure, boolean filter, int k, boolean searchByLift, boolean correctionForMultiCompare, boolean redundancyTests, boolean isCSVInputFile) throws IOException {
        Global.correctionForMultCompare = correctionForMultiCompare;
        Global.printClosures = printClosure;
        Global.filter = filter;
        Global.k = k;
        Global.searchByLift = searchByLift;
        Global.redundancyTests = redundancyTests;
        itemsets.clear();
        ArrayList<itemsetRec> is = new ArrayList<itemsetRec>();
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        System.out.printf("Loading data from %s\n", inputFileName);
        if (isCSVInputFile) {
            LoadData.loadCSVdata(inputFileName);
        } else {
            LoadData.load_data(inputFileName);
        }
        System.out.printf("%d transactions, %d items\n", Global.noOfTransactions, Global.noOfItems);
        this.writer = new BufferedWriter(new FileWriter(outputFileName));
        System.out.print("Finding itemsets\n");
        FindItemsets.find_itemsets();
        while (!itemsets.isEmpty()) {
            is.add(itemsets.peek());
            itemsets.poll();
        }
        if (filter) {
            System.out.print("Filtering itemsets\n");
            FilterItemsets.filter_itemsets(is);
        }
        this.nonRedundantProductiveItemsetsCount = is.size();
        System.out.print("Printing itemsets\n");
        PrintItemsets.print_itemsets(this.writer, is, isCSVInputFile, searchByLift);
        MemoryLogger.getInstance().checkMemory();
        if (this.DEBUG) {
            this.writer.newLine();
            this.writer.write("ITEM NAMES\n");
            for (int i = 0; i < Global.itemNames.size(); ++i) {
                this.writer.write("" + i + " -> " + Global.itemNames.get(i) + "\n");
            }
        }
        this.writer.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void printStats() {
        String nonRedundant = Global.redundancyTests ? "Non-redundant" : "";
        String independently = Global.filter ? " Independantly" : "";
        System.out.println("=============  Opus-Miner algorithm v2.40 - STATS =======");
        System.out.println(" " + nonRedundant + independently + " productive itemset count: " + this.nonRedundantProductiveItemsetsCount);
        for (int i = 2; i < Global.alpha.size(); ++i) {
            System.out.println("  Alpha for size " + i + " " + Global.alpha.get(i));
        }
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Transaction count: " + Global.noOfTransactions + " Item count: " + Global.noOfItems);
        System.out.println("===========================================================");
    }
}

