/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.opusminer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class tidset
extends ArrayList<Integer> {
    private static final long serialVersionUID = 1L;

    public static int countIntersection(tidset s1, tidset s2) {
        if (s1.size() == 0 || s2.size() == 0) {
            return 0;
        }
        Iterator it1 = s1.iterator();
        Integer v1 = (Integer)it1.next();
        Iterator it2 = s2.iterator();
        Integer v2 = (Integer)it2.next();
        int count = 0;
        while (true) {
            if (v1.intValue() == v2.intValue()) {
                ++count;
                if (!it1.hasNext()) break;
                v1 = (Integer)it1.next();
                if (!it2.hasNext()) break;
                v2 = (Integer)it2.next();
                continue;
            }
            if (v1 < v2) {
                if (!it1.hasNext()) break;
                v1 = (Integer)it1.next();
                continue;
            }
            if (!it2.hasNext()) break;
            v2 = (Integer)it2.next();
        }
        return count;
    }

    public static void intersection(tidset result, tidset s1, tidset s2) {
        result.ensureCapacity(Math.min(s1.size(), s2.size()));
        result.clear();
        if (s1.size() == 0 || s2.size() == 0) {
            return;
        }
        Iterator it1 = s1.iterator();
        Iterator it2 = s2.iterator();
        Integer v1 = (Integer)it1.next();
        Integer v2 = (Integer)it2.next();
        while (true) {
            if (v1.intValue() == v2.intValue()) {
                result.add(v1);
                if (!it1.hasNext()) break;
                v1 = (Integer)it1.next();
                if (!it2.hasNext()) break;
                v2 = (Integer)it2.next();
                continue;
            }
            if (v1 < v2) {
                if (!it1.hasNext()) break;
                v1 = (Integer)it1.next();
                continue;
            }
            if (!it2.hasNext()) break;
            v2 = (Integer)it2.next();
        }
    }

    public static void dintersection(tidset s1, tidset s2) {
        if (s1.size() == 0) {
            return;
        }
        if (s2.size() == 0) {
            s1.clear();
            return;
        }
        int from = 0;
        int to = 0;
        Iterator it1 = s1.iterator();
        Integer v1 = (Integer)it1.next();
        Iterator it2 = s2.iterator();
        Integer v2 = (Integer)it2.next();
        while (true) {
            if (v1.intValue() == v2.intValue()) {
                s1.set(to++, (Integer)s1.get(from++));
                if (from == s1.size()) break;
                v1 = (Integer)it1.next();
                if (!it2.hasNext()) break;
                v2 = (Integer)it2.next();
                continue;
            }
            if (v1 < v2) {
                if (++from == s1.size()) break;
                v1 = (Integer)it1.next();
                continue;
            }
            if (!it2.hasNext()) break;
            v2 = (Integer)it2.next();
        }
        tidset.resize(s1, to);
    }

    public static <T> void resize(ArrayList<T> list, int newSize) {
        block3: {
            Object value;
            block2: {
                value = null;
                if (list.size() <= newSize) break block2;
                for (int i = list.size() - 1; i >= newSize; --i) {
                    list.remove(i);
                }
                break block3;
            }
            if (list.size() >= newSize) break block3;
            for (int i = list.size(); i < newSize; ++i) {
                list.add(value);
            }
        }
    }

    public static tidset dunion(tidset s1, tidset s2) {
        tidset result = new tidset();
        result.addAll(s1);
        for (Integer tid : s2) {
            if (result.contains(tid)) continue;
            result.add(tid);
        }
        Collections.sort(result);
        return result;
    }
}

