/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.relim;

import ca.pfv.spmf.algorithms.frequentpatterns.relim.DatabaseStructureRelim;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoRelim {
    private long startTimestamp;
    private long endTimestamp;
    private int relativeMinsupp;
    private int[] items;
    BufferedWriter writer = null;
    private int frequentCount;

    public void runAlgorithm(double minsupp, String input, String output) throws IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.frequentCount = 0;
        MemoryLogger.getInstance().reset();
        int transactionCount = 0;
        final HashMap<Integer, Integer> mapSupport = new HashMap<Integer, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            for (String itemString : lineSplited = line.split(" ")) {
                Integer item = Integer.parseInt(itemString);
                Integer count = (Integer)mapSupport.get(item);
                if (count == null) {
                    mapSupport.put(item, 1);
                    continue;
                }
                count = count + 1;
                mapSupport.put(item, count);
            }
            ++transactionCount;
        }
        reader.close();
        this.relativeMinsupp = (int)Math.ceil(minsupp * (double)transactionCount);
        ArrayList<Integer> listItems = new ArrayList<Integer>();
        for (Map.Entry entry : mapSupport.entrySet()) {
            Integer item = (Integer)entry.getKey();
            if ((Integer)mapSupport.get(item) < this.relativeMinsupp) continue;
            listItems.add(item);
        }
        Collections.sort(listItems, new Comparator<Integer>(){

            @Override
            public int compare(Integer item1, Integer item2) {
                int compare = (Integer)mapSupport.get(item1) - (Integer)mapSupport.get(item2);
                if (compare == 0) {
                    return item1 - item2;
                }
                return compare;
            }
        });
        int[] supports = new int[listItems.size()];
        this.items = new int[listItems.size()];
        for (int i = 0; i < listItems.size(); ++i) {
            this.items[i] = (Integer)listItems.get(i);
        }
        DatabaseStructureRelim initialDatabase = new DatabaseStructureRelim(supports);
        initialDatabase.initializeTransactions();
        reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            int indexArray;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            ArrayList<Integer> transaction = new ArrayList<Integer>();
            for (String itemString : lineSplited) {
                Integer item = Integer.parseInt(itemString);
                if ((Integer)mapSupport.get(item) < this.relativeMinsupp) continue;
                transaction.add(item);
            }
            if (transaction.size() == 0) continue;
            Collections.sort(transaction, new Comparator<Integer>(){

                @Override
                public int compare(Integer item1, Integer item2) {
                    int compare = (Integer)mapSupport.get(item1) - (Integer)mapSupport.get(item2);
                    if (compare == 0) {
                        return item1 - item2;
                    }
                    return compare;
                }
            });
            int firstItem = (Integer)transaction.get(0);
            int n = indexArray = listItems.indexOf(firstItem);
            supports[n] = supports[n] + 1;
            initialDatabase.transactions.get(indexArray).add(transaction.subList(1, transaction.size()));
        }
        reader.close();
        this.recursion(initialDatabase, new int[0]);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void recursion(DatabaseStructureRelim database, int[] prefix) throws IOException {
        for (int i = 0; i < this.items.length; ++i) {
            if (database.supports[i] <= 0) continue;
            if (database.supports[i] >= this.relativeMinsupp) {
                this.writeOut(this.items[i], prefix, database.supports[i]);
            }
            database.supports[i] = 0;
            int[] newSupportPrefix = new int[database.supports.length];
            DatabaseStructureRelim databasePrefix = new DatabaseStructureRelim(newSupportPrefix);
            databasePrefix.initializeTransactions();
            for (List<Integer> transaction : database.transactions.get(i)) {
                int index;
                if (transaction.size() == 0) continue;
                Integer firstItem = transaction.get(0);
                int n = index = this.getIndexOf(firstItem);
                database.supports[n] = database.supports[n] + 1;
                int n2 = index;
                newSupportPrefix[n2] = newSupportPrefix[n2] + 1;
                if (transaction.size() < 2) continue;
                List<Integer> subList = transaction.subList(1, transaction.size());
                databasePrefix.transactions.get(index).add(subList);
                database.transactions.get(index).add(subList);
            }
            int[] newPrefix = new int[prefix.length + 1];
            System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
            newPrefix[prefix.length] = this.items[i];
            this.recursion(databasePrefix, newPrefix);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private int getIndexOf(int item) {
        for (int i = 0; i < this.items.length; ++i) {
            if (item != this.items[i]) continue;
            return i;
        }
        return -1;
    }

    private void writeOut(int item, int[] prefix, int support) throws IOException {
        ++this.frequentCount;
        StringBuilder buffer = new StringBuilder();
        buffer.append(item);
        buffer.append(" ");
        for (int i = 0; i < prefix.length; ++i) {
            buffer.append(prefix[i]);
            if (i == prefix.length - 1) continue;
            buffer.append(' ');
        }
        buffer.append(" #SUP: ");
        buffer.append(support);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStatistics() {
        System.out.println("========== RELIM - STATS ============");
        System.out.println(" Number of frequent  itemsets: " + this.frequentCount);
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("=====================================");
    }
}

