/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.rpgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.rpgrowth.RPNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RPTree {
    List<Integer> headerList = null;
    Map<Integer, RPNode> mapItemNodes = new HashMap<Integer, RPNode>();
    Map<Integer, RPNode> mapItemLastNode = new HashMap<Integer, RPNode>();
    RPNode root = new RPNode();

    public void addTransaction(List<Integer> transaction) {
        RPNode currentNode = this.root;
        for (Integer item : transaction) {
            RPNode child = currentNode.getChildWithID(item);
            if (child == null) {
                RPNode newNode = new RPNode();
                newNode.itemID = item;
                newNode.parent = currentNode;
                currentNode.childs.add(newNode);
                currentNode = newNode;
                this.fixNodeLinks(item, newNode);
                continue;
            }
            ++child.counter;
            currentNode = child;
        }
    }

    private void fixNodeLinks(Integer item, RPNode newNode) {
        RPNode lastNode = this.mapItemLastNode.get(item);
        if (lastNode != null) {
            lastNode.nodeLink = newNode;
        }
        this.mapItemLastNode.put(item, newNode);
        RPNode headernode = this.mapItemNodes.get(item);
        if (headernode == null) {
            this.mapItemNodes.put(item, newNode);
        }
    }

    void addPrefixPath(List<RPNode> prefixPath, Map<Integer, Integer> mapSupportBeta, int relativeMinsupp, int relativeMinRareSupp) {
        int pathCount = prefixPath.get((int)0).counter;
        RPNode currentNode = this.root;
        for (int i = prefixPath.size() - 1; i >= 1; --i) {
            RPNode pathItem = prefixPath.get(i);
            if (mapSupportBeta.get(pathItem.itemID) >= relativeMinsupp || mapSupportBeta.get(pathItem.itemID) < relativeMinRareSupp) continue;
            RPNode child = currentNode.getChildWithID(pathItem.itemID);
            if (child == null) {
                RPNode newNode = new RPNode();
                newNode.itemID = pathItem.itemID;
                newNode.parent = currentNode;
                newNode.counter = pathCount;
                currentNode.childs.add(newNode);
                currentNode = newNode;
                this.fixNodeLinks(pathItem.itemID, newNode);
                continue;
            }
            child.counter += pathCount;
            currentNode = child;
        }
    }

    void createHeaderList(final Map<Integer, Integer> mapSupport) {
        this.headerList = new ArrayList<Integer>(this.mapItemNodes.keySet());
        Collections.sort(this.headerList, new Comparator<Integer>(){

            @Override
            public int compare(Integer id1, Integer id2) {
                int compare = (Integer)mapSupport.get(id2) - (Integer)mapSupport.get(id1);
                return compare == 0 ? id1 - id2 : compare;
            }
        });
    }

    public String toString() {
        String temp = "F";
        temp = temp + " HeaderList: " + this.headerList + "\n";
        temp = temp + this.root.toString("");
        return temp;
    }
}

