/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.skymine;

import ca.pfv.spmf.algorithms.frequentpatterns.skymine.ItemsetUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class UtilityInterval {
    ArrayList<Interval> intervalSet = new ArrayList();
    private long currentMaxMin = 0L;

    public void insertUtilityInt(long xL, long yH, int[] itemset2) {
        if (this.currentMaxMin < yH) {
            Interval inV = new Interval(xL, yH, itemset2);
            if (!this.filterUtilityIntervals(xL, itemset2)) {
                this.intervalSet.add(inV);
            }
        }
        if (xL > this.currentMaxMin) {
            this.currentMaxMin = xL;
        }
    }

    public long getUtilityValue() {
        if (this.intervalSet.size() > 0) {
            return this.currentMaxMin;
        }
        return 0L;
    }

    private boolean filterUtilityIntervals(long xL, int[] itemset2) {
        boolean itemsubsetflag = false;
        for (int i = this.intervalSet.size() - 1; i >= 0; --i) {
            if (this.isSuperItemSet(this.intervalSet.get((int)i).itemset, itemset2)) {
                itemsubsetflag = true;
            }
            if (this.intervalSet.get(i).getHigh() >= xL && !this.isSuperItemSet(itemset2, this.intervalSet.get((int)i).itemset)) continue;
            this.intervalSet.remove(i);
        }
        return itemsubsetflag;
    }

    private boolean isSuperItemSet(int[] itemsetR, int[] itemsetOther) {
        if (itemsetR == null && itemsetOther == null) {
            return false;
        }
        if (itemsetOther == null) {
            return true;
        }
        if (itemsetR == null) {
            return false;
        }
        HashSet<Integer> referenceSet = new HashSet<Integer>();
        for (int i = 0; i < itemsetR.length; ++i) {
            referenceSet.add(itemsetR[i]);
        }
        HashSet<Integer> otherSet = new HashSet<Integer>();
        for (int i = 0; i < itemsetOther.length; ++i) {
            otherSet.add(itemsetOther[i]);
        }
        if (referenceSet.containsAll(otherSet) && otherSet.containsAll(referenceSet)) {
            return false;
        }
        return referenceSet.containsAll(otherSet);
    }

    public ArrayList<int[]> getItemSets() {
        ArrayList<int[]> resultSet = new ArrayList<int[]>();
        for (int i = 0; i < this.intervalSet.size(); ++i) {
            Interval intervalI = this.intervalSet.get(i);
            int[] itemsetArray = intervalI.getItemset();
            if (itemsetArray == null) continue;
            Arrays.sort(itemsetArray);
            resultSet.add(itemsetArray);
        }
        return resultSet;
    }

    public ArrayList<ItemsetUtility> getItemSetsWithUtilities() {
        ArrayList<ItemsetUtility> resultSet = new ArrayList<ItemsetUtility>();
        for (int i = 0; i < this.intervalSet.size(); ++i) {
            Interval intervalI = this.intervalSet.get(i);
            int[] itemsetArray = intervalI.getItemset();
            if (itemsetArray == null) continue;
            Arrays.sort(itemsetArray);
            ItemsetUtility itemsetUtility = new ItemsetUtility();
            itemsetUtility.itemset = itemsetArray;
            itemsetUtility.utility = intervalI.getHigh();
            resultSet.add(itemsetUtility);
        }
        return resultSet;
    }

    public String toString(int[] reconversionArray) {
        String result = "";
        for (int i = 0; i < this.intervalSet.size(); ++i) {
            if (this.intervalSet.get((int)i).itemset == null) continue;
            result = result + " (" + this.intervalSet.get(i).getLow() + "," + this.intervalSet.get(i).getHigh() + ":" + Arrays.toString(this.convert(this.intervalSet.get((int)i).itemset, reconversionArray)) + ")";
        }
        return result;
    }

    private int[] convert(int[] items, int[] reconversionArray) {
        if (reconversionArray == null) {
            return items;
        }
        if (items == null) {
            return null;
        }
        int[] newItemSet = new int[items.length];
        for (int index = 0; index < newItemSet.length; ++index) {
            newItemSet[index] = reconversionArray[items[index]];
        }
        return newItemSet;
    }

    private class Interval
    implements Comparable<Interval> {
        long low;
        long high;
        int[] itemset;

        Interval(long xL, long xH, int[] items) {
            this.low = xL;
            this.high = xH;
            this.itemset = items;
        }

        public int[] getItemset() {
            return this.itemset;
        }

        public long getLow() {
            return this.low;
        }

        public long getHigh() {
            return this.high;
        }

        @Override
        public int compareTo(Interval other) {
            return (int)(other.getLow() - this.getLow());
        }
    }
}

