/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.Itemsets;
import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.SPPNode;
import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.SPPTree;
import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.Support_maxla;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoSPPgrowth {
    private long startTimestamp;
    private long endTime;
    private int lastTID = -1;
    private int itemsetCount;
    BufferedWriter writer = null;
    protected Itemsets patterns = null;
    final int BUFFERS_SIZE = 2000;
    private int[] itemsetBuffer = null;
    private int[] itemsetOutputBuffer = null;
    private int maxPatternLength = 1000;
    private boolean self_increment;
    private int minSup;
    private int maxPer;
    private int maxLa;

    public Itemsets runAlgorithm(String input, String output, int maxPer, int minSup, int maxLa, boolean self_increment) throws FileNotFoundException, IOException {
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        this.minSup = minSup;
        this.maxPer = maxPer;
        this.self_increment = self_increment;
        this.maxLa = maxLa;
        MemoryLogger.getInstance().reset();
        MemoryLogger.getInstance().checkMemory();
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("Periodic Frequent Time-Interval of Itemsets");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
            this.itemsetOutputBuffer = new int[2000];
        }
        Map<Integer, Support_maxla> mapSPP_list = this.scanDatabaseToDeterminSPPlistOfSingleItems(input);
        SPPTree tree = new SPPTree();
        this.buildTreeByScanDataAgain(tree, input, mapSPP_list);
        System.out.println("# of node : " + tree.numOfNode);
        if (tree.headerList.size() > 0) {
            this.itemsetBuffer = new int[2000];
            this.SPPGrowth(tree, this.itemsetBuffer, 0, mapSPP_list);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        return this.patterns;
    }

    private void SPPGrowth(SPPTree tree, int[] prefix, int prefixLength, Map<Integer, Support_maxla> mapSPP_list) throws IOException {
        if (prefixLength == this.maxPatternLength) {
            return;
        }
        while (tree.headerList.size() > 0) {
            Integer item = tree.headerList.get(tree.headerList.size() - 1);
            prefix[prefixLength] = item;
            this.saveItemset(prefix, prefixLength + 1, mapSPP_list.get(item).getSupport(), mapSPP_list.get(item).getMaxla());
            if (prefixLength + 1 >= this.maxPatternLength) continue;
            ArrayList prefixPaths = new ArrayList();
            SPPNode path = tree.mapItemNodes.get(item);
            HashMap<Integer, List<Integer>> mapBetaTIDs = new HashMap<Integer, List<Integer>>();
            while (path != null) {
                if (path.parent.itemID != -1) {
                    ArrayList<SPPNode> prefixPath = new ArrayList<SPPNode>();
                    prefixPath.add(path);
                    final List<Integer> pathTIDs = path.TIDs;
                    SPPNode parent = path.parent;
                    while (parent.itemID != -1) {
                        prefixPath.add(parent);
                        if (mapBetaTIDs.get(parent.itemID) == null) {
                            mapBetaTIDs.put(parent.itemID, (List<Integer>)new ArrayList<Integer>(){
                                {
                                    this.addAll(pathTIDs);
                                }
                            });
                        } else {
                            ((List)mapBetaTIDs.get(parent.itemID)).addAll(pathTIDs);
                        }
                        parent = parent.parent;
                    }
                    prefixPaths.add(prefixPath);
                }
                path = path.nodeLink;
            }
            Map<Integer, Support_maxla> mapBetaSPPlist = this.getMapBetaSPPlist(mapBetaTIDs);
            if (mapBetaSPPlist.size() > 0) {
                SPPTree treeBeta = new SPPTree();
                for (List list : prefixPaths) {
                    treeBeta.addPrefixPath(list, mapBetaSPPlist);
                }
                if (treeBeta.root.childs.size() > 0) {
                    treeBeta.createHeaderList(tree.headerList, mapBetaSPPlist);
                    this.SPPGrowth(treeBeta, prefix, prefixLength + 1, mapBetaSPPlist);
                }
            }
            tree.removeTailItem();
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private Map<Integer, Support_maxla> getMapBetaSPPlist(Map<Integer, List<Integer>> mapBetaTIDs) {
        HashMap<Integer, Support_maxla> mapBetaSPPlist = new HashMap<Integer, Support_maxla>();
        for (Map.Entry<Integer, List<Integer>> entry : mapBetaTIDs.entrySet()) {
            Support_maxla sm = new Support_maxla();
            List<Integer> TIDs = entry.getValue();
            Collections.sort(TIDs);
            int pre_TID = 0;
            int pre_la = 0;
            for (int current_TID : TIDs) {
                int current_la = Math.max(0, pre_la + current_TID - pre_TID - this.maxPer);
                sm.setMaxla(current_la);
                sm.increaseSupport();
                pre_TID = current_TID;
                pre_la = current_la;
            }
            int current_la = Math.max(0, pre_la + this.lastTID - pre_TID - this.maxPer);
            sm.setMaxla(current_la);
            if (sm.getSupport() < this.minSup || sm.getMaxla() > this.maxLa) continue;
            mapBetaSPPlist.put(entry.getKey(), sm);
        }
        mapBetaTIDs.clear();
        return mapBetaSPPlist;
    }

    private void saveItemset(int[] itemset2, int itemsetLength, int support, int maxla) throws IOException {
        ++this.itemsetCount;
        if (this.writer != null) {
            System.arraycopy(itemset2, 0, this.itemsetOutputBuffer, 0, itemsetLength);
            Arrays.sort(this.itemsetOutputBuffer, 0, itemsetLength);
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < itemsetLength; ++i) {
                buffer.append(this.itemsetOutputBuffer[i]);
                if (i == itemsetLength - 1) continue;
                buffer.append(' ');
            }
            buffer.append(" #SUP: ");
            buffer.append(support);
            buffer.append(" #MAXLA: ");
            buffer.append(maxla);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        } else {
            int[] itemsetArray = new int[itemsetLength];
            System.arraycopy(itemset2, 0, itemsetArray, 0, itemsetLength);
            Arrays.sort(itemsetArray);
            Itemset itemsetObj = new Itemset(itemsetArray);
            this.patterns.addItemset(itemsetObj, itemsetLength);
        }
    }

    private void buildTreeByScanDataAgain(SPPTree tree, String input, final Map<Integer, Support_maxla> mapSPP_list) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(input));
        if (this.self_increment) {
            String line;
            int current_TID = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] lineSplited = line.split(" ");
                ArrayList<Integer> transaction = new ArrayList<Integer>();
                for (String itemString : lineSplited) {
                    Integer item_name = Integer.parseInt(itemString);
                    if (!mapSPP_list.containsKey(item_name) || transaction.contains(item_name)) continue;
                    transaction.add(item_name);
                }
                Collections.sort(transaction, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer item1, Integer item2) {
                        int compare = ((Support_maxla)mapSPP_list.get(item2)).getSupport() - ((Support_maxla)mapSPP_list.get(item1)).getSupport();
                        if (compare == 0) {
                            return item1 - item2;
                        }
                        return compare;
                    }
                });
                if (transaction.size() > 0) {
                    tree.addTransaction(transaction, current_TID);
                }
                ++current_TID;
            }
        } else {
            String line;
            int current_TID = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] lineSplited = line.trim().split("\\|");
                String[] lineItems = lineSplited[0].trim().split(" ");
                current_TID = Integer.parseInt(lineSplited[1]);
                ArrayList<Integer> transaction = new ArrayList<Integer>();
                for (String itemString : lineItems) {
                    Integer item_name = Integer.parseInt(itemString);
                    if (!mapSPP_list.containsKey(item_name) || transaction.contains(item_name)) continue;
                    transaction.add(item_name);
                }
                Collections.sort(transaction, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer item1, Integer item2) {
                        int compare = ((Support_maxla)mapSPP_list.get(item2)).getSupport() - ((Support_maxla)mapSPP_list.get(item1)).getSupport();
                        if (compare == 0) {
                            return item1 - item2;
                        }
                        return compare;
                    }
                });
                if (transaction.size() <= 0) continue;
                tree.addTransaction(transaction, current_TID);
            }
        }
        reader.close();
        tree.createHeaderList(null, mapSPP_list);
    }

    private Map<Integer, Support_maxla> scanDatabaseToDeterminSPPlistOfSingleItems(String input) throws IOException {
        String[] lineSplited;
        String line;
        int current_TID;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap<Integer, Support_maxla> mapSPP_list = new HashMap<Integer, Support_maxla>();
        HashMap<Integer, Integer> preTID = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> prela = new HashMap<Integer, Integer>();
        if (this.self_increment) {
            current_TID = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                for (String itemString : lineSplited = line.split(" ")) {
                    Integer item_name = Integer.parseInt(itemString);
                    int pre_TID = preTID.getOrDefault(item_name, 0);
                    int per = current_TID - pre_TID;
                    if (per == 0) continue;
                    int current_la = Math.max(0, prela.getOrDefault(item_name, 0) + per - this.maxPer);
                    if (!mapSPP_list.containsKey(item_name)) {
                        mapSPP_list.put(item_name, new Support_maxla());
                    }
                    ((Support_maxla)mapSPP_list.get(item_name)).setMaxla(current_la);
                    prela.put(item_name, current_la);
                    preTID.put(item_name, current_TID);
                    ((Support_maxla)mapSPP_list.get(item_name)).increaseSupport();
                }
                ++current_TID;
            }
            this.lastTID = current_TID - 1;
        } else {
            current_TID = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                lineSplited = line.split("\\|");
                String[] lineItems = lineSplited[0].split(" ");
                current_TID = Integer.parseInt(lineSplited[1]);
                for (String itemString : lineItems) {
                    Integer item_name = Integer.parseInt(itemString);
                    int pre_TID = preTID.getOrDefault(item_name, 0);
                    int per = current_TID - pre_TID;
                    if (per == 0) continue;
                    int current_la = Math.max(0, prela.getOrDefault(item_name, 0) + per - this.maxPer);
                    if (!mapSPP_list.containsKey(item_name)) {
                        mapSPP_list.put(item_name, new Support_maxla());
                    }
                    ((Support_maxla)mapSPP_list.get(item_name)).setMaxla(current_la);
                    prela.put(item_name, current_la);
                    preTID.put(item_name, current_TID);
                    ((Support_maxla)mapSPP_list.get(item_name)).increaseSupport();
                }
            }
            this.lastTID = current_TID;
        }
        reader.close();
        Iterator it = mapSPP_list.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            int item_name = (Integer)entry.getKey();
            ((Support_maxla)entry.getValue()).setMaxla((Integer)prela.get(item_name) + this.lastTID - (Integer)preTID.get(item_name) - this.maxPer);
            if (((Support_maxla)entry.getValue()).getSupport() >= this.minSup && ((Support_maxla)entry.getValue()).getMaxla() <= this.maxLa) continue;
            it.remove();
        }
        prela.clear();
        preTID.clear();
        return mapSPP_list;
    }

    public void printStats() {
        System.out.println("=============  SPP-growth  - STATS ===============");
        long temps = this.endTime - this.startTimestamp;
        System.out.print(" Max memory usage: " + MemoryLogger.getInstance().getMaxMemory() + " mb \n");
        System.out.println(" Itemset counts : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }

    public void setMaximumPatternLength(int length) {
        this.maxPatternLength = length;
    }

    public void cancelSelfIncrement() {
        this.self_increment = false;
    }
}

