/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.SPPNode;
import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.Support_maxla;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SPPTree {
    List<Integer> headerList = null;
    Map<Integer, SPPNode> mapItemNodes = new HashMap<Integer, SPPNode>();
    Map<Integer, SPPNode> mapItemLastNode = new HashMap<Integer, SPPNode>();
    SPPNode root = new SPPNode();
    int numOfNode = 0;

    public void addTransaction(List<Integer> transaction, int TID) {
        SPPNode currentNode = this.root;
        for (Integer item : transaction) {
            SPPNode child = currentNode.getChildByID(item);
            if (child == null) {
                ++this.numOfNode;
                SPPNode newNode = new SPPNode();
                newNode.itemID = item;
                newNode.parent = currentNode;
                currentNode.childs.add(newNode);
                currentNode = newNode;
                this.fixNodeLinks(item, newNode);
                continue;
            }
            currentNode = child;
        }
        currentNode.TIDs.add(TID);
    }

    private void fixNodeLinks(Integer item, SPPNode newNode) {
        SPPNode lastNode = this.mapItemLastNode.get(item);
        if (lastNode != null) {
            lastNode.nodeLink = newNode;
        }
        this.mapItemLastNode.put(item, newNode);
        SPPNode headernode = this.mapItemNodes.get(item);
        if (headernode == null) {
            this.mapItemNodes.put(item, newNode);
        }
    }

    void createHeaderList(List<Integer> lastHeaderList, final Map<Integer, Support_maxla> mapSPP_list) {
        if (lastHeaderList == null) {
            this.headerList = new ArrayList<Integer>(this.mapItemNodes.keySet());
            Collections.sort(this.headerList, new Comparator<Integer>(){

                @Override
                public int compare(Integer item1, Integer item2) {
                    int compare = ((Support_maxla)mapSPP_list.get(item2)).getSupport() - ((Support_maxla)mapSPP_list.get(item1)).getSupport();
                    if (compare == 0) {
                        return item1 - item2;
                    }
                    return compare;
                }
            });
        } else {
            this.headerList = new ArrayList<Integer>();
            for (int item : lastHeaderList) {
                if (!mapSPP_list.containsKey(item)) continue;
                this.headerList.add(item);
            }
        }
    }

    public void addPrefixPath(List<SPPNode> prefixPath, Map<Integer, Support_maxla> mapBetaSPPlist) {
        List<Integer> pathTIDs = prefixPath.get((int)0).TIDs;
        SPPNode currentNode = this.root;
        for (int i = prefixPath.size() - 1; i >= 1; --i) {
            SPPNode pathItem = prefixPath.get(i);
            if (!mapBetaSPPlist.containsKey(pathItem.itemID)) continue;
            SPPNode child = currentNode.getChildByID(pathItem.itemID);
            if (child == null) {
                SPPNode newNode = new SPPNode();
                newNode.itemID = pathItem.itemID;
                newNode.parent = currentNode;
                currentNode.childs.add(newNode);
                currentNode = newNode;
                this.fixNodeLinks(pathItem.itemID, newNode);
                continue;
            }
            currentNode = child;
        }
        if (currentNode.itemID != -1) {
            currentNode.TIDs.addAll(pathTIDs);
        }
    }

    public void removeTailItem() {
        int tail = this.headerList.size() - 1;
        SPPNode tailNode = this.mapItemNodes.get(this.headerList.get(tail));
        this.mapItemNodes.remove(this.headerList.get(tail));
        this.headerList.remove(tail);
        while (tailNode != null) {
            SPPNode parent = tailNode.parent;
            parent.removeChildByID(tailNode.itemID);
            if (parent.itemID != -1) {
                final List<Integer> timestamps = tailNode.TIDs;
                parent.TIDs.addAll((Collection<Integer>)new ArrayList<Integer>(){
                    {
                        this.addAll(timestamps);
                    }
                });
            }
            tailNode = tailNode.nodeLink;
        }
    }
}

