/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.tku;

import ca.pfv.spmf.algorithms.episodes.upspan.CalculateDatabaseInfo;
import ca.pfv.spmf.algorithms.frequentpatterns.tku.AlgoPhase2OfTKU;
import ca.pfv.spmf.algorithms.frequentpatterns.tku.StringPair;
import ca.pfv.spmf.algorithms.frequentpatterns.tku.TKUTriangularMatrix;
import ca.pfv.spmf.datastructures.redblacktree.RedBlackTree;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.PriorityQueue;

public class AlgoTKU {
    private String theInputFile;
    private String theCandidateFile;
    private int kValue;
    private int itemCount;
    private double globalMinUtil = 0.0;
    private int[] arrayTWUItems;
    private int[] arrayMIU;
    private int[] arrayMAU;
    private double totalTime;
    private int patternCount;

    public void runAlgorithm(String inputFile, String outputFile, int k) throws IOException {
        MemoryLogger.getInstance().reset();
        this.totalTime = System.currentTimeMillis();
        this.globalMinUtil = 0.0;
        CalculateDatabaseInfo tool = new CalculateDatabaseInfo(inputFile);
        tool.runCalculate();
        ArrayList<Integer> ulist = new ArrayList<Integer>(0);
        this.kValue = k;
        this.theInputFile = inputFile;
        this.theCandidateFile = "topKcandidate.txt";
        this.itemCount = tool.getMaxID() + 1;
        this.arrayTWUItems = new int[this.itemCount];
        this.arrayMIU = new int[this.itemCount];
        this.arrayMAU = new int[this.itemCount];
        FileWriter fw_CI = new FileWriter(this.theCandidateFile);
        BufferedWriter bfw_CI = new BufferedWriter(fw_CI);
        this.globalMinUtil = this.preEvaluation(this.theInputFile, this.arrayTWUItems, this.itemCount, this.arrayMIU, this.arrayMAU, this.globalMinUtil, this.kValue);
        FPtree tree = this.BuildUPTree(this.arrayTWUItems, this.theInputFile);
        tree.traverse_tree(tree.root, 0);
        RedBlackTree<Integer> DSNodeCountHeap = new RedBlackTree<Integer>(true);
        for (int i = 0; i < tree.root.childlink.size(); ++i) {
            int[] Sum_DS = new int[this.itemCount];
            int DSItem = tree.root.childlink.get((int)i).item;
            tree.SumDescendent(tree.root.childlink.get(i), Sum_DS);
            for (int j = 0; j < Sum_DS.length; ++j) {
                if (Sum_DS[j] == 0 || j == DSItem) continue;
                int DS_Value = (this.arrayMIU[j] + this.arrayMIU[DSItem]) * Sum_DS[j];
                this.UpdateNodeCountHeap(DSNodeCountHeap, DS_Value);
            }
        }
        DSNodeCountHeap = new RedBlackTree(true);
        RedBlackTree<Integer> ISNodeCountHeap = new RedBlackTree<Integer>(true);
        this.getUlist(this.arrayTWUItems, ulist);
        String prefix = "";
        tree.UPGrowth(tree, ulist, prefix, bfw_CI, ISNodeCountHeap, this.arrayTWUItems);
        for (int i = 0; i < this.arrayTWUItems.length; ++i) {
            if (!((double)this.arrayTWUItems[i] >= this.globalMinUtil)) continue;
            bfw_CI.write(i + ":" + this.arrayTWUItems[i]);
            bfw_CI.newLine();
        }
        bfw_CI.close();
        fw_CI.close();
        MemoryLogger.getInstance().checkMemory();
        String sortedTopKcandidateFile = "sortedTopKcandidate.txt";
        this.runSortHUIAlgorithm(this.theCandidateFile, sortedTopKcandidateFile);
        File fileToDelete = new File(this.theCandidateFile);
        fileToDelete.delete();
        MemoryLogger.getInstance().checkMemory();
        AlgoPhase2OfTKU algoPhase2 = new AlgoPhase2OfTKU();
        algoPhase2.runAlgorithm((int)this.globalMinUtil, tool.getDBSize(), k, inputFile, sortedTopKcandidateFile, outputFile);
        this.patternCount = algoPhase2.getNumberOfTopKHUIs();
        MemoryLogger.getInstance().checkMemory();
        this.totalTime = ((double)System.currentTimeMillis() - this.totalTime) / 1000.0;
    }

    void runSortHUIAlgorithm(String theCandidateFile, String sortedTopKcandidateFile) throws IOException {
        double StartTime = System.currentTimeMillis();
        String gFp_HUI = theCandidateFile;
        String TopK_HUI = sortedTopKcandidateFile;
        FileReader bf = new FileReader(gFp_HUI);
        BufferedReader bfr = new BufferedReader(bf);
        RedBlackTree<StringPair> Heap = new RedBlackTree<StringPair>(true);
        String record = "";
        int numHUIs = 0;
        while ((record = bfr.readLine()) != null) {
            String[] temp = record.split(":");
            Heap.add(new StringPair(temp[0], Integer.parseInt(temp[1])));
            ++numHUIs;
        }
        bfr.close();
        bf.close();
        FileWriter fw1 = new FileWriter(TopK_HUI);
        BufferedWriter bfw1 = new BufferedWriter(fw1);
        int nElements = Heap.size();
        for (int i = 0; i < nElements; ++i) {
            bfw1.write(((StringPair)Heap.maximum()).x + ":" + ((StringPair)Heap.maximum()).y);
            bfw1.newLine();
            Heap.popMaximum();
        }
        bfw1.flush();
        bfw1.close();
        fw1.close();
    }

    public void printStats() {
        System.out.println("=============  TKU - v.2.26  =============");
        System.out.println(" Total execution time : " + this.totalTime + " s");
        System.out.println(" Number of top-k high utility patterns : " + this.patternCount);
        System.out.println(" Max memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }

    public double preEvaluation(String HDB, int[] TWU1, int num_Item, int[] MinBNF, int[] MaxBNF, double mini_utility, int pK) throws IOException {
        TKUTriangularMatrix a = new TKUTriangularMatrix(num_Item);
        FileReader fr = new FileReader(HDB);
        BufferedReader bfr = new BufferedReader(fr);
        String transaction = "";
        while ((transaction = bfr.readLine()) != null) {
            String[] temp1 = transaction.split(":");
            String[] temp2 = temp1[0].split(" ");
            String[] temp3 = temp1[2].split(" ");
            for (int s = 0; s < temp2.length; ++s) {
                if (MinBNF[Integer.parseInt(temp2[s])] == 0) {
                    if (Integer.parseInt(temp3[s]) > 0) {
                        MinBNF[Integer.parseInt((String)temp2[s])] = Integer.parseInt(temp3[s]);
                    }
                } else if (MinBNF[Integer.parseInt(temp2[s])] > Integer.parseInt(temp3[s])) {
                    MinBNF[Integer.parseInt((String)temp2[s])] = Integer.parseInt(temp3[s]);
                }
                if (MaxBNF[Integer.parseInt(temp2[s])] < Integer.parseInt(temp3[s])) {
                    MaxBNF[Integer.parseInt((String)temp2[s])] = Integer.parseInt(temp3[s]);
                }
                int n = Integer.parseInt(temp2[s]);
                TWU1[n] = TWU1[n] + Integer.parseInt(temp1[1]);
                if (s <= 0) continue;
                a.incrementCount(Integer.parseInt(temp2[0]), Integer.parseInt(temp2[s]), Integer.parseInt(temp3[0]) + Integer.parseInt(temp3[s]));
            }
        }
        fr.close();
        bfr.close();
        MemoryLogger.getInstance().checkMemory();
        double Initial_BUT = this.getInitialUtility(a, num_Item, pK);
        return Initial_BUT;
    }

    public double getInitialUtility(TKUTriangularMatrix TM, int nItem, int K) {
        PriorityQueue<HeapEntry> topKList = new PriorityQueue<HeapEntry>();
        int count = 0;
        for (int i = 0; i < nItem; ++i) {
            for (int j = 0; j < TM.matrix[i].length; ++j) {
                HeapEntry entry;
                if (TM.matrix[i][j] == 0) continue;
                if (topKList.size() < K) {
                    entry = new HeapEntry();
                    entry.count = ++count;
                    entry.priority = TM.matrix[i][j];
                    topKList.add(entry);
                    continue;
                }
                if (topKList.size() < K || TM.matrix[i][j] <= ((HeapEntry)topKList.peek()).priority) continue;
                entry = new HeapEntry();
                entry.count = ++count;
                entry.priority = TM.matrix[i][j];
                topKList.add(entry);
                topKList.poll();
            }
        }
        return ((HeapEntry)topKList.peek()).priority;
    }

    public void getUlist(int[] P1, ArrayList<Integer> list) {
        for (int i = 0; i < P1.length; ++i) {
            if (P1[i] <= 0 || !((double)P1[i] >= this.globalMinUtil)) continue;
            this.InsertItem(list, i, P1);
        }
    }

    public int InsertItem(ArrayList<Integer> list, int target, int[] Order) {
        if (list.size() == 0) {
            list.add(target);
        } else if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (Order[target] > Order[list.get(i)]) {
                    list.add(i, target);
                    return 0;
                }
                if (Order[target] == Order[list.get(i)] && target < list.get(i)) {
                    list.add(i, target);
                    return 0;
                }
                if (i != list.size() - 1) continue;
                list.add(target);
                return 0;
            }
        }
        return -1;
    }

    public void sorttrans(int[] tran, int pre, int tranlen, int[] P1) {
        for (int i = pre; i < tranlen - 1; ++i) {
            for (int j = pre; j < tranlen - 1; ++j) {
                int temp;
                if (P1[tran[j]] < P1[tran[j + 1]]) {
                    temp = tran[j];
                    tran[j] = tran[j + 1];
                    tran[j + 1] = temp;
                    continue;
                }
                if (P1[tran[j]] != P1[tran[j + 1]] || tran[j] <= tran[j + 1]) continue;
                temp = tran[j];
                tran[j] = tran[j + 1];
                tran[j + 1] = temp;
            }
        }
    }

    public void sorttrans2(int[] tran, String[] bran, int pre, int tranlen, int[] P1) {
        for (int i = pre; i < tranlen - 1; ++i) {
            for (int j = pre; j < tranlen - 1; ++j) {
                String temp2;
                int temp1;
                if (P1[tran[j]] < P1[tran[j + 1]]) {
                    temp1 = tran[j];
                    temp2 = bran[j];
                    tran[j] = tran[j + 1];
                    bran[j] = bran[j + 1];
                    tran[j + 1] = temp1;
                    bran[j + 1] = temp2;
                    continue;
                }
                if (P1[tran[j]] != P1[tran[j + 1]] || tran[j] <= tran[j + 1]) continue;
                temp1 = tran[j];
                temp2 = bran[j];
                tran[j] = tran[j + 1];
                bran[j] = bran[j + 1];
                tran[j + 1] = temp1;
                bran[j + 1] = temp2;
            }
        }
    }

    public void UpdateNodeCountHeap(RedBlackTree<Integer> NCH, int NewValue) {
        if (NCH.size() < this.kValue) {
            NCH.add(NewValue);
        } else if (NCH.size() >= this.kValue && (double)NewValue > this.globalMinUtil) {
            NCH.add(NewValue);
            NCH.popMinimum();
        }
        if ((double)NCH.minimum().intValue() > this.globalMinUtil && NCH.size() >= this.kValue) {
            this.globalMinUtil = NCH.minimum().intValue();
        }
    }

    public FPtree BuildUPTree(int[] P1, String HDB) throws IOException {
        String transaction;
        RedBlackTree<Integer> NodeCountHeap = new RedBlackTree<Integer>(true);
        FPtree tree = new FPtree();
        FileReader fr = new FileReader(HDB);
        BufferedReader bfr = new BufferedReader(fr);
        while ((transaction = bfr.readLine()) != null) {
            String[] temp1 = transaction.split(":");
            String[] temp2 = temp1[0].split(" ");
            String[] bran = temp1[2].split(" ");
            String[] bran2 = new String[bran.length];
            int tranlen = 0;
            int[] tran = new int[temp2.length];
            for (int m = 0; m < temp2.length; ++m) {
                if (!((double)P1[Integer.parseInt(temp2[m])] >= this.globalMinUtil)) continue;
                bran2[tranlen] = bran[m];
                tran[tranlen] = Integer.parseInt(temp2[m]);
                ++tranlen;
            }
            this.sorttrans2(tran, bran2, 0, tranlen, P1);
            tree.instrans3(tran, bran2, tranlen, P1, 1, NodeCountHeap);
        }
        fr.close();
        bfr.close();
        MemoryLogger.getInstance().checkMemory();
        return tree;
    }

    public class FPtree {
        treenode root;
        treenode[] HeaderTable;

        public FPtree() {
            this.HeaderTable = new treenode[AlgoTKU.this.itemCount];
            this.root = new treenode(-1, 0, 0);
            for (int i = 0; i < this.HeaderTable.length; ++i) {
                this.HeaderTable[i] = null;
            }
        }

        public void insPatternBase(int[] tran, int tranlen, int[] L1, int TWU, int IC, int SumBNF) {
            treenode par = this.root;
            block0: for (int i = 0; i < tranlen; ++i) {
                int target = tran[i];
                int cs = par.childlink.size();
                if (cs == 0) {
                    int M = TWU - (SumBNF - AlgoTKU.this.arrayMIU[target] * IC);
                    SumBNF -= AlgoTKU.this.arrayMIU[target] * IC;
                    treenode nNode = new treenode(target, M, IC);
                    par.childlink.add(nNode);
                    nNode.parentlink = par;
                    if (this.HeaderTable[target] == null) {
                        this.HeaderTable[target] = nNode;
                    } else {
                        nNode.hlink = this.HeaderTable[target];
                        this.HeaderTable[target] = nNode;
                    }
                    par = nNode;
                    continue;
                }
                for (int j = 0; j < cs; ++j) {
                    treenode nNode;
                    int M;
                    treenode comp = par.childlink.get(j);
                    if (target == comp.item) {
                        M = TWU - (SumBNF - AlgoTKU.this.arrayMIU[target] * IC);
                        SumBNF -= AlgoTKU.this.arrayMIU[target] * IC;
                        comp.twu += M;
                        comp.count += IC;
                        par = comp;
                        continue block0;
                    }
                    if (L1[target] > L1[comp.item]) {
                        M = TWU - (SumBNF - AlgoTKU.this.arrayMIU[target] * IC);
                        SumBNF -= AlgoTKU.this.arrayMIU[target] * IC;
                        nNode = new treenode(target, M, IC);
                        par.childlink.add(j, nNode);
                        nNode.parentlink = par;
                        if (this.HeaderTable[target] == null) {
                            this.HeaderTable[target] = nNode;
                        } else {
                            nNode.hlink = this.HeaderTable[target];
                            this.HeaderTable[target] = nNode;
                        }
                        par = nNode;
                        continue block0;
                    }
                    if (L1[target] == L1[comp.item] && target < comp.item) {
                        M = TWU - (SumBNF - AlgoTKU.this.arrayMIU[target] * IC);
                        SumBNF -= AlgoTKU.this.arrayMIU[target] * IC;
                        nNode = new treenode(target, M, IC);
                        par.childlink.add(j, nNode);
                        nNode.parentlink = par;
                        if (this.HeaderTable[target] == null) {
                            this.HeaderTable[target] = nNode;
                        } else {
                            nNode.hlink = this.HeaderTable[target];
                            this.HeaderTable[target] = nNode;
                        }
                        par = nNode;
                        continue block0;
                    }
                    if (j != cs - 1) continue;
                    M = TWU - (SumBNF - AlgoTKU.this.arrayMIU[target] * IC);
                    SumBNF -= AlgoTKU.this.arrayMIU[target] * IC;
                    nNode = new treenode(target, M, IC);
                    par.childlink.add(nNode);
                    nNode.parentlink = par;
                    if (this.HeaderTable[target] == null) {
                        this.HeaderTable[target] = nNode;
                    } else {
                        nNode.hlink = this.HeaderTable[target];
                        this.HeaderTable[target] = nNode;
                    }
                    par = nNode;
                }
            }
        }

        public void instrans2(int[] tran, String[] bran, int tranlen, int[] L1, int IC) {
            int TWU = 0;
            treenode par = this.root;
            block0: for (int i = 0; i < tranlen; ++i) {
                TWU += Integer.parseInt(bran[i]);
                int target = tran[i];
                int cs = par.childlink.size();
                if (cs == 0) {
                    treenode nNode = new treenode(target, TWU, IC);
                    par.childlink.add(nNode);
                    nNode.parentlink = par;
                    if (this.HeaderTable[target] == null) {
                        this.HeaderTable[target] = nNode;
                    } else {
                        nNode.hlink = this.HeaderTable[target];
                        this.HeaderTable[target] = nNode;
                    }
                    par = nNode;
                    continue;
                }
                for (int j = 0; j < cs; ++j) {
                    treenode nNode;
                    treenode comp = par.childlink.get(j);
                    if (target == comp.item) {
                        comp.twu += TWU;
                        comp.count += IC;
                        par = comp;
                        continue block0;
                    }
                    if (L1[target] > L1[comp.item]) {
                        nNode = new treenode(target, TWU, IC);
                        par.childlink.add(j, nNode);
                        nNode.parentlink = par;
                        if (this.HeaderTable[target] == null) {
                            this.HeaderTable[target] = nNode;
                        } else {
                            nNode.hlink = this.HeaderTable[target];
                            this.HeaderTable[target] = nNode;
                        }
                        par = nNode;
                        continue block0;
                    }
                    if (L1[target] == L1[comp.item] && target < comp.item) {
                        nNode = new treenode(target, TWU, IC);
                        par.childlink.add(j, nNode);
                        nNode.parentlink = par;
                        if (this.HeaderTable[target] == null) {
                            this.HeaderTable[target] = nNode;
                        } else {
                            nNode.hlink = this.HeaderTable[target];
                            this.HeaderTable[target] = nNode;
                        }
                        par = nNode;
                        continue block0;
                    }
                    if (j != cs - 1) continue;
                    nNode = new treenode(target, TWU, IC);
                    par.childlink.add(nNode);
                    nNode.parentlink = par;
                    if (this.HeaderTable[target] == null) {
                        this.HeaderTable[target] = nNode;
                    } else {
                        nNode.hlink = this.HeaderTable[target];
                        this.HeaderTable[target] = nNode;
                    }
                    par = nNode;
                }
            }
        }

        public void instrans3(int[] tran, String[] bran, int tranlen, int[] L1, int IC, RedBlackTree<Integer> NodeCountHeap) {
            int TWU = 0;
            treenode par = this.root;
            block0: for (int i = 0; i < tranlen; ++i) {
                TWU += Integer.parseInt(bran[i]);
                int target = tran[i];
                int cs = par.childlink.size();
                if (cs == 0) {
                    treenode nNode = new treenode(target, TWU, IC);
                    par.childlink.add(nNode);
                    if ((double)nNode.twu > AlgoTKU.this.globalMinUtil) {
                        AlgoTKU.this.UpdateNodeCountHeap(NodeCountHeap, nNode.twu);
                    }
                    nNode.parentlink = par;
                    if (this.HeaderTable[target] == null) {
                        this.HeaderTable[target] = nNode;
                    } else {
                        nNode.hlink = this.HeaderTable[target];
                        this.HeaderTable[target] = nNode;
                    }
                    par = nNode;
                    continue;
                }
                for (int j = 0; j < cs; ++j) {
                    treenode nNode;
                    treenode comp = par.childlink.get(j);
                    if (target == comp.item) {
                        NodeCountHeap.remove(comp.twu);
                        AlgoTKU.this.UpdateNodeCountHeap(NodeCountHeap, comp.twu + TWU);
                        comp.twu += TWU;
                        comp.count += IC;
                        par = comp;
                        continue block0;
                    }
                    if (L1[target] > L1[comp.item]) {
                        if ((double)comp.twu > AlgoTKU.this.globalMinUtil) {
                            AlgoTKU.this.UpdateNodeCountHeap(NodeCountHeap, TWU);
                        }
                        nNode = new treenode(target, TWU, IC);
                        par.childlink.add(j, nNode);
                        nNode.parentlink = par;
                        if (this.HeaderTable[target] == null) {
                            this.HeaderTable[target] = nNode;
                        } else {
                            nNode.hlink = this.HeaderTable[target];
                            this.HeaderTable[target] = nNode;
                        }
                        par = nNode;
                        continue block0;
                    }
                    if (L1[target] == L1[comp.item] && target < comp.item) {
                        if ((double)comp.twu > AlgoTKU.this.globalMinUtil) {
                            AlgoTKU.this.UpdateNodeCountHeap(NodeCountHeap, TWU);
                        }
                        nNode = new treenode(target, TWU, IC);
                        par.childlink.add(j, nNode);
                        nNode.parentlink = par;
                        if (this.HeaderTable[target] == null) {
                            this.HeaderTable[target] = nNode;
                        } else {
                            nNode.hlink = this.HeaderTable[target];
                            this.HeaderTable[target] = nNode;
                        }
                        par = nNode;
                        continue block0;
                    }
                    if (j != cs - 1) continue;
                    if ((double)comp.twu > AlgoTKU.this.globalMinUtil) {
                        AlgoTKU.this.UpdateNodeCountHeap(NodeCountHeap, TWU);
                    }
                    nNode = new treenode(target, TWU, IC);
                    par.childlink.add(nNode);
                    nNode.parentlink = par;
                    if (this.HeaderTable[target] == null) {
                        this.HeaderTable[target] = nNode;
                    } else {
                        nNode.hlink = this.HeaderTable[target];
                        this.HeaderTable[target] = nNode;
                    }
                    par = nNode;
                }
            }
        }

        public void UPGrowth(FPtree tree2, ArrayList<Integer> flist2, String prefix, BufferedWriter bfw_UCI, RedBlackTree<Integer> ISNodeCountHeap, int[] LP1) throws IOException {
            for (int i = 0; i < flist2.size(); ++i) {
                if (!((double)LP1[flist2.get(i)] >= AlgoTKU.this.globalMinUtil)) continue;
                String Nprefix = "";
                Nprefix = prefix.equals("") ? prefix.concat(flist2.get(i) + "") : prefix.concat(" " + flist2.get(i));
                int citem = flist2.get(i);
                treenode chlink = tree2.HeaderTable[citem];
                ArrayList CPB = new ArrayList(0);
                ArrayList<Integer> CPBW = new ArrayList<Integer>(0);
                ArrayList<Integer> CPBC = new ArrayList<Integer>(0);
                int[] LocalF1 = new int[AlgoTKU.this.itemCount];
                int[] LocalCount = new int[AlgoTKU.this.itemCount];
                boolean HLink_count = false;
                while (chlink != null) {
                    ArrayList<Integer> path = new ArrayList<Integer>(0);
                    treenode cptr = chlink;
                    while (cptr.parentlink != null) {
                        path.add(cptr.item);
                        LocalF1[cptr.item] = LocalF1[cptr.item] + chlink.twu;
                        LocalCount[cptr.item] = LocalCount[cptr.item] + chlink.count;
                        cptr = cptr.parentlink;
                    }
                    path.remove(0);
                    CPB.add(path);
                    CPBW.add(chlink.twu);
                    CPBC.add(chlink.count);
                    chlink = chlink.hlink;
                }
                ArrayList<Integer> localflist = new ArrayList<Integer>(0);
                for (int j = 0; j < LocalF1.length; ++j) {
                    if ((double)LocalF1[j] < AlgoTKU.this.globalMinUtil) {
                        LocalF1[j] = -1;
                        continue;
                    }
                    if (j == citem) continue;
                    AlgoTKU.this.InsertItem(localflist, j, LocalF1);
                    String UTI = Nprefix + " " + j;
                    String[] TempItem = UTI.split(" ");
                    int SumMau = 0;
                    int SumMiu = 0;
                    for (int u = 0; u < TempItem.length; ++u) {
                        SumMau += AlgoTKU.this.arrayMAU[Integer.parseInt(TempItem[u])];
                        SumMiu += AlgoTKU.this.arrayMIU[Integer.parseInt(TempItem[u])];
                    }
                    int MAU = SumMau * LocalCount[j];
                    if (!((double)MAU >= AlgoTKU.this.globalMinUtil)) continue;
                    int MIU = SumMiu * LocalCount[j];
                    bfw_UCI.write(Nprefix + " " + j + ":" + LocalF1[j]);
                    bfw_UCI.newLine();
                    if (!((double)MIU > AlgoTKU.this.globalMinUtil)) continue;
                    AlgoTKU.this.UpdateNodeCountHeap(ISNodeCountHeap, MIU);
                }
                if (CPB.size() == 0) continue;
                FPtree C_FPtree = new FPtree();
                for (int k = 0; k < CPB.size(); ++k) {
                    ArrayList ltran = (ArrayList)CPB.get(k);
                    int Sum_MinBNF = 0;
                    int[] tran = new int[ltran.size()];
                    int tranlen = 0;
                    for (int h = 0; h < ltran.size(); ++h) {
                        if ((double)LocalF1[(Integer)ltran.get(h)] >= AlgoTKU.this.globalMinUtil) {
                            Sum_MinBNF += (Integer)CPBC.get(k) * AlgoTKU.this.arrayMIU[(Integer)ltran.get(h)];
                            tran[tranlen++] = (Integer)ltran.get(h);
                            continue;
                        }
                        int sum = (Integer)CPBW.get(k);
                        CPBW.set(k, sum -= (Integer)CPBC.get(k) * AlgoTKU.this.arrayMIU[(Integer)ltran.get(h)]);
                    }
                    AlgoTKU.this.sorttrans(tran, 0, tranlen, LocalF1);
                    C_FPtree.insPatternBase(tran, tranlen, LocalF1, (Integer)CPBW.get(k), (Integer)CPBC.get(k), Sum_MinBNF);
                }
                C_FPtree.UPGrowth_MinBNF(C_FPtree, localflist, Nprefix, bfw_UCI, ISNodeCountHeap, LocalF1);
            }
            MemoryLogger.getInstance().checkMemory();
            bfw_UCI.flush();
        }

        public void UPGrowth_MinBNF(FPtree tree2, ArrayList<Integer> flist2, String prefix, BufferedWriter bfw_UCI, RedBlackTree<Integer> ISNodeCountHeap, int[] LP1) throws IOException {
            for (int i = 0; i < flist2.size(); ++i) {
                if (!((double)LP1[flist2.get(i)] >= AlgoTKU.this.globalMinUtil)) continue;
                String Nprefix = "";
                Nprefix = prefix.equals("") ? prefix.concat(flist2.get(i) + "") : prefix.concat(" " + flist2.get(i));
                int citem = flist2.get(i);
                treenode chlink = tree2.HeaderTable[citem];
                ArrayList CPB = new ArrayList(0);
                ArrayList<Integer> CPBW = new ArrayList<Integer>(0);
                ArrayList<Integer> CPBC = new ArrayList<Integer>(0);
                int[] LocalF1 = new int[AlgoTKU.this.itemCount];
                int[] LocalCount = new int[AlgoTKU.this.itemCount];
                while (chlink != null) {
                    ArrayList<Integer> path = new ArrayList<Integer>(0);
                    treenode cptr = chlink;
                    while (cptr.parentlink != null) {
                        path.add(cptr.item);
                        LocalF1[cptr.item] = LocalF1[cptr.item] + chlink.twu;
                        LocalCount[cptr.item] = LocalCount[cptr.item] + chlink.count;
                        cptr = cptr.parentlink;
                    }
                    path.remove(0);
                    CPB.add(path);
                    CPBW.add(chlink.twu);
                    CPBC.add(chlink.count);
                    chlink = chlink.hlink;
                }
                ArrayList<Integer> localflist = new ArrayList<Integer>(0);
                for (int j = 0; j < LocalF1.length; ++j) {
                    if ((double)LocalF1[j] < AlgoTKU.this.globalMinUtil) {
                        LocalF1[j] = -1;
                        continue;
                    }
                    if (j == citem) continue;
                    AlgoTKU.this.InsertItem(localflist, j, LocalF1);
                    String UTI = Nprefix + " " + j;
                    String[] TempItem = UTI.split(" ");
                    int SumMau = 0;
                    int SumMiu = 0;
                    for (int u = 0; u < TempItem.length; ++u) {
                        SumMau += AlgoTKU.this.arrayMAU[Integer.parseInt(TempItem[u])];
                        SumMiu += AlgoTKU.this.arrayMIU[Integer.parseInt(TempItem[u])];
                    }
                    int MAU = SumMau * LocalCount[j];
                    if (!((double)MAU >= AlgoTKU.this.globalMinUtil)) continue;
                    int MIU = SumMiu * LocalCount[j];
                    bfw_UCI.write(Nprefix + " " + j + ":" + LocalF1[j]);
                    bfw_UCI.newLine();
                    if (!((double)MIU > AlgoTKU.this.globalMinUtil)) continue;
                    AlgoTKU.this.UpdateNodeCountHeap(ISNodeCountHeap, MIU);
                }
                if (CPB.size() == 0) continue;
                FPtree C_FPtree = new FPtree();
                for (int k = 0; k < CPB.size(); ++k) {
                    ArrayList ltran = (ArrayList)CPB.get(k);
                    int Sum_MinBNF = 0;
                    int[] tran = new int[ltran.size()];
                    int tranlen = 0;
                    for (int h = 0; h < ltran.size(); ++h) {
                        if ((double)LocalF1[(Integer)ltran.get(h)] >= AlgoTKU.this.globalMinUtil) {
                            Sum_MinBNF += (Integer)CPBC.get(k) * AlgoTKU.this.arrayMIU[(Integer)ltran.get(h)];
                            tran[tranlen++] = (Integer)ltran.get(h);
                            continue;
                        }
                        int sum = (Integer)CPBW.get(k);
                        CPBW.set(k, sum -= (Integer)CPBC.get(k) * AlgoTKU.this.arrayMIU[(Integer)ltran.get(h)]);
                    }
                    AlgoTKU.this.sorttrans(tran, 0, tranlen, LocalF1);
                    C_FPtree.insPatternBase(tran, tranlen, LocalF1, (Integer)CPBW.get(k), (Integer)CPBC.get(k), Sum_MinBNF);
                }
                C_FPtree.UPGrowth_MinBNF(C_FPtree, localflist, Nprefix, bfw_UCI, ISNodeCountHeap, LocalF1);
            }
            MemoryLogger.getInstance().checkMemory();
            bfw_UCI.flush();
        }

        public void traverse_tree(treenode cNode, int level) {
            ++level;
            if (cNode != null) {
                for (int i = 0; i < cNode.childlink.size(); ++i) {
                    this.traverse_tree(cNode.childlink.get(i), level);
                }
            }
        }

        public void SumDescendent(treenode cNode, int[] DS_Sum_Table) {
            if (cNode != null) {
                int n = cNode.item;
                DS_Sum_Table[n] = DS_Sum_Table[n] + cNode.count;
                for (int i = 0; i < cNode.childlink.size(); ++i) {
                    this.SumDescendent(cNode.childlink.get(i), DS_Sum_Table);
                }
            }
        }
    }

    public class treenode {
        int item;
        int count;
        int twu;
        treenode hlink = null;
        treenode parentlink = null;
        ArrayList<treenode> childlink;

        public treenode(int item, int TWU, int count) {
            this.item = item;
            this.count = count;
            this.twu = TWU;
            this.childlink = new ArrayList(0);
            this.hlink = null;
            this.parentlink = null;
        }
    }

    public class HeapEntry
    implements Comparable<HeapEntry> {
        protected int count;
        protected int priority;

        @Override
        public int compareTo(HeapEntry o) {
            return o.priority - this.priority;
        }
    }
}

