/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.tku;

class TKUTriangularMatrix {
    public int[][] matrix;
    public int elementCount;

    public TKUTriangularMatrix(int elementCount) {
        this.elementCount = elementCount;
        this.matrix = new int[elementCount][];
        for (int i = 0; i < elementCount; ++i) {
            this.matrix[i] = new int[elementCount - i];
        }
    }

    public int get(int i, int j) {
        return this.matrix[i][j];
    }

    public static void main(String[] args) {
        TKUTriangularMatrix a = new TKUTriangularMatrix(5);
        System.out.println(a.toString());
        a.incrementCount(1, 2, 1);
        System.out.println("add {1 2}");
        System.out.println(a.toString());
        System.out.println("add {1 2}");
        a.incrementCount(1, 2, 1);
        System.out.println(a.toString());
        System.out.println("add {1 3}");
        a.incrementCount(1, 3, 1);
        System.out.println(a.toString());
        a.incrementCount(1, 4, 1);
        System.out.println(a.toString());
        a.incrementCount(1, 3, 1);
        a.incrementCount(2, 4, 1);
        a.incrementCount(2, 4, 1);
        a.incrementCount(4, 3, 1);
        System.out.println(a.toString());
        a.incrementCount(0, 2, 1);
        a.incrementCount(0, 3, 1);
        a.incrementCount(0, 4, 1);
        System.out.println(a.toString());
    }

    public String toString() {
        System.out.println("Element count = " + this.elementCount);
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < this.matrix.length; ++i) {
            temp.append(i);
            temp.append(": ");
            for (int j = 0; j < this.matrix[i].length; ++j) {
                temp.append(this.matrix[i][j]);
                temp.append(" ");
            }
            temp.append("\n");
        }
        return temp.toString();
    }

    public void incrementCount(int id1, int id2, int sum) {
        if (id2 < id1) {
            int[] nArray = this.matrix[id2];
            int n = this.elementCount - id1 - 1;
            nArray[n] = nArray[n] + sum;
        } else {
            int[] nArray = this.matrix[id1];
            int n = this.elementCount - id2 - 1;
            nArray[n] = nArray[n] + sum;
        }
    }

    public int getSupportForItems(int id1, int id2) {
        if (id2 < id1) {
            return this.matrix[id2][this.elementCount - id1 - 1];
        }
        return this.matrix[id1][this.elementCount - id2 - 1];
    }
}

