/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.tshoun;

import ca.pfv.spmf.algorithms.frequentpatterns.tshoun.ItemUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.tshoun.Pair;
import ca.pfv.spmf.algorithms.frequentpatterns.tshoun.TransactionWithPeriod;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DatabaseWithPeriods {
    int periodCount;
    private final Set<Integer> allItems = new HashSet<Integer>();
    private final Set<Integer> allNegativeItems = new HashSet<Integer>();
    private final List<TransactionWithPeriod> transactions = new ArrayList<TransactionWithPeriod>();
    private List<Integer> periodsTotalUtilities = new ArrayList<Integer>();
    private Map<Integer, BitSet> mapItemPeriods = new HashMap<Integer, BitSet>();
    Map<Integer, Pair> mapItemUtility = new HashMap<Integer, Pair>();
    public int smallestID = Integer.MAX_VALUE;
    public int largestID = 0;
    public int maxSEQUENCECOUNT = Integer.MAX_VALUE;

    public DatabaseWithPeriods(int periodCount) {
        this.periodCount = periodCount;
        this.periodsTotalUtilities = new ArrayList<Integer>(periodCount);
    }

    public Map<Integer, Pair> getMapItemExactEstUtility() {
        return this.mapItemUtility;
    }

    public List<Integer> getPeriodUtilities() {
        return this.periodsTotalUtilities;
    }

    BitSet getPeriodsOfItem(int item) {
        return this.mapItemPeriods.get(item);
    }

    private void addPeriodToListOfPeriodsOfItem(int period, int item) {
        BitSet bitset = this.mapItemPeriods.get(item);
        if (bitset == null) {
            bitset = new BitSet();
            this.mapItemPeriods.put(item, bitset);
        }
        bitset.set(period);
    }

    public Map<Integer, BitSet> getMapItemPeriod() {
        return this.mapItemPeriods;
    }

    public Set<Integer> getNegativeItems() {
        return this.allNegativeItems;
    }

    public int getPeriodCount() {
        return this.periodsTotalUtilities.size();
    }

    public int getPeriodUtility(int period) {
        return this.periodsTotalUtilities.get(period);
    }

    private void incrementPeriodUtility(int period, int transactionUtility) {
        boolean notSeenBefore;
        boolean bl = notSeenBefore = this.periodsTotalUtilities.size() < period + 1;
        if (notSeenBefore) {
            while (this.periodsTotalUtilities.size() < period) {
                this.periodsTotalUtilities.add(0);
            }
            this.periodsTotalUtilities.add(transactionUtility);
        } else {
            int sumUtility = this.periodsTotalUtilities.get(period) + transactionUtility;
            this.periodsTotalUtilities.set(period, sumUtility);
        }
    }

    public void loadFile(String path) throws Exception {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null && tid < this.maxSEQUENCECOUNT) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.processTransaction(thisLine.split(":"));
                ++tid;
            }
        }
    }

    private void processTransaction(String[] line) throws Exception {
        String[] items = line[0].split(" ");
        String[] utilities = line[2].split(" ");
        int period = Integer.parseInt(line[3]);
        int[] utilityValuesInt = new int[utilities.length];
        int transactionUtilityWithNegativeAndPositive = 0;
        int transactionUtilityWithPositive = 0;
        for (int j = 0; j < utilities.length; ++j) {
            utilityValuesInt[j] = Integer.parseInt(utilities[j]);
            transactionUtilityWithNegativeAndPositive += utilityValuesInt[j];
            if (utilityValuesInt[j] <= 0) continue;
            transactionUtilityWithPositive += utilityValuesInt[j];
        }
        ArrayList<ItemUtility> itemUtilityObjects = new ArrayList<ItemUtility>();
        for (int i = 0; i < items.length; ++i) {
            int item = Integer.parseInt(items[i]);
            int utility = Integer.parseInt(utilities[i]);
            itemUtilityObjects.add(new ItemUtility(item, utility));
            if (utility < 0) {
                this.allNegativeItems.add(item);
            }
            if (item < this.smallestID) {
                this.smallestID = item;
            }
            if (item > this.largestID) {
                this.largestID = item;
            }
            this.allItems.add(item);
            if (period >= this.periodCount) {
                throw new Exception("ERROR: the parameter \"period count\" should not be smaller than the number of periods in the input file. Please run the algorithm again but set the parameter \"period count\" to the number  of periods in the file." + System.lineSeparator() + System.lineSeparator());
            }
            Pair pair = this.mapItemUtility.get(item);
            if (pair == null) {
                pair = new Pair(this.periodCount);
                pair.exactUtility += utility;
                this.mapItemUtility.put(item, pair);
            } else {
                pair.exactUtility += utility;
            }
            if (pair.estimatedUtility[period] == null) {
                pair.estimatedUtility[period] = transactionUtilityWithPositive;
            } else {
                Integer[] integerArray = pair.estimatedUtility;
                int n = period;
                Integer.valueOf(integerArray[n] + transactionUtilityWithPositive);
            }
            this.addPeriodToListOfPeriodsOfItem(period, item);
        }
        this.transactions.add(new TransactionWithPeriod(itemUtilityObjects, transactionUtilityWithPositive, period));
        this.incrementPeriodUtility(period, transactionUtilityWithNegativeAndPositive);
    }

    public void printDatabase() {
        System.out.println("===================  Database ===================");
        int count = 0;
        for (TransactionWithPeriod itemset2 : this.transactions) {
            System.out.print("0" + count + ":  ");
            itemset2.print();
            System.out.println("");
            ++count;
        }
    }

    public int size() {
        return this.transactions.size();
    }

    public List<TransactionWithPeriod> getTransactions() {
        return this.transactions;
    }

    public Set<Integer> getAllItems() {
        return this.allItems;
    }
}

