/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.two_phase;

import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.ItemUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.ItemsetTP;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.ItemsetsTP;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.TransactionTP;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.UtilityTransactionDatabaseTP;
import ca.pfv.spmf.tools.MemoryLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AlgoHUINIVMine {
    private ItemsetsTP highUtilityItemsets = null;
    protected UtilityTransactionDatabaseTP database;
    int minUtility;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    private int candidatesCount;
    Set<Integer> negativeItems = new HashSet<Integer>();

    public ItemsetsTP runAlgorithm(UtilityTransactionDatabaseTP database, int minUtility) {
        int candidateCount;
        this.database = database;
        this.minUtility = minUtility;
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        this.highUtilityItemsets = new ItemsetsTP("HIGH UTILITY ITEMSETS");
        this.candidatesCount = 0;
        ArrayList<ItemsetTP> candidatesSize1 = new ArrayList<ItemsetTP>();
        HashMap<Integer, HashSet<Integer>> mapItemTidsets = new HashMap<Integer, HashSet<Integer>>();
        HashMap<Integer, Integer> mapItemTWU = new HashMap<Integer, Integer>();
        int maxItem = Integer.MIN_VALUE;
        for (int i = 0; i < database.size(); ++i) {
            TransactionTP transaction = database.getTransactions().get(i);
            for (int j = 0; j < transaction.getItems().size(); ++j) {
                HashSet<Integer> tidset2;
                ItemUtility itemUtilityObj = transaction.getItems().get(j);
                int item = itemUtilityObj.item;
                int itemUtility = itemUtilityObj.utility;
                if (itemUtility < 0) {
                    this.negativeItems.add(item);
                }
                if (item > maxItem) {
                    maxItem = item;
                }
                if ((tidset2 = (HashSet<Integer>)mapItemTidsets.get(item)) == null) {
                    tidset2 = new HashSet<Integer>();
                    mapItemTidsets.put(item, tidset2);
                }
                tidset2.add(i);
                Integer sumUtility = (Integer)mapItemTWU.get(item);
                if (sumUtility == null) {
                    sumUtility = 0;
                }
                sumUtility = sumUtility + transaction.getTransactionUtility();
                mapItemTWU.put(item, sumUtility);
            }
        }
        for (TransactionTP transaction : database.getTransactions()) {
            Collections.sort(transaction.getItems(), new Comparator<ItemUtility>(){

                @Override
                public int compare(ItemUtility o1, ItemUtility o2) {
                    return o1.item - o2.item;
                }
            });
        }
        for (int item = 0; item <= maxItem; ++item) {
            Integer estimatedUtility = (Integer)mapItemTWU.get(item);
            if (estimatedUtility == null || estimatedUtility < minUtility) continue;
            ItemsetTP itemset2 = new ItemsetTP();
            itemset2.addItem(item);
            itemset2.setTIDset((Set)mapItemTidsets.get(item));
            candidatesSize1.add(itemset2);
            this.highUtilityItemsets.addItemset(itemset2, itemset2.size());
        }
        List<ItemsetTP> currentLevel = candidatesSize1;
        do {
            candidateCount = this.highUtilityItemsets.getItemsetsCount();
            currentLevel = this.generateCandidateSizeK(currentLevel, this.highUtilityItemsets);
        } while (candidateCount != this.highUtilityItemsets.getItemsetsCount());
        MemoryLogger.getInstance().checkMemory();
        this.candidatesCount = this.highUtilityItemsets.getItemsetsCount();
        for (List<ItemsetTP> level : this.highUtilityItemsets.getLevels()) {
            Iterator<ItemsetTP> iterItemset = level.iterator();
            while (iterItemset.hasNext()) {
                ItemsetTP candidate = iterItemset.next();
                if (this.onlyContainsNegativeItems(candidate.getItems())) {
                    iterItemset.remove();
                    this.highUtilityItemsets.decreaseCount();
                    continue;
                }
                for (TransactionTP transaction : database.getTransactions()) {
                    int transactionUtility = 0;
                    int matchesCount = 0;
                    for (int i = 0; i < transaction.size(); ++i) {
                        if (!candidate.getItems().contains(transaction.get((int)i).item)) continue;
                        transactionUtility += transaction.getItemsUtilities().get((int)i).utility;
                        ++matchesCount;
                    }
                    if (matchesCount != candidate.size()) continue;
                    candidate.incrementUtility(transactionUtility);
                }
                if (candidate.getUtility() >= minUtility) continue;
                iterItemset.remove();
                this.highUtilityItemsets.decreaseCount();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return this.highUtilityItemsets;
    }

    private boolean onlyContainsNegativeItems(List<Integer> items) {
        for (Integer item : items) {
            if (this.negativeItems.contains(item)) continue;
            return false;
        }
        return true;
    }

    protected List<ItemsetTP> generateCandidateSizeK(List<ItemsetTP> levelK_1, ItemsetsTP candidatesHTWUI) {
        block0: for (int i = 0; i < levelK_1.size(); ++i) {
            ItemsetTP itemset1 = levelK_1.get(i);
            block1: for (int j = i + 1; j < levelK_1.size(); ++j) {
                ItemsetTP itemset2 = levelK_1.get(j);
                for (int k = 0; k < itemset1.size(); ++k) {
                    if (k == itemset1.size() - 1) {
                        if (itemset1.getItems().get(k) < itemset2.get(k)) continue;
                        continue block0;
                    }
                    if (itemset1.getItems().get(k) < itemset2.get(k)) continue block1;
                    if (itemset1.getItems().get(k) > itemset2.get(k)) continue block0;
                }
                Integer missing = itemset2.get(itemset2.size() - 1);
                HashSet<Integer> tidset2 = new HashSet<Integer>();
                for (Integer n : itemset1.getTIDset()) {
                    if (!itemset2.getTIDset().contains(n)) continue;
                    tidset2.add(n);
                }
                int twu = 0;
                for (Integer tid : tidset2) {
                    twu += this.database.getTransactions().get(tid).getTransactionUtility();
                }
                if (twu < this.minUtility) continue;
                ItemsetTP itemsetTP = new ItemsetTP();
                for (int k = 0; k < itemset1.size(); ++k) {
                    itemsetTP.addItem(itemset1.get(k));
                }
                itemsetTP.addItem(missing);
                itemsetTP.setTIDset(tidset2);
                candidatesHTWUI.addItemset(itemsetTP, itemsetTP.size());
            }
        }
        return candidatesHTWUI.getLevels().get(candidatesHTWUI.getLevels().size() - 1);
    }

    public void printStats() {
        System.out.println("=============  HUINIV-MINE ALGORITHM - STATS =============");
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Candidates count : " + this.candidatesCount);
        System.out.println(" High-utility itemsets count : " + this.highUtilityItemsets.getItemsetsCount());
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

