/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.uapriori;

import ca.pfv.spmf.algorithms.frequentpatterns.uapriori.ItemUApriori;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class ItemsetUApriori {
    private List<ItemUApriori> items = new ArrayList<ItemUApriori>();
    private double expectedsupport = 0.0;

    public double getExpectedSupport() {
        return this.expectedsupport;
    }

    public String getSupportAsString() {
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(this.expectedsupport);
    }

    void increaseSupportBy(double supp) {
        this.expectedsupport += supp;
    }

    void addItem(ItemUApriori value) {
        this.items.add(value);
    }

    public List<ItemUApriori> getItems() {
        return this.items;
    }

    public ItemUApriori get(int index) {
        return this.items.get(index);
    }

    public void print() {
        System.out.print(this.toString());
    }

    public void printWithoutSupport() {
        StringBuilder r = new StringBuilder();
        for (ItemUApriori attribute : this.items) {
            r.append(attribute.getId());
            r.append(' ');
        }
        System.out.print(r);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (ItemUApriori attribute : this.items) {
            r.append(attribute.toString());
            r.append(' ');
        }
        return r.toString();
    }

    public boolean contains(ItemUApriori item) {
        return this.items.contains(item);
    }

    boolean isLexicallySmallerthan(ItemsetUApriori itemset2) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i).getId() > itemset2.items.get(i).getId()) {
                return false;
            }
            if (this.items.get(i).getId() >= itemset2.items.get(i).getId()) continue;
            return true;
        }
        return true;
    }

    public boolean isEqualTo(ItemsetUApriori itemset2) {
        if (this.items.size() != itemset2.items.size()) {
            return false;
        }
        for (ItemUApriori val : this.items) {
            if (itemset2.contains(val)) continue;
            return false;
        }
        return true;
    }

    void setExpectedSupport(double expectedsupport) {
        this.expectedsupport = expectedsupport;
    }

    ItemsetUApriori cloneItemSetMinusOneItem(ItemUApriori itemToExclude) {
        ItemsetUApriori itemset2 = new ItemsetUApriori();
        for (ItemUApriori item : this.items) {
            if (item.equals(itemToExclude)) continue;
            itemset2.addItem(item);
        }
        return itemset2;
    }

    public int size() {
        return this.items.size();
    }

    ItemUApriori allTheSameExceptLastItem(ItemsetUApriori itemset2) {
        if (itemset2.size() != this.items.size()) {
            return null;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!(i == this.items.size() - 1 ? this.items.get(i).getId() >= itemset2.get(i).getId() : this.items.get(i).getId() != itemset2.get(i).getId())) continue;
            return null;
        }
        return itemset2.get(itemset2.size() - 1);
    }

    void setItems(List<ItemUApriori> items) {
        this.items = items;
    }
}

