/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup;

import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.UPNode;
import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.UPTree;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoUPGrowth {
    private double maxMemory = 0.0;
    private long startTimestamp = 0L;
    private long endTimestamp = 0L;
    private int huiCount = 0;
    private int phuisCount;
    private Map<Integer, Integer> mapMinimumItemUtility;
    private BufferedWriter writer = null;
    private List<Itemset> phuis = new ArrayList<Itemset>();
    private final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        String[] items;
        String[] split;
        String thisLine;
        this.maxMemory = 0.0;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        final HashMap<Integer, Integer> mapItemToTWU = new HashMap<Integer, Integer>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Integer twu = (Integer)mapItemToTWU.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    mapItemToTWU.put(item, twu);
                }
            }
        }
        this.mapMinimumItemUtility = new HashMap<Integer, Integer>();
        try {
            UPTree tree = new UPTree();
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split2 = thisLine.split(":");
                String[] items2 = split2[0].split(" ");
                String[] utilityValues = split2[2].split(" ");
                int remainingUtility = 0;
                ArrayList<Item> revisedTransaction = new ArrayList<Item>();
                for (int i = 0; i < items2.length; ++i) {
                    int itm = Integer.parseInt(items2[i]);
                    int utility = Integer.parseInt(utilityValues[i]);
                    if ((Integer)mapItemToTWU.get(itm) < minUtility) continue;
                    Item element = new Item(itm, utility);
                    revisedTransaction.add(element);
                    remainingUtility += utility;
                    Integer minItemUtil = this.mapMinimumItemUtility.get(itm);
                    if (minItemUtil == null || minItemUtil >= utility) {
                        this.mapMinimumItemUtility.put(itm, utility);
                    }
                    element = null;
                }
                Collections.sort(revisedTransaction, new Comparator<Item>(){

                    @Override
                    public int compare(Item o1, Item o2) {
                        return AlgoUPGrowth.this.compareItemsDesc(o1.name, o2.name, mapItemToTWU);
                    }
                });
                tree.addTransaction(revisedTransaction, remainingUtility);
            }
            tree.createHeaderList(mapItemToTWU);
            this.checkMemory();
            this.upgrowth(tree, minUtility, new int[0]);
            this.checkMemory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.phuisCount = this.phuis.size();
        Collections.sort(this.phuis, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset arg0, Itemset arg1) {
                return arg0.size() - arg1.size();
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Item> revisedTransaction = new ArrayList<Item>();
                for (int i = 0; i < items.length; ++i) {
                    int item = Integer.parseInt(items[i]);
                    int utility = Integer.parseInt(utilityValues[i]);
                    Item element = new Item(item, utility);
                    if ((Integer)mapItemToTWU.get(item) < minUtility) continue;
                    revisedTransaction.add(element);
                }
                Collections.sort(revisedTransaction, new Comparator<Item>(){

                    @Override
                    public int compare(Item o1, Item o2) {
                        return o1.name - o2.name;
                    }
                });
                for (Itemset itemset2 : this.phuis) {
                    if (itemset2.size() > revisedTransaction.size()) break;
                    this.updateExactUtility(revisedTransaction, itemset2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Itemset itemset3 : this.phuis) {
            if (itemset3.getExactUtility() < minUtility) continue;
            this.writeOut(itemset3);
        }
        this.checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        this.phuis.clear();
        this.mapMinimumItemUtility = null;
        this.writer.close();
    }

    private int compareItemsDesc(int item1, int item2, Map<Integer, Integer> mapItemEstimatedUtility) {
        int compare = mapItemEstimatedUtility.get(item2) - mapItemEstimatedUtility.get(item1);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void upgrowth(UPTree tree, int minUtility, int[] prefix) throws IOException {
        for (int i = tree.headerList.size() - 1; i >= 0; --i) {
            Integer item = tree.headerList.get(i);
            UPTree localTree = this.createLocalTree(minUtility, tree, item);
            UPNode pathCPB = tree.mapItemNodes.get(item);
            int pathCPBUtility = 0;
            while (pathCPB != null) {
                pathCPBUtility += pathCPB.nodeUtility;
                pathCPB = pathCPB.nodeLink;
            }
            if (pathCPBUtility < minUtility) continue;
            int[] newPrefix = new int[prefix.length + 1];
            System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
            newPrefix[prefix.length] = item;
            this.savePHUI(newPrefix);
            if (localTree.headerList.size() <= 0) continue;
            this.upgrowth(localTree, minUtility, newPrefix);
        }
    }

    /*
     * WARNING - void declaration
     */
    private UPTree createLocalTree(int minUtility, UPTree tree, Integer item) {
        ArrayList prefixPaths = new ArrayList();
        UPNode path = tree.mapItemNodes.get(item);
        final HashMap<Integer, Integer> itemPathUtility = new HashMap<Integer, Integer>();
        while (path != null) {
            int nodeutility = path.nodeUtility;
            if (path.parent.itemID != -1) {
                void var9_10;
                ArrayList<Object> prefixPath = new ArrayList<Object>();
                prefixPath.add(path);
                UPNode uPNode = path.parent;
                while (var9_10.itemID != -1) {
                    prefixPath.add(var9_10);
                    Integer pu = (Integer)itemPathUtility.get(var9_10.itemID);
                    pu = pu == null ? nodeutility : pu + nodeutility;
                    itemPathUtility.put(var9_10.itemID, pu);
                    UPNode uPNode2 = var9_10.parent;
                }
                prefixPaths.add(prefixPath);
            }
            path = path.nodeLink;
        }
        UPTree localTree = new UPTree();
        for (List list : prefixPaths) {
            int pathCount = ((UPNode)list.get((int)0)).count;
            int pathUtility = ((UPNode)list.get((int)0)).nodeUtility;
            ArrayList<Integer> localPath = new ArrayList<Integer>();
            for (int j = 1; j < list.size(); ++j) {
                int itemValue = 0;
                UPNode node = (UPNode)list.get(j);
                if ((Integer)itemPathUtility.get(node.itemID) >= minUtility) {
                    localPath.add(node.itemID);
                } else {
                    Integer minItemUtility = this.mapMinimumItemUtility.get(node.itemID);
                    itemValue = minItemUtility * pathCount;
                }
                pathUtility -= itemValue;
            }
            Collections.sort(localPath, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return AlgoUPGrowth.this.compareItemsDesc(o1, o2, itemPathUtility);
                }
            });
            localTree.addLocalTransaction(localPath, pathUtility, this.mapMinimumItemUtility, pathCount);
        }
        localTree.createHeaderList(itemPathUtility);
        return localTree;
    }

    private void savePHUI(int[] itemset2) {
        Itemset itemsetObj = new Itemset(itemset2);
        Arrays.sort(itemset2);
        this.phuis.add(itemsetObj);
    }

    public void updateExactUtility(List<Item> transaction, Itemset itemset2) {
        int utility = 0;
        block0: for (int i = 0; i < itemset2.size(); ++i) {
            Integer itemI = itemset2.get(i);
            for (int j = 0; j < transaction.size(); ++j) {
                Item itemJ = transaction.get(j);
                if (itemJ.name == itemI) {
                    utility += transaction.get((int)j).utility;
                    continue block0;
                }
                if (itemJ.name <= itemI) continue;
                return;
            }
            return;
        }
        itemset2.increaseUtility(utility);
    }

    private void writeOut(Itemset HUI2) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < HUI2.size(); ++i) {
            buffer.append(HUI2.get(i));
            buffer.append(' ');
        }
        buffer.append("#UTIL: ");
        buffer.append(HUI2.getExactUtility());
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  UP-GROWTH ALGORITHM - STATS =============");
        System.out.println(" PHUIs (candidates) count: " + this.phuisCount);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" HUIs count : " + this.huiCount);
        System.out.println("===================================================");
    }
}

