/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.uphist;

import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.uphist.Hist;
import ca.pfv.spmf.algorithms.frequentpatterns.uphist.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.uphist.ItemSummary;
import ca.pfv.spmf.algorithms.frequentpatterns.uphist.NodeList;
import ca.pfv.spmf.algorithms.frequentpatterns.uphist.UPHistNode;
import ca.pfv.spmf.algorithms.frequentpatterns.uphist.UPHistTree;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoUPHist {
    float previousItem;
    private long startTimestamp = 0L;
    private long endTimestamp = 0L;
    BufferedWriter writer = null;
    private int huiCount = 0;
    final Map<Integer, Integer> mapItemToTWU = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> mapMinimumItemUtility;
    private Map<Integer, Integer> mapMaximumItemUtility;
    static ArrayList<Integer> headerlist = new ArrayList();
    private static HashMap<Integer, ItemSummary> itemDetail = new HashMap();
    private List<Itemset> phuis = new ArrayList<Itemset>();
    private int phuisCount = 0;

    public long getTotalTime() {
        return this.endTimestamp - this.startTimestamp;
    }

    public long getHUICount() {
        return this.huiCount;
    }

    public long getCandidatePatterns() {
        return this.phuisCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String outputFile, int minUtility) throws IOException {
        String[] split;
        String thisLine;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(outputFile));
        MemoryLogger.getInstance().checkMemory();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                String[] items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Integer twu = this.mapItemToTWU.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                }
            }
        }
        this.mapMinimumItemUtility = new HashMap<Integer, Integer>();
        this.mapMaximumItemUtility = new HashMap<Integer, Integer>();
        try {
            UPHistTree tree = new UPHistTree();
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split2 = thisLine.split(":");
                String[] items = split2[0].split(" ");
                String[] utilityValues = split2[2].split(" ");
                int remainingUtility = 0;
                ArrayList<Item> revisedTransaction = new ArrayList<Item>();
                for (int i = 0; i < items.length; ++i) {
                    int itm = Integer.parseInt(items[i]);
                    int utility = Integer.parseInt(utilityValues[i]);
                    if (this.mapItemToTWU.get(itm) < minUtility) continue;
                    Item element = new Item(itm, utility);
                    revisedTransaction.add(element);
                    remainingUtility += utility;
                    Integer minItemUtil = this.mapMinimumItemUtility.get(itm);
                    Integer maxItemUtil = this.mapMaximumItemUtility.get(itm);
                    if (minItemUtil == null || minItemUtil >= utility) {
                        this.mapMinimumItemUtility.put(itm, utility);
                    }
                    if (maxItemUtil == null || maxItemUtil < utility) {
                        this.mapMaximumItemUtility.put(itm, utility);
                    }
                    if (!itemDetail.containsKey(itm)) {
                        ItemSummary summary = new ItemSummary(itm);
                        itemDetail.put(itm, summary);
                    }
                    itemDetail.get(itm).incrementSupp();
                    itemDetail.get(itm).updateTotalFrequency(utility);
                    if (itemDetail.get(itm).getMinFreq() == 0) {
                        itemDetail.get(itm).updateMinFrequency(utility);
                    } else if (utility < itemDetail.get(itm).getMinFreq()) {
                        itemDetail.get(itm).updateMinFrequency(utility);
                    }
                    if (itemDetail.get(itm).getMaxFreq() == 0) {
                        itemDetail.get(itm).updateMaxFrequency(utility);
                        continue;
                    }
                    if (utility <= itemDetail.get(itm).getMaxFreq()) continue;
                    itemDetail.get(itm).updateMaxFrequency(utility);
                }
                Collections.sort(revisedTransaction, new Comparator<Item>(){

                    @Override
                    public int compare(Item o1, Item o2) {
                        return AlgoUPHist.this.compareItemsDesc(o1.name, o2.name, AlgoUPHist.this.mapItemToTWU);
                    }
                });
                tree.addTransaction(revisedTransaction, remainingUtility);
            }
            tree.createHeaderList(this.mapItemToTWU);
            long temp_time = System.currentTimeMillis();
            this.uphistgrowth(tree, minUtility, new int[0], null);
            this.endTimestamp = System.currentTimeMillis();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.phuisCount = this.phuis.size();
        System.out.println("Number of candidates generated is: " + this.phuisCount);
        System.out.println("Verification Started");
        Collections.sort(this.phuis, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset arg0, Itemset arg1) {
                return arg0.size() - arg1.size();
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Item> revisedTransaction = new ArrayList<Item>();
                for (int i = 0; i < items.length; ++i) {
                    int item = Integer.parseInt(items[i]);
                    int utility = Integer.parseInt(utilityValues[i]);
                    Item element = new Item(item, utility);
                    if (this.mapItemToTWU.get(item) < minUtility) continue;
                    revisedTransaction.add(element);
                }
                Collections.sort(revisedTransaction, new Comparator<Item>(){

                    @Override
                    public int compare(Item o1, Item o2) {
                        return o1.name - o2.name;
                    }
                });
                for (Itemset itemset2 : this.phuis) {
                    if (itemset2.size() > revisedTransaction.size()) break;
                    this.updateExactUtility(revisedTransaction, itemset2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Itemset itemset3 : this.phuis) {
            if (itemset3.getExactUtility() < minUtility) continue;
            this.writeOut(itemset3);
            ++this.huiCount;
        }
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
        this.phuis.clear();
        this.mapMinimumItemUtility = null;
        this.mapMaximumItemUtility = null;
    }

    public void updateExactUtility(List<Item> transaction, Itemset itemset2) {
        int utility = 0;
        block0: for (int i = 0; i < itemset2.size(); ++i) {
            Integer itemI = itemset2.get(i);
            for (int j = 0; j < transaction.size(); ++j) {
                Item itemJ = transaction.get(j);
                if (itemJ.name == itemI) {
                    utility += transaction.get((int)j).utility;
                    continue block0;
                }
                if (itemJ.name <= itemI) continue;
                return;
            }
            return;
        }
        itemset2.increaseUtility(utility);
    }

    private void savePHUI(int[] itemset2) {
        Itemset itemsetObj = new Itemset(itemset2);
        this.phuis.add(itemsetObj);
    }

    private int compareItemsDesc(int item1, int item2, Map<Integer, Integer> mapItemEstimatedUtility) {
        int compare = mapItemEstimatedUtility.get(item2) - mapItemEstimatedUtility.get(item1);
        return compare == 0 ? item1 - item2 : compare;
    }

    protected int[] realloc2(int[] oldItemSet, int newElement) {
        if (oldItemSet == null) {
            int[] newItemSet = new int[]{newElement};
            return newItemSet;
        }
        int oldItemSetLength = oldItemSet.length;
        int[] newItemSet = new int[oldItemSetLength + 1];
        newItemSet[0] = newElement;
        for (int index = 0; index < oldItemSetLength; ++index) {
            newItemSet[index + 1] = oldItemSet[index];
        }
        return newItemSet;
    }

    private int uphistgrowth_new(UPHistTree pass_tree, int threshold, int[] pass_prefix, int pass_item, NodeList nList) throws IOException {
        MemoryLogger.getInstance().checkMemory();
        int[] newPrefix = new int[pass_prefix.length + 1];
        System.arraycopy(pass_prefix, 0, newPrefix, 0, pass_prefix.length);
        newPrefix[pass_prefix.length] = pass_item;
        UPHistNode pathCPB = pass_tree.mapItemNodes.get(pass_item);
        int supp = 0;
        int pathCPBUtility = 0;
        Hist histogram = this.genItemHistHeadTabItem(pathCPB);
        while (pathCPB != null) {
            pathCPBUtility += pathCPB.nodeUtility;
            supp += pathCPB.count;
            pathCPB = pathCPB.nodeLink;
        }
        NodeList node = new NodeList(pass_item, histogram);
        node.addNode(nList);
        if (pathCPBUtility >= threshold) {
            float highCodeUtility = this.getNodeHighUtilityValue(node, supp);
            float lowCodeUtility = this.getNodeLowUtilityValue(node, supp);
            UPHistTree localTree = this.createLocalTree(threshold, pass_tree, pass_item);
            if (highCodeUtility >= (float)threshold) {
                if (lowCodeUtility >= (float)threshold) {
                    ++this.huiCount;
                    this.writeOut(newPrefix, lowCodeUtility);
                } else {
                    this.savePHUI(newPrefix);
                    ++this.phuisCount;
                }
            }
            if (localTree.headerList.size() > 0) {
                this.uphistgrowth(localTree, threshold, newPrefix, node);
            }
        }
        return 1;
    }

    public Hist genItemHistHeadTabItem(UPHistNode nodeLink) {
        Hist histogram = new Hist();
        while (nodeLink != null) {
            histogram.updateHist(nodeLink.histogram);
            nodeLink = nodeLink.nodeLink;
        }
        return histogram;
    }

    public int getNodeHighUtilityValue(NodeList nList, int support) {
        int utility = 0;
        for (NodeList tempHead = nList; tempHead != null; tempHead = tempHead.getNextNode()) {
            utility += this.getHighUtilityValue(tempHead.getItemName(), support, tempHead.getHistogram());
        }
        return utility;
    }

    public int getNodeLowUtilityValue(NodeList nList, int support) {
        int utility = 0;
        for (NodeList tempHead = nList; tempHead != null; tempHead = tempHead.getNextNode()) {
            utility += this.getLowUtilityValue(tempHead.getItemName(), support, tempHead.getHistogram());
        }
        return utility;
    }

    public int getHighUtilityValue(int itemName, int support, Hist histogram) {
        int utility = 0;
        ItemSummary iDetail = itemDetail.get(itemName);
        utility = Math.min(iDetail.totalUtility - (iDetail.support - support) * iDetail.minUtility * 1, histogram.getMaxSupportInterU(support) * 1);
        return utility;
    }

    public int getLowUtilityValue(int itemName, int support, Hist histogram) {
        int utility = 0;
        ItemSummary iDetail = itemDetail.get(itemName);
        utility = Math.max(iDetail.totalUtility - (iDetail.support - support) * iDetail.maxUtility, histogram.getMinSupportInterU(support));
        return utility;
    }

    private void uphistgrowth(UPHistTree tree, int minUtility, int[] prefix, NodeList node) throws IOException {
        for (int i = tree.headerList.size() - 1; i >= 0; --i) {
            Integer item = tree.headerList.get(i);
            this.uphistgrowth_new(tree, minUtility, prefix, item, node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private UPHistTree createLocalTree(int minUtility, UPHistTree tree, Integer item) {
        ArrayList<Object> prefixPaths = new ArrayList<Object>();
        UPHistNode path = tree.mapItemNodes.get(item);
        HashMap<Integer, Integer> itemPathUtility = new HashMap<Integer, Integer>();
        while (path != null) {
            int nodeutility = path.nodeUtility;
            if (path.parent.itemID != -1) {
                void var9_11;
                ArrayList prefixPath = new ArrayList();
                prefixPath.add(path);
                UPHistNode uPHistNode = path.parent;
                while (var9_11.itemID != -1) {
                    prefixPath.add(var9_11);
                    Integer pu = (Integer)itemPathUtility.get(var9_11.itemID);
                    pu = pu == null ? nodeutility : pu + nodeutility;
                    itemPathUtility.put(var9_11.itemID, pu);
                    UPHistNode uPHistNode2 = var9_11.parent;
                }
                prefixPaths.add(prefixPath);
            }
            path = path.nodeLink;
        }
        UPHistTree localTree = new UPHistTree();
        for (List list : prefixPaths) {
            int pathCount = ((UPHistNode)list.get((int)0)).count;
            int pathUtility = ((UPHistNode)list.get((int)0)).nodeUtility;
            ArrayList<UPHistNode> localPath = new ArrayList<UPHistNode>();
            for (int j = 1; j < list.size(); ++j) {
                int itemValue = 0;
                UPHistNode node = (UPHistNode)list.get(j);
                if ((Integer)itemPathUtility.get(node.itemID) >= minUtility) {
                    localPath.add(node);
                } else {
                    Integer minItemUtility = 0;
                    minItemUtility = node.histogram.getMinSupportInterU(pathCount);
                    itemValue = minItemUtility;
                }
                pathUtility -= itemValue;
            }
            Collections.sort(localPath, new Comparator<UPHistNode>(){

                @Override
                public int compare(UPHistNode o1, UPHistNode o2) {
                    return AlgoUPHist.this.compareItemsDesc(o1.itemID, o2.itemID, AlgoUPHist.this.mapItemToTWU);
                }
            });
            int supp = pathCount;
            try {
                localTree.addLocalTransaction(localPath, pathUtility, this.mapMinimumItemUtility, supp);
            }
            catch (Exception e) {
                System.out.println("Exception in adding path to local tree");
                System.out.println("pathUtility: " + pathUtility + " supp: " + supp + " mapMinimumItemUtility: " + this.mapMinimumItemUtility.get((short)1));
                e.printStackTrace();
                System.out.println(((Object)localPath).toString());
                throw e;
            }
        }
        localTree.createHeaderList(this.mapItemToTWU);
        for (int i = 0; i < localTree.headerList.size(); ++i) {
            int n = localTree.headerList.get(i);
            headerlist.add(n);
        }
        return localTree;
    }

    private void writeOut(Itemset HUI2) throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < HUI2.size(); ++i) {
            buffer.append(HUI2.get(i));
            buffer.append(' ');
        }
        buffer.append("#UTIL: ");
        buffer.append(HUI2.getExactUtility());
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void writeOut(int[] itemset2, float utility) throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < itemset2.length; ++i) {
            buffer.append(itemset2[i]);
            buffer.append(' ');
        }
        buffer.append("#UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        System.out.println("=============  UPHist ALGORITHM - SPMF 0.2.34 - STATS =============");
        System.out.println(" Total time: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory:  " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" HUI count: " + this.huiCount);
        System.out.println("===================================================");
    }
}

