/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.uphist;

public class ItemSummary {
    int itemName;
    int minUtility;
    int maxUtility;
    int TWU;
    int totalUtility;
    int support;

    ItemSummary() {
    }

    public ItemSummary(int item) {
        this.itemName = item;
        this.minUtility = 0;
        this.maxUtility = 0;
        this.TWU = 0;
        this.totalUtility = 0;
        this.support = 0;
    }

    public ItemSummary(int item, int minF, int maxF, int twu, int totalF, int supp) {
        this.itemName = item;
        this.minUtility = minF;
        this.maxUtility = maxF;
        this.TWU = twu;
        this.totalUtility = totalF;
        this.support = supp;
    }

    public void updateMinFrequency(int minF) {
        this.minUtility = minF;
    }

    public void updateMaxFrequency(int maxF) {
        this.maxUtility = maxF;
    }

    public void updateTWU(int twu) {
        this.TWU += twu;
    }

    public void updateTotalFrequency(int freq) {
        this.totalUtility += freq;
    }

    public void incrementSupp() {
        ++this.support;
    }

    public int getItemName() {
        return this.itemName;
    }

    public int getMinFreq() {
        return this.minUtility;
    }

    public int getMaxFreq() {
        return this.maxUtility;
    }

    public int getTWU() {
        return this.TWU;
    }

    public int getTotalFreq() {
        return this.totalUtility;
    }

    public int getSupport() {
        return this.support;
    }

    public void output() {
        System.out.println("ItemName : " + this.itemName);
        System.out.println("MinFrequency : " + this.minUtility);
        System.out.println("MaxFrequency : " + this.maxUtility);
        System.out.println("TWU : " + this.TWU);
        System.out.println("TotalUtility : " + this.totalUtility);
        System.out.println("Support : " + this.support);
    }

    public String toString() {
        String line = "";
        line = line + this.itemName + " " + this.minUtility + " " + this.maxUtility + " " + this.TWU + " " + this.totalUtility + " " + this.support;
        return line;
    }
}

