/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.vhuqi;

import ca.pfv.spmf.algorithms.frequentpatterns.vhuqi.QItemTrans;
import ca.pfv.spmf.algorithms.frequentpatterns.vhuqi.UtilityList;
import ca.pfv.spmf.algorithms.frequentpatterns.vhuqi.enumVHUQIMethod;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class AlgoVHUQI {
    long startTime;
    long endTime;
    DecimalFormat decimalFormat = new DecimalFormat("#.##");
    int muv;
    String profitTable;
    int relatedCoefficient;
    int totalUtility;
    enumVHUQIMethod methodType;
    HashMap<String, Integer> profitHashMap;
    HashMap<String, UtilityList> qItemsUtilityList;
    ArrayList<Integer> arrayTWU;
    long maxMemory;
    int huqiCount;
    int countUL;
    int countWeak;

    public void runAlgorithm(String inputFileDBPath, String inputFileProfitPath, String outputPath, float minUtility, int relativeCoefficient, enumVHUQIMethod method) throws IOException {
        this.startTime = System.currentTimeMillis();
        this.countUL = 0;
        this.countWeak = 0;
        this.huqiCount = 0;
        this.maxMemory = 0L;
        this.profitHashMap = new HashMap();
        this.qItemsUtilityList = new HashMap();
        this.arrayTWU = new ArrayList();
        ArrayList<String> qItemNameList = new ArrayList<String>();
        ArrayList<String> nextNameList = new ArrayList<String>();
        ArrayList<String> hwQUI = new ArrayList<String>();
        String inputDatabase = inputFileDBPath;
        this.profitTable = inputFileProfitPath;
        this.relatedCoefficient = relativeCoefficient;
        this.methodType = method;
        String huqiOutputPath = outputPath;
        String newDatabase = "temp_newDatabase.txt";
        BufferedWriter writerHQUI = new BufferedWriter(new FileWriter(huqiOutputPath));
        this.readFileFromTwoDatabase(inputDatabase, newDatabase);
        this.muv = (int)((float)this.totalUtility * minUtility);
        this.buildUtilityList(newDatabase, qItemNameList);
        this.findHQUA(writerHQUI, qItemNameList, hwQUI);
        this.miner(this.qItemsUtilityList, null, qItemNameList, nextNameList, writerHQUI, hwQUI);
        File file = new File(newDatabase);
        file.delete();
        this.endTime = System.currentTimeMillis();
        writerHQUI.close();
    }

    private void readFileFromTwoDatabase(String inputDatabase, String newDatabase) throws IOException {
        String[] itemInfo;
        String str;
        BufferedReader readerProfitTable = new BufferedReader(new FileReader(this.profitTable));
        BufferedReader readerInputDB = new BufferedReader(new FileReader(inputDatabase));
        BufferedWriter writer = new BufferedWriter(new FileWriter(newDatabase));
        this.profitHashMap.clear();
        this.qItemsUtilityList.clear();
        int line = 0;
        this.totalUtility = 0;
        while ((str = readerProfitTable.readLine()) != null) {
            itemInfo = str.split(", ");
            if (itemInfo.length < 2) continue;
            int profit = Integer.parseInt(itemInfo[1]);
            if (profit == 0) {
                profit = 1;
            }
            int item = Integer.parseInt(itemInfo[0]);
            this.profitHashMap.put(String.valueOf(item), profit);
        }
        readerProfitTable.close();
        while ((str = readerInputDB.readLine()) != null) {
            ++line;
            itemInfo = str.split(" ");
            ArrayList<String> qItemset = new ArrayList<String>();
            int strUtility = 0;
            for (int i = 0; i < itemInfo.length; ++i) {
                try {
                    itemInfo[i] = itemInfo[i].substring(1, itemInfo[i].length() - 1);
                }
                catch (Exception e) {
                    System.out.println("info1=" + itemInfo[i] + "@line=" + line);
                    itemInfo[i] = itemInfo[i].substring(1, itemInfo[i].length() - 1);
                }
                String[] itemInfoSplit = itemInfo[i].split(",");
                int profit = 0;
                try {
                    profit = this.profitHashMap.get(itemInfoSplit[0]);
                }
                catch (Exception e) {
                    System.out.println("!" + str + "!");
                    System.out.println(itemInfoSplit[0]);
                }
                int quantity = Integer.parseInt(itemInfoSplit[1]);
                strUtility += profit * quantity;
                qItemset.add(itemInfo[i]);
                if (this.qItemsUtilityList.containsKey(itemInfo[i])) continue;
                UtilityList ul = new UtilityList("", itemInfo[i], 0);
                this.qItemsUtilityList.put(itemInfo[i], ul);
            }
            this.arrayTWU.add(strUtility);
            this.totalUtility += strUtility;
            this.sortUtility(qItemset);
            for (String qItem : qItemset) {
                writer.write("(" + qItem + ") ");
            }
            writer.newLine();
        }
        long usedMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
        if (this.maxMemory < usedMem) {
            this.maxMemory = usedMem;
        }
        readerInputDB.close();
        writer.close();
    }

    private void buildUtilityList(String newDatabase, ArrayList<String> qItemNameList) throws IOException {
        BufferedReader readerInputDB = new BufferedReader(new FileReader(newDatabase));
        String str = "";
        int tid = 0;
        while ((str = readerInputDB.readLine()) != null) {
            String[] itemInfo = str.split(" ");
            int ru = this.arrayTWU.get(++tid - 1);
            for (int i = 0; i < itemInfo.length; ++i) {
                try {
                    itemInfo[i] = itemInfo[i].substring(1, itemInfo[i].length() - 1);
                    String[] itemInfoSplit = itemInfo[i].split(",");
                    int profit = this.profitHashMap.get(itemInfoSplit[0]);
                    int quantity = Integer.parseInt(itemInfoSplit[1]);
                    int utility = profit * quantity;
                    UtilityList ul = this.qItemsUtilityList.get(itemInfo[i]);
                    QItemTrans qTid = new QItemTrans(tid, utility, ru -= utility);
                    ul.addTrans(qTid, this.arrayTWU.get(tid - 1));
                    this.qItemsUtilityList.put(itemInfo[i], ul);
                    if (qItemNameList.contains(itemInfo[i])) continue;
                    qItemNameList.add(itemInfo[i]);
                    continue;
                }
                catch (Exception e) {
                    System.out.println(itemInfo[i] + "$");
                }
            }
        }
        this.sortUtility(qItemNameList);
        this.countUL += this.qItemsUtilityList.size();
        long usedMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
        if (this.maxMemory < usedMem) {
            this.maxMemory = usedMem;
        }
    }

    private void sortUtility(ArrayList<String> qItemNameList) {
        Collections.sort(qItemNameList, new Comparator<String>(){

            @Override
            public int compare(String qItem1, String qItem2) {
                String[] info1 = qItem1.split(",");
                String[] info2 = qItem2.split(",");
                int util1 = AlgoVHUQI.this.profitHashMap.get(info1[0]) * Integer.parseInt(info1[1]);
                int util2 = AlgoVHUQI.this.profitHashMap.get(info2[0]) * Integer.parseInt(info2[1]);
                if (util2 == util1) {
                    return info1[0].compareToIgnoreCase(info2[0]);
                }
                return util2 - util1;
            }
        });
    }

    private void findHQUA(BufferedWriter writerHUQI, ArrayList<String> qItemNameList, ArrayList<String> hwQUI) throws IOException {
        long usedMem;
        ArrayList<String> candidateList = new ArrayList<String>();
        for (int i = 0; i < qItemNameList.size(); ++i) {
            int us = this.qItemsUtilityList.get(qItemNameList.get(i)).getSumEU();
            if (us >= this.muv) {
                writerHUQI.write("(" + qItemNameList.get(i) + ") #UTIL: " + us + "\r\n");
                hwQUI.add(qItemNameList.get(i));
                ++this.huqiCount;
                continue;
            }
            if (this.methodType != enumVHUQIMethod.MAXC && (double)us >= Math.floor((double)this.muv / (double)this.relatedCoefficient) || this.methodType == enumVHUQIMethod.MAXC && (double)us >= Math.floor((double)this.muv / 2.0)) {
                candidateList.add(qItemNameList.get(i));
            }
            float temp = (float)this.muv / (float)this.qItemsUtilityList.get(qItemNameList.get(i)).getMaxEURU();
            int kSupportBound = (int)Math.ceil(temp);
            if (this.qItemsUtilityList.get(qItemNameList.get(i)).getQItemTrans().size() < kSupportBound) continue;
            ++this.countWeak;
            hwQUI.add(qItemNameList.get(i));
        }
        if (candidateList.size() > 0) {
            long usedMem2 = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
            if (this.maxMemory < usedMem2) {
                this.maxMemory = usedMem2;
            }
            this.combineMethod(candidateList, writerHUQI, qItemNameList, hwQUI, null, null);
        }
        if (this.maxMemory < (usedMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed())) {
            this.maxMemory = usedMem;
        }
    }

    private String preprocessCombine(ArrayList<String> candidate) {
        String name = "";
        for (int i = 0; i < candidate.size(); ++i) {
            String qName = candidate.get(i);
            String[] qNameSpilt = qName.split(",");
            if (qNameSpilt.length >= 3) continue;
            qName = qNameSpilt[0] + "," + qNameSpilt[1] + "," + qNameSpilt[1];
            candidate.set(i, qName);
        }
        Collections.sort(candidate);
        for (String qname : candidate) {
            name = name + "(" + qname + ") ";
        }
        name = name.substring(0, name.length() - 1);
        candidate.clear();
        return name;
    }

    private void buildUtilityListofCombine(String qName, ArrayList<String> qItemNameList) {
        String[] qNameSplit = qName.split(",");
        int lowerBound = Integer.parseInt(qNameSplit[1]);
        int upperBound = Integer.parseInt(qNameSplit[2]);
        UtilityList ul = new UtilityList("", qName, 0);
        for (int i = lowerBound; i <= upperBound; ++i) {
            ul.addNoPrefixUtilityList(this.qItemsUtilityList.get(qNameSplit[0] + "," + i));
        }
        this.qItemsUtilityList.put(qName, ul);
        ++this.countUL;
        if (qItemNameList.contains(qNameSplit[0] + "," + upperBound)) {
            int site = qItemNameList.indexOf(qNameSplit[0] + "," + upperBound);
            qItemNameList.add(site, qName);
        }
    }

    private int utilityCal(String qItem, int preUS) {
        qItem = (String)qItem.subSequence(1, qItem.length() - 1);
        String[] qItemSplit = qItem.split(",");
        int quantity = 0;
        int utility = 0;
        if (qItemSplit.length > 2) {
            int lower = Integer.parseInt(qItemSplit[1]);
            int upper = Integer.parseInt(qItemSplit[2]);
            for (int i = lower; i <= upper; ++i) {
                utility += preUS + this.qItemsUtilityList.get(qItemSplit[0] + "," + i).getSumEU();
            }
        } else {
            quantity = Integer.parseInt(qItemSplit[1]);
            utility += preUS + this.qItemsUtilityList.get(qItemSplit[0] + "," + quantity).getSumEU();
        }
        return utility;
    }

    private UtilityList construct(UtilityList ul1, UtilityList ul2, UtilityList preUL) {
        String[] name2split;
        String[] name1split = ul1.getName().split(",");
        if (name1split[0].equals((name2split = ul2.getName().split(","))[0])) {
            return null;
        }
        if (preUL == null) {
            UtilityList conUl;
            int i;
            int upperBound;
            int lowerBound;
            if (ul1.getQItemTrans().size() == 0) {
                lowerBound = Integer.parseInt(ul1.getName().split(",")[1]);
                upperBound = Integer.parseInt(ul1.getName().split(",")[2]);
                for (i = lowerBound; i <= upperBound; ++i) {
                    ul1.addNoPrefixUtilityListQItemTrans(this.qItemsUtilityList.get(ul1.getName().split(",")[0] + "," + i));
                }
            }
            if (ul2.getQItemTrans().size() == 0) {
                lowerBound = Integer.parseInt(ul2.getName().split(",")[1]);
                upperBound = Integer.parseInt(ul2.getName().split(",")[2]);
                for (i = lowerBound; i <= upperBound; ++i) {
                    ul2.addNoPrefixUtilityListQItemTrans(this.qItemsUtilityList.get(ul2.getName().split(",")[0] + "," + i));
                }
            }
            if (this.constructLengthOne(conUl = new UtilityList("(" + ul1.getName() + ")", ul2.getName(), 0), ul1.getQItemTrans(), ul2.getQItemTrans())) {
                long usedMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
                if (this.maxMemory < usedMem) {
                    this.maxMemory = usedMem;
                }
                return conUl;
            }
        } else {
            UtilityList conUl = new UtilityList(ul1.getPrefix() + " (" + ul1.getName() + ")", ul2.getName(), 0);
            if (this.constructLengthOneMore(conUl, ul1.getQItemTrans(), ul2.getQItemTrans(), preUL.getQItemTrans())) {
                long usedMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
                if (this.maxMemory < usedMem) {
                    this.maxMemory = usedMem;
                }
                return conUl;
            }
        }
        return null;
    }

    public boolean constructLengthOne(UtilityList conUl, List<QItemTrans> qT1, List<QItemTrans> qT2) {
        int i = 0;
        int j = 0;
        while (i < qT1.size() && j < qT2.size()) {
            int tid2;
            int tid1 = qT1.get(i).getTid();
            if (tid1 == (tid2 = qT2.get(j).getTid())) {
                int eu1 = qT1.get(i).getEu();
                int eu2 = qT2.get(j).getEu();
                if (qT1.get(i).getRu() >= qT2.get(j).getRu()) {
                    QItemTrans temp = new QItemTrans(tid1, eu1 + eu2, qT2.get(j).getRu());
                    conUl.addTrans(temp, this.arrayTWU.get(tid1 - 1));
                }
                ++i;
                ++j;
                continue;
            }
            if (tid1 > tid2) {
                ++j;
                continue;
            }
            ++i;
        }
        return conUl.getqItemTransLength() > 0;
    }

    private boolean constructLengthOneMore(UtilityList conUl, ArrayList<QItemTrans> qT1, ArrayList<QItemTrans> qT2, ArrayList<QItemTrans> preQT) {
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < qT1.size() && j < qT2.size()) {
            int tid2;
            int tid1 = qT1.get(i).getTid();
            if (tid1 == (tid2 = qT2.get(j).getTid())) {
                int eu1 = qT1.get(i).getEu();
                int eu2 = qT2.get(j).getEu();
                while (preQT.get(k).getTid() != tid1) {
                    ++k;
                }
                int preEU = preQT.get(k).getEu();
                if (qT1.get(i).getRu() >= qT2.get(j).getRu()) {
                    QItemTrans temp = new QItemTrans(tid1, eu1 + eu2 - preEU, qT2.get(j).getRu());
                    conUl.addTrans(temp, this.arrayTWU.get(tid1 - 1));
                }
                ++i;
                ++j;
                continue;
            }
            if (tid1 > tid2) {
                ++j;
                continue;
            }
            ++i;
        }
        return conUl.getqItemTransLength() > 0;
    }

    private void miner(HashMap<String, UtilityList> nowUL, UtilityList beforeUL, ArrayList<String> qItemNameList, ArrayList<String> nextNameList, BufferedWriter writerHUQI, ArrayList<String> hwQUI) throws IOException {
        for (int i = 0; i < qItemNameList.size(); ++i) {
            long usedMem;
            nextNameList.clear();
            HashMap<String, UtilityList> nextHUL = new HashMap<String, UtilityList>();
            HashMap<String, UtilityList> candidateHUL = new HashMap<String, UtilityList>();
            ArrayList<String> childNextNameList = new ArrayList<String>();
            ArrayList<String> nextHWQUI = new ArrayList<String>();
            if (!hwQUI.contains(qItemNameList.get(i))) continue;
            ArrayList<String> candidateList = new ArrayList<String>();
            for (int j = i + 1; j < qItemNameList.size(); ++j) {
                UtilityList afterUL;
                if (qItemNameList.get(j).split(",").length == 3 || (afterUL = this.construct(nowUL.get(qItemNameList.get(i)), nowUL.get(qItemNameList.get(j)), beforeUL)) == null) continue;
                nextNameList.add(afterUL.getName());
                if (afterUL.getSumEU() >= this.muv) {
                    writerHUQI.write(afterUL.getPrefix() + " (" + afterUL.getName() + ") #UTIL: " + afterUL.getSumEU() + "\r\n");
                    ++this.huqiCount;
                    nextHWQUI.add(afterUL.getName());
                } else {
                    if ((this.methodType != enumVHUQIMethod.MAXC && (double)afterUL.getSumEU() >= Math.floor((double)this.muv / (double)this.relatedCoefficient) || this.methodType == enumVHUQIMethod.MAXC && (double)afterUL.getSumEU() >= Math.floor((double)this.muv / 2.0)) && !candidateList.contains(afterUL.getName())) {
                        candidateList.add(afterUL.getName());
                        candidateHUL.put(afterUL.getName(), afterUL);
                    }
                    float temp = (float)this.muv / (float)afterUL.getMaxEURU();
                    int kSupportBound = (int)Math.ceil(temp);
                    if (afterUL.getQItemTrans().size() >= kSupportBound) {
                        ++this.countWeak;
                        nextHWQUI.add(afterUL.getName());
                    }
                }
                nextHUL.put(afterUL.getName(), afterUL);
                ++this.countUL;
            }
            if (candidateList.size() > 0) {
                this.combineMethod(candidateList, writerHUQI, nextNameList, nextHWQUI, candidateHUL, nextHUL);
                candidateHUL.clear();
                candidateList.clear();
            }
            if (this.maxMemory < (usedMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed())) {
                this.maxMemory = usedMem;
            }
            if (nextNameList.size() >= 1 && nextHUL.size() > 0) {
                this.miner(nextHUL, nowUL.get(qItemNameList.get(i)), nextNameList, childNextNameList, writerHUQI, nextHWQUI);
            }
            nextHUL.clear();
            childNextNameList.clear();
            nextHWQUI.clear();
            nowUL.remove(qItemNameList.get(i));
        }
    }

    private void buildUtilityListofcombine2(String qName, HashMap<String, UtilityList> nowUL) {
        String[] qNameSplit = qName.split(",");
        int lowerBound = Integer.parseInt(qNameSplit[1]);
        int upperBound = Integer.parseInt(qNameSplit[2]);
        String prefix = nowUL.get(qNameSplit[0] + "," + lowerBound).getPrefix();
        UtilityList ul = new UtilityList(prefix, qName, 0);
        for (int i = lowerBound; i <= upperBound; ++i) {
            ul.addPrefixUtilityList(nowUL.get(qNameSplit[0] + "," + i));
        }
        nowUL.put(qName, ul);
        ++this.countUL;
    }

    private void combineMethod(ArrayList<String> candidateList, BufferedWriter writerHUQI, ArrayList<String> qItemNameList, ArrayList<String> hwQUI, HashMap<String, UtilityList> candidateHUL, HashMap<String, UtilityList> nextHUL) throws IOException {
        String info = this.preprocessCombine(candidateList);
        if (this.methodType.equals((Object)enumVHUQIMethod.MINC)) {
            this.combineMin(info, writerHUQI, qItemNameList, hwQUI, candidateHUL, nextHUL);
        } else if (this.methodType.equals((Object)enumVHUQIMethod.MAXC)) {
            this.combineMax(info, writerHUQI, qItemNameList, hwQUI, candidateHUL, nextHUL);
        } else {
            this.combineAll(info, writerHUQI, qItemNameList, hwQUI, candidateHUL, nextHUL);
        }
    }

    private void combineAll(String info, BufferedWriter writerHQUI, ArrayList<String> qItemNameList, ArrayList<String> hwQUI, HashMap<String, UtilityList> candidateHUL, HashMap<String, UtilityList> nextHUL) throws IOException {
        long usedMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
        if (this.maxMemory < usedMem) {
            this.maxMemory = usedMem;
        }
        while (info.length() != 0) {
            String[] mayHuqiSpilt = info.split(" ");
            if (info.length() < mayHuqiSpilt[0].length() + 1) break;
            info = info.substring(mayHuqiSpilt[0].length() + 1);
            this.combineAllProcess(mayHuqiSpilt[0], info, candidateHUL, qItemNameList, writerHQUI, hwQUI, nextHUL);
        }
    }

    private void combineAllProcess(String now, String nextList, HashMap<String, UtilityList> candidateHUL, ArrayList<String> qItemNameList, BufferedWriter writerHQUI, ArrayList<String> hwQUI, HashMap<String, UtilityList> nextHUL) throws IOException {
        long usedMem;
        now = (String)now.subSequence(1, now.length() - 1);
        String[] nowSplit = now.split(",");
        if (candidateHUL == null) {
            String[] nextListSplit;
            int nowUB = Integer.parseInt(nowSplit[2]);
            int count = 1;
            for (String nextName : nextListSplit = nextList.split(" ")) {
                try {
                    String[] nextNameSplit;
                    if (count >= this.relatedCoefficient || (nextNameSplit = (nextName = (String)nextName.subSequence(1, nextName.length() - 1)).split(",")).length < 2 || nowSplit[0].compareTo(nextNameSplit[0]) != 0 || nowUB + 1 != Integer.valueOf(nextNameSplit[1])) continue;
                    ++count;
                    String qItemName = "(" + nowSplit[0] + "," + nowSplit[1] + "," + ++nowUB + ")";
                    int us = this.utilityCal(qItemName, 0);
                    if (us < this.muv) continue;
                    writerHQUI.write("(" + qItemName.substring(1, qItemName.length() - 1) + ") #UTIL: " + us + "\r\n");
                    ++this.huqiCount;
                    hwQUI.add(qItemName.substring(1, qItemName.length() - 1));
                    this.buildUtilityListofCombine(qItemName.substring(1, qItemName.length() - 1), qItemNameList);
                }
                catch (Exception e) {
                    System.out.println("!" + nextName + "@");
                }
            }
        } else {
            String[] nextListSplit;
            int nowLB = Integer.parseInt(nowSplit[1]);
            int nowUB = Integer.parseInt(nowSplit[2]);
            int count = 1;
            int us = 0;
            UtilityList nowl = nowLB == nowUB ? candidateHUL.get(nowSplit[0] + "," + nowSplit[1]) : candidateHUL.get(now);
            us = nowl.getSumEU();
            for (String nextName : nextListSplit = nextList.split(" ")) {
                int nextUB;
                if (count >= this.relatedCoefficient) continue;
                String[] nextNameSplit = (nextName = (String)nextName.subSequence(1, nextName.length() - 1)).split(",");
                int nextLB = Integer.parseInt(nextNameSplit[1]);
                UtilityList nextl = nextLB == (nextUB = Integer.parseInt(nextNameSplit[2])) ? candidateHUL.get(nextNameSplit[0] + "," + nextNameSplit[1]) : candidateHUL.get(nextName);
                if (nowSplit[0].compareTo(nextNameSplit[0]) != 0 || nowUB + 1 != nextLB) continue;
                ++count;
                String qItemName = "(" + nowSplit[0] + "," + nowSplit[1] + "," + ++nowUB + ")";
                if ((us += nextl.getSumEU()) < this.muv) continue;
                writerHQUI.write(nowl.getPrefix() + " " + qItemName + " #UTIL: " + us + "\r\n");
                ++this.huqiCount;
                qItemName = qItemName.substring(1, qItemName.length() - 1);
                hwQUI.add(qItemName);
                String[] temp = qItemName.split(",");
                if (qItemNameList.contains(temp[0] + "," + temp[2])) {
                    int site = qItemNameList.indexOf(temp[0] + "," + temp[2]);
                    qItemNameList.add(site, qItemName);
                }
                this.buildUtilityListofcombine2(qItemName, nextHUL);
            }
        }
        if (this.maxMemory < (usedMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed())) {
            this.maxMemory = usedMem;
        }
    }

    private void combineMin(String info, BufferedWriter writerHUQI, ArrayList<String> qItemNameList, ArrayList<String> hwQUI, HashMap<String, UtilityList> candidateHUL, HashMap<String, UtilityList> nextHUL) throws IOException {
        ArrayList<String> huqiCandidate = new ArrayList<String>();
        ArrayList<String> huqiCandidateOutputInfo = new ArrayList<String>();
        while (info.length() != 0) {
            String[] mayHuqiSpilt = info.split(" ");
            if (info.length() < mayHuqiSpilt[0].length() + 1) break;
            info = info.substring(mayHuqiSpilt[0].length() + 1);
            this.combineMinProcess(mayHuqiSpilt[0], info, candidateHUL, huqiCandidate, huqiCandidateOutputInfo);
        }
        this.minChecking(huqiCandidate, huqiCandidateOutputInfo);
        this.writeHUCQI(candidateHUL, nextHUL, huqiCandidate, huqiCandidateOutputInfo, writerHUQI, qItemNameList, hwQUI);
        huqiCandidate.clear();
        huqiCandidateOutputInfo.clear();
    }

    private void combineMinProcess(String now, String nextList, HashMap<String, UtilityList> candidateHUL, ArrayList<String> huqiCandidate, ArrayList<String> huqiCandidateOutputInfo) {
        now = (String)now.subSequence(1, now.length() - 1);
        String[] nowSplit = now.split(",");
        if (candidateHUL == null) {
            String[] nextListSplit;
            int nowUB = Integer.parseInt(nowSplit[2]);
            int count = 1;
            for (String nextName : nextListSplit = nextList.split(" ")) {
                try {
                    int nextLB;
                    String[] nextNameSplit;
                    if (count >= this.relatedCoefficient || nowSplit[0].compareTo((nextNameSplit = (nextName = (String)nextName.subSequence(1, nextName.length() - 1)).split(","))[0]) != 0 || nextNameSplit.length < 2 || nowUB + 1 != (nextLB = Integer.parseInt(nextNameSplit[1]))) continue;
                    ++count;
                    String qItemName = "(" + nowSplit[0] + "," + nowSplit[1] + "," + ++nowUB + ")";
                    int us = this.utilityCal(qItemName, 0);
                    if (us < this.muv) continue;
                    huqiCandidateOutputInfo.add("(" + qItemName.substring(1, qItemName.length() - 1) + ") #UTIL: " + us);
                    huqiCandidate.add(qItemName.substring(1, qItemName.length() - 1));
                    break;
                }
                catch (Exception e) {
                    System.out.println("!" + nextName + "@");
                }
            }
        } else {
            String[] nextListSplit;
            int nowLB = Integer.parseInt(nowSplit[1]);
            int nowUB = Integer.parseInt(nowSplit[2]);
            int count = 1;
            int us = 0;
            UtilityList nowl = nowLB == nowUB ? candidateHUL.get(nowSplit[0] + "," + nowSplit[1]) : candidateHUL.get(now);
            us = nowl.getSumEU();
            for (String nextName : nextListSplit = nextList.split(" ")) {
                int nextUB;
                if (count >= this.relatedCoefficient) continue;
                String[] nextNameSplit = (nextName = (String)nextName.subSequence(1, nextName.length() - 1)).split(",");
                int nextLB = Integer.parseInt(nextNameSplit[1]);
                UtilityList nextl = nextLB == (nextUB = Integer.parseInt(nextNameSplit[2])) ? candidateHUL.get(nextNameSplit[0] + "," + nextNameSplit[1]) : candidateHUL.get(nextName);
                if (nowSplit[0].compareTo(nextNameSplit[0]) != 0 || nowUB + 1 != nextLB) continue;
                ++count;
                String qItemName = "(" + nowSplit[0] + "," + nowSplit[1] + "," + ++nowUB + ")";
                if ((us += nextl.getSumEU()) < this.muv) continue;
                huqiCandidateOutputInfo.add(nowl.getPrefix() + " (" + qItemName.substring(1, qItemName.length() - 1) + ") #UTIL: " + us);
                huqiCandidate.add(qItemName.substring(1, qItemName.length() - 1));
                break;
            }
        }
    }

    private void minChecking(ArrayList<String> huqiCandidate, ArrayList<String> huqiCandidateOutputInfo) {
        block0: for (int i = 0; i < huqiCandidate.size(); ++i) {
            String[] frontSplit = huqiCandidate.get(i).split(",");
            int frontLB = Integer.parseInt(frontSplit[1]);
            int frontUB = Integer.parseInt(frontSplit[2]);
            for (int j = 0; j < huqiCandidate.size(); ++j) {
                String[] tailSplit;
                if (j == i || frontSplit[0].compareTo((tailSplit = huqiCandidate.get(j).split(","))[0]) != 0) continue;
                int tailLB = Integer.parseInt(tailSplit[1]);
                int tailUB = Integer.parseInt(tailSplit[2]);
                if (frontLB > tailLB || frontUB < tailUB) continue;
                huqiCandidate.remove(i);
                huqiCandidateOutputInfo.remove(i);
                --i;
                continue block0;
            }
        }
    }

    private void combineMax(String info, BufferedWriter writerHUQI, ArrayList<String> qItemNameList, ArrayList<String> hwQUI, HashMap<String, UtilityList> candidateHUL, HashMap<String, UtilityList> nextHUL) throws IOException {
        ArrayList<String> huqiCandidate = new ArrayList<String>();
        ArrayList<String> huqiCandidateOutputInfo = new ArrayList<String>();
        String[] combineCandidate = info.split(" ");
        if (candidateHUL == null) {
            for (int i = 0; i < combineCandidate.length; ++i) {
                combineCandidate[i] = (String)combineCandidate[i].subSequence(1, combineCandidate[i].length() - 1);
                String[] frontQIemInfo = combineCandidate[i].split(",");
                int hqItemLB = Integer.parseInt(frontQIemInfo[1]);
                int hqItemUB = Integer.parseInt(frontQIemInfo[2]);
                int count = 1;
                int us = 0;
                for (int j = i + 1; j < combineCandidate.length; ++j) {
                    if (count >= this.relatedCoefficient) continue;
                    String nextQItem = (String)combineCandidate[j].subSequence(1, combineCandidate[j].length() - 1);
                    String[] nextQIemInfo = nextQItem.split(",");
                    if (frontQIemInfo[0].compareTo(nextQIemInfo[0]) != 0) break;
                    int nextUB = Integer.parseInt(nextQIemInfo[2]);
                    if (hqItemUB + 1 != nextUB) continue;
                    ++hqItemUB;
                    ++count;
                }
                if (count <= true) continue;
                String qItemName = "(" + frontQIemInfo[0] + "," + hqItemLB + "," + hqItemUB + ")";
                us = this.utilityCal(qItemName, 0);
                huqiCandidateOutputInfo.add("(" + qItemName.substring(1, qItemName.length() - 1) + ") #UTIL: " + us);
                huqiCandidate.add(qItemName.substring(1, qItemName.length() - 1));
            }
        } else {
            for (int i = 0; i < combineCandidate.length; ++i) {
                combineCandidate[i] = (String)combineCandidate[i].subSequence(1, combineCandidate[i].length() - 1);
                String[] frontQIemInfo = combineCandidate[i].split(",");
                int hqItemLB = Integer.parseInt(frontQIemInfo[1]);
                int hqItemUB = Integer.parseInt(frontQIemInfo[2]);
                int count = 1;
                int us = 0;
                UtilityList nowl = hqItemLB == hqItemUB ? candidateHUL.get(frontQIemInfo[0] + "," + frontQIemInfo[1]) : candidateHUL.get(combineCandidate[i]);
                us = nowl.getSumEU();
                for (int j = i + 1; j < combineCandidate.length; ++j) {
                    int nextUB;
                    if (count >= this.relatedCoefficient) continue;
                    String nextQItem = (String)combineCandidate[j].subSequence(1, combineCandidate[j].length() - 1);
                    String[] nextQIemInfo = nextQItem.split(",");
                    if (frontQIemInfo[0].compareTo(nextQIemInfo[0]) != 0) break;
                    int nextLB = Integer.parseInt(nextQIemInfo[1]);
                    UtilityList nextl = nextLB == (nextUB = Integer.parseInt(nextQIemInfo[2])) ? candidateHUL.get(nextQIemInfo[0] + "," + nextLB) : candidateHUL.get(combineCandidate[j]);
                    if (hqItemUB + 1 != nextUB) continue;
                    ++hqItemUB;
                    ++count;
                    us += nextl.getSumEU();
                }
                if (count <= true) continue;
                String qItemName = "(" + frontQIemInfo[0] + "," + hqItemLB + "," + hqItemUB + ")";
                huqiCandidateOutputInfo.add(nowl.getPrefix() + " (" + qItemName.substring(1, qItemName.length() - 1) + ") #UTIL: " + us);
                huqiCandidate.add(qItemName.substring(1, qItemName.length() - 1));
            }
        }
        this.maxChecking(huqiCandidate, huqiCandidateOutputInfo);
        this.writeHUCQI(candidateHUL, nextHUL, huqiCandidate, huqiCandidateOutputInfo, writerHUQI, qItemNameList, hwQUI);
        huqiCandidate.clear();
        huqiCandidateOutputInfo.clear();
    }

    private void maxChecking(ArrayList<String> huqiCandidate, ArrayList<String> huqiCandidateOutputInfo) {
        block0: for (int i = 0; i < huqiCandidate.size(); ++i) {
            String[] frontSplit = huqiCandidate.get(i).split(",");
            int frontLB = Integer.parseInt(frontSplit[1]);
            int frontUB = Integer.parseInt(frontSplit[2]);
            for (int j = 0; j < huqiCandidate.size(); ++j) {
                String[] tailSplit;
                if (j == i || frontSplit[0].compareTo((tailSplit = huqiCandidate.get(j).split(","))[0]) != 0) continue;
                int tailLB = Integer.parseInt(tailSplit[1]);
                int tailUB = Integer.parseInt(tailSplit[2]);
                if (frontLB < tailLB || frontUB > tailUB) continue;
                huqiCandidate.remove(i);
                huqiCandidateOutputInfo.remove(i);
                --i;
                continue block0;
            }
        }
    }

    private void writeHUCQI(HashMap<String, UtilityList> candidateHUL, HashMap<String, UtilityList> nextHUL, ArrayList<String> huqiCandidate, ArrayList<String> huqiCandidateOutputInfo, BufferedWriter writerHUQI, ArrayList<String> qItemNameList, ArrayList<String> hwQUI) throws IOException {
        for (int i = 0; i < huqiCandidateOutputInfo.size(); ++i) {
            writerHUQI.write(huqiCandidateOutputInfo.get(i) + "\r\n");
            ++this.huqiCount;
            hwQUI.add(huqiCandidate.get(i));
            if (candidateHUL == null) {
                this.buildUtilityListofCombine(huqiCandidate.get(i), qItemNameList);
                continue;
            }
            String[] temp = huqiCandidate.get(i).split(",");
            if (qItemNameList.contains(temp[0] + "," + temp[2])) {
                int site = qItemNameList.indexOf(temp[0] + "," + temp[2]);
                qItemNameList.add(site, huqiCandidate.get(i));
            }
            this.buildUtilityListofcombine2(huqiCandidate.get(i), nextHUL);
        }
    }

    public void printStatistics() {
        System.out.println("=============  VHUQI 2.37 - STATS =============");
        System.out.println(" Total exection time : " + (double)(this.endTime - this.startTime) / 1000.0 + " s");
        System.out.println(" Maximum memory : " + this.decimalFormat.format((long)(1.0 * (double)this.maxMemory / 1024.0) / 1024L) + " MB");
        System.out.println(" Number of high utility quantitative patterns : " + this.huqiCount);
        System.out.println("==========================================");
    }
}

