/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.vhuqi;

import ca.pfv.spmf.algorithms.frequentpatterns.vhuqi.QItemTrans;
import java.util.ArrayList;

class UtilityList {
    private String prefix;
    private String itemName;
    private int sumEU;
    private int sumRU;
    private int maxEURU;
    private int twu;
    private ArrayList<QItemTrans> qItemTrans = null;

    UtilityList(String prefix, String name, int twu) {
        this.prefix = prefix;
        this.itemName = name;
        this.sumEU = 0;
        this.sumRU = 0;
        this.maxEURU = 0;
        this.twu = twu;
        this.qItemTrans = new ArrayList();
    }

    void addTWU(int twu) {
        this.twu += twu;
    }

    void setTWU() {
        this.twu = 0;
    }

    void addTrans(QItemTrans qTid, int twu) {
        this.sumEU += qTid.getEu();
        this.sumRU += qTid.getRu();
        this.qItemTrans.add(qTid);
        this.maxEURU(qTid.getEu(), qTid.getRu());
        this.twu += twu;
    }

    void addTrans(QItemTrans qTid) {
        this.sumEU += qTid.getEu();
        this.sumRU += qTid.getRu();
        this.qItemTrans.add(qTid);
        this.maxEURU(qTid.getEu(), qTid.getRu());
    }

    void maxEURU(int eu, int ru) {
        if (this.maxEURU < eu + ru) {
            this.maxEURU = eu + ru;
        }
    }

    int getMaxEURU() {
        return this.maxEURU;
    }

    int getSumEU() {
        return this.sumEU;
    }

    int getSumRU() {
        return this.sumRU;
    }

    int getTwu() {
        return this.twu;
    }

    String getName() {
        return this.itemName;
    }

    String getFullName() {
        return this.prefix + " " + this.itemName;
    }

    String getPrefix() {
        return this.prefix;
    }

    ArrayList<QItemTrans> getQItemTrans() {
        return this.qItemTrans;
    }

    void addNoPrefixUtilityList(UtilityList next) {
        this.sumEU += next.getSumEU();
        this.sumRU += next.getSumRU();
        this.twu += next.getTwu();
        if (next.getMaxEURU() > this.maxEURU) {
            this.maxEURU = next.getMaxEURU();
        }
    }

    void addNoPrefixUtilityListQItemTrans(UtilityList next) {
        ArrayList<QItemTrans> temp = next.getQItemTrans();
        ArrayList<QItemTrans> mainlist = new ArrayList<QItemTrans>();
        if (this.qItemTrans.size() == 0) {
            for (int k = 0; k < temp.size(); ++k) {
                this.qItemTrans.add(temp.get(k));
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < this.qItemTrans.size() && j < temp.size()) {
                int t2;
                int t1 = this.qItemTrans.get(i).getTid();
                if (t1 > (t2 = temp.get(j).getTid())) {
                    mainlist.add(temp.get(j));
                    ++j;
                    continue;
                }
                mainlist.add(this.qItemTrans.get(i));
                ++i;
            }
            if (i == this.qItemTrans.size()) {
                while (j < temp.size()) {
                    mainlist.add(temp.get(j++));
                }
            } else if (j == temp.size()) {
                while (i < this.qItemTrans.size()) {
                    mainlist.add(this.qItemTrans.get(i++));
                }
            }
            this.qItemTrans.clear();
            this.qItemTrans = mainlist;
        }
    }

    void addPrefixUtilityList(UtilityList next) {
        ArrayList<QItemTrans> temp = next.getQItemTrans();
        ArrayList<QItemTrans> mainlist = new ArrayList<QItemTrans>();
        this.sumEU += next.getSumEU();
        this.sumRU += next.getSumRU();
        this.twu += next.getTwu();
        if (next.getMaxEURU() > this.maxEURU) {
            this.maxEURU = next.getMaxEURU();
        }
        if (this.qItemTrans.size() == 0) {
            for (int k = 0; k < temp.size(); ++k) {
                this.qItemTrans.add(temp.get(k));
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < this.qItemTrans.size() && j < temp.size()) {
                int t2;
                int t1 = this.qItemTrans.get(i).getTid();
                if (t1 > (t2 = temp.get(j).getTid())) {
                    mainlist.add(temp.get(j));
                    ++j;
                    continue;
                }
                mainlist.add(this.qItemTrans.get(i));
                ++i;
            }
            if (i == this.qItemTrans.size()) {
                while (j < temp.size()) {
                    mainlist.add(temp.get(j++));
                }
            } else if (j == temp.size()) {
                while (i < this.qItemTrans.size()) {
                    mainlist.add(this.qItemTrans.get(i++));
                }
            }
            this.qItemTrans.clear();
            this.qItemTrans = mainlist;
        }
    }

    public String toString() {
        String str = this.prefix + " " + this.itemName + "\r\n";
        str = str + "sumEU=" + this.sumEU + " sumRU=" + this.sumRU + " maxEURU=" + this.maxEURU + " twu=" + this.twu + "\r\n";
        for (int i = 0; i < this.qItemTrans.size(); ++i) {
            str = str + this.qItemTrans.get(i).toString() + "\r\n";
        }
        return str;
    }

    int getqItemTransLength() {
        if (this.qItemTrans == null) {
            return 0;
        }
        return this.qItemTrans.size();
    }
}

