/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tkg;

import ca.pfv.spmf.algorithms.graph_mining.tkg.DFSCode;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Edge;
import ca.pfv.spmf.algorithms.graph_mining.tkg.ExtendedEdge;
import ca.pfv.spmf.algorithms.graph_mining.tkg.FrequentSubgraph;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Graph;
import ca.pfv.spmf.algorithms.graph_mining.tkg.SparseTriangularMatrix;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Vertex;
import ca.pfv.spmf.algorithms.graph_mining.tkg.VizGraph;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoGSPAN {
    private int minSup;
    private List<FrequentSubgraph> frequentSubgraphs;
    private long runtime = 0L;
    private double maxmemory = 0.0;
    private int patternCount = 0;
    private int graphCount = 0;
    List<Integer> frequentVertexLabels;
    private static final boolean DEBUG_MODE = false;
    private static final boolean ELIMINATE_INFREQUENT_VERTICES = true;
    private static final boolean ELIMINATE_INFREQUENT_VERTEX_PAIRS = true;
    private static final boolean ELIMINATE_INFREQUENT_EDGE_LABELS = true;
    private static final boolean EDGE_COUNT_PRUNING = true;
    private static final boolean SKIP_STRATEGY = true;
    int infrequentVertexPairsRemoved;
    int infrequentVerticesRemovedCount;
    int edgeRemovedByLabel;
    int eliminatedWithMaxSize;
    int emptyGraphsRemoved;
    int pruneByEdgeCountCount;
    int skipStrategyCount;
    int maxNumberOfEdges = Integer.MAX_VALUE;
    boolean outputGraphIds = true;

    public void runAlgorithm(String inPath, String outPath, double minSupport, boolean outputSingleVertices, boolean outputDotFile, int maxNumberOfEdges, boolean outputGraphIds) throws IOException, ClassNotFoundException {
        if (maxNumberOfEdges <= 0) {
            return;
        }
        double minFrequency = minSupport;
        this.maxNumberOfEdges = maxNumberOfEdges;
        this.outputGraphIds = outputGraphIds;
        this.infrequentVertexPairsRemoved = 0;
        this.infrequentVerticesRemovedCount = 0;
        this.edgeRemovedByLabel = 0;
        this.eliminatedWithMaxSize = 0;
        this.emptyGraphsRemoved = 0;
        this.pruneByEdgeCountCount = 0;
        this.frequentSubgraphs = new ArrayList<FrequentSubgraph>();
        MemoryLogger.getInstance().reset();
        this.patternCount = 0;
        Long t1 = System.currentTimeMillis();
        List<Graph> graphDB = this.readGraphs(inPath);
        this.minSup = (int)Math.ceil(minFrequency * (double)graphDB.size());
        this.gSpan(graphDB, outputSingleVertices);
        MemoryLogger.getInstance().checkMemory();
        this.writeResultToFile(outPath);
        Long t2 = System.currentTimeMillis();
        this.runtime = (t2 - t1) / 1000L;
        this.maxmemory = MemoryLogger.getInstance().getMaxMemory();
        this.patternCount = this.frequentSubgraphs.size();
        if (outputDotFile) {
            AlgoGSPAN.outputDotFile(outPath);
        }
    }

    private static void outputDotFile(String outputPath) throws IOException {
        String dirName = outputPath + "_dotfile";
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdir();
        }
        VizGraph.visulizeFromFile(outputPath, dirName);
    }

    private void writeResultToFile(String outputPath) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(outputPath)));
        int i = 0;
        for (FrequentSubgraph subgraph : this.frequentSubgraphs) {
            StringBuilder sb = new StringBuilder();
            DFSCode dfsCode = subgraph.dfsCode;
            sb.append("t # ").append(i).append(" * ").append(subgraph.support).append(System.lineSeparator());
            if (dfsCode.size() == 1) {
                ExtendedEdge ee = dfsCode.getEeL().get(0);
                if (ee.getEdgeLabel() == -1) {
                    sb.append("v 0 ").append(ee.getvLabel1()).append(System.lineSeparator());
                } else {
                    sb.append("v 0 ").append(ee.getvLabel1()).append(System.lineSeparator());
                    sb.append("v 1 ").append(ee.getvLabel2()).append(System.lineSeparator());
                    sb.append("e 0 1 ").append(ee.getEdgeLabel()).append(System.lineSeparator());
                }
            } else {
                List<Integer> vLabels = dfsCode.getAllVLabels();
                for (int j = 0; j < vLabels.size(); ++j) {
                    sb.append("v ").append(j).append(" ").append(vLabels.get(j)).append(System.lineSeparator());
                }
                for (ExtendedEdge ee : dfsCode.getEeL()) {
                    int startV = ee.getV1();
                    int endV = ee.getV2();
                    int eL = ee.edgeLabel;
                    sb.append("e ").append(startV).append(" ").append(endV).append(" ").append(eL).append(System.lineSeparator());
                }
            }
            if (this.outputGraphIds) {
                sb.append("x");
                for (int id : subgraph.setOfGraphsIDs) {
                    sb.append(" ").append(id);
                }
            }
            sb.append(System.lineSeparator()).append(System.lineSeparator());
            bw.write(sb.toString());
            ++i;
        }
        bw.close();
    }

    private List<Graph> readGraphs(String path) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(new File(path)));
        ArrayList<Graph> graphDatabase = new ArrayList<Graph>();
        String line = br.readLine();
        Boolean hasNextGraph = line != null && line.startsWith("t");
        while (hasNextGraph.booleanValue()) {
            hasNextGraph = false;
            int gId = Integer.parseInt(line.split(" ")[2]);
            HashMap<Integer, Vertex> vMap = new HashMap<Integer, Vertex>();
            while ((line = br.readLine()) != null && !line.startsWith("t")) {
                String[] items = line.split(" ");
                if (line.startsWith("v")) {
                    int vId = Integer.parseInt(items[1]);
                    int vLabel = Integer.parseInt(items[2]);
                    vMap.put(vId, new Vertex(vId, vLabel));
                    continue;
                }
                if (!line.startsWith("e")) continue;
                int v1 = Integer.parseInt(items[1]);
                int v2 = Integer.parseInt(items[2]);
                int eLabel = Integer.parseInt(items[3]);
                Edge e = new Edge(v1, v2, eLabel);
                ((Vertex)vMap.get(v1)).addEdge(e);
                ((Vertex)vMap.get(v2)).addEdge(e);
            }
            graphDatabase.add(new Graph(gId, vMap));
            if (line == null) continue;
            hasNextGraph = true;
        }
        br.close();
        this.graphCount = graphDatabase.size();
        return graphDatabase;
    }

    private List<Map<Integer, Integer>> subgraphIsomorphisms(DFSCode c, Graph g) {
        ArrayList<Map<Integer, Integer>> isoms = new ArrayList<Map<Integer, Integer>>();
        int startLabel = c.getEeL().get(0).getvLabel1();
        for (int vID : g.findAllWithLabel(startLabel)) {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            map.put(0, vID);
            isoms.add(map);
        }
        Object object = c.getEeL().iterator();
        while (object.hasNext()) {
            ExtendedEdge ee = (ExtendedEdge)object.next();
            int v1 = ee.getV1();
            int v2 = ee.getV2();
            int v2Label = ee.getvLabel2();
            int eLabel = ee.getEdgeLabel();
            ArrayList<Map> updateIsoms = new ArrayList<Map>();
            for (Map map : isoms) {
                int mappedV1 = (Integer)map.get(v1);
                if (v1 < v2) {
                    Collection mappedVertices = map.values();
                    for (Vertex mappedV2 : g.getAllNeighbors(mappedV1)) {
                        if (v2Label != mappedV2.getLabel() || mappedVertices.contains(mappedV2.getId()) || eLabel != g.getEdgeLabel(mappedV1, mappedV2.getId())) continue;
                        HashMap<Integer, Integer> tempM = new HashMap<Integer, Integer>(map.size() + 1);
                        tempM.putAll(map);
                        tempM.put(v2, mappedV2.getId());
                        updateIsoms.add(tempM);
                    }
                    continue;
                }
                int mappedV2 = (Integer)map.get(v2);
                if (!g.isNeighboring(mappedV1, mappedV2) || eLabel != g.getEdgeLabel(mappedV1, mappedV2)) continue;
                updateIsoms.add(map);
            }
            isoms = updateIsoms;
        }
        return isoms;
    }

    private Map<ExtendedEdge, Set<Integer>> rightMostPathExtensionsFromSingle(DFSCode c, Graph g) {
        int gid = g.getId();
        HashMap<ExtendedEdge, Set<Integer>> extensions = new HashMap<ExtendedEdge, Set<Integer>>();
        if (c.isEmpty()) {
            for (Vertex vertex : g.vertices) {
                for (Edge e : vertex.getEdgeList()) {
                    int v2L;
                    int v1L = g.getVLabel(e.v1);
                    ExtendedEdge ee1 = v1L < (v2L = g.getVLabel(e.v2)) ? new ExtendedEdge(0, 1, v1L, v2L, e.getEdgeLabel()) : new ExtendedEdge(0, 1, v2L, v1L, e.getEdgeLabel());
                    HashSet<Integer> setOfGraphIDs = (HashSet<Integer>)extensions.get(ee1);
                    if (setOfGraphIDs == null) {
                        setOfGraphIDs = new HashSet<Integer>();
                        extensions.put(ee1, setOfGraphIDs);
                    }
                    setOfGraphIDs.add(gid);
                }
            }
        } else {
            int rightMost = c.getRightMost();
            List<Map<Integer, Integer>> isoms = this.subgraphIsomorphisms(c, g);
            for (Map<Integer, Integer> isom : isoms) {
                HashMap<Integer, Integer> invertedISOM = new HashMap<Integer, Integer>();
                for (Map.Entry<Integer, Integer> entry : isom.entrySet()) {
                    invertedISOM.put(entry.getValue(), entry.getKey());
                }
                int mappedRM = isom.get(rightMost);
                int mappedRMlabel = g.getVLabel(mappedRM);
                for (Vertex x : g.getAllNeighbors(mappedRM)) {
                    Integer invertedX = (Integer)invertedISOM.get(x.getId());
                    if (invertedX == null || !c.onRightMostPath(invertedX) || !c.notPreOfRM(invertedX) || c.containEdge(rightMost, invertedX)) continue;
                    ExtendedEdge ee = new ExtendedEdge(rightMost, invertedX, mappedRMlabel, x.getLabel(), g.getEdgeLabel(mappedRM, x.getId()));
                    if (extensions.get(ee) == null) {
                        extensions.put(ee, new HashSet());
                    }
                    ((Set)extensions.get(ee)).add(g.getId());
                }
                Collection<Integer> mappedVertices = isom.values();
                for (int v : c.getRightMostPath()) {
                    int mappedV = isom.get(v);
                    int mappedVlabel = g.getVLabel(mappedV);
                    for (Vertex x : g.getAllNeighbors(mappedV)) {
                        if (mappedVertices.contains(x.getId())) continue;
                        ExtendedEdge ee = new ExtendedEdge(v, rightMost + 1, mappedVlabel, x.getLabel(), g.getEdgeLabel(mappedV, x.getId()));
                        if (extensions.get(ee) == null) {
                            extensions.put(ee, new HashSet());
                        }
                        ((Set)extensions.get(ee)).add(g.getId());
                    }
                }
            }
        }
        return extensions;
    }

    private Map<ExtendedEdge, Set<Integer>> rightMostPathExtensions(DFSCode c, List<Graph> graphDatabase, Set<Integer> graphIds) {
        HashMap<ExtendedEdge, Set<Integer>> extensions = new HashMap<ExtendedEdge, Set<Integer>>();
        if (c.isEmpty()) {
            for (Integer graphId : graphIds) {
                Graph g = graphDatabase.get(graphId);
                if (c.size() >= g.getEdgeCount()) {
                    ++this.pruneByEdgeCountCount;
                    continue;
                }
                for (Vertex vertex : g.vertices) {
                    for (Edge e : vertex.getEdgeList()) {
                        int v2L;
                        int v1L = g.getVLabel(e.v1);
                        ExtendedEdge ee1 = v1L < (v2L = g.getVLabel(e.v2)) ? new ExtendedEdge(0, 1, v1L, v2L, e.getEdgeLabel()) : new ExtendedEdge(0, 1, v2L, v1L, e.getEdgeLabel());
                        HashSet<Integer> setOfGraphIDs = (HashSet<Integer>)extensions.get(ee1);
                        if (setOfGraphIDs == null) {
                            setOfGraphIDs = new HashSet<Integer>();
                            extensions.put(ee1, setOfGraphIDs);
                        }
                        setOfGraphIDs.add(graphId);
                    }
                }
            }
        } else {
            int remaininggraphCount = graphIds.size();
            int highestSupport = 0;
            int rightMost = c.getRightMost();
            for (Integer graphId : graphIds) {
                Graph g = graphDatabase.get(graphId);
                if (c.size() >= g.getEdgeCount()) {
                    ++this.pruneByEdgeCountCount;
                    continue;
                }
                List<Map<Integer, Integer>> isoms = this.subgraphIsomorphisms(c, g);
                for (Map<Integer, Integer> isom : isoms) {
                    HashMap<Integer, Integer> invertedISOM = new HashMap<Integer, Integer>();
                    for (Map.Entry<Integer, Integer> entry : isom.entrySet()) {
                        invertedISOM.put(entry.getValue(), entry.getKey());
                    }
                    int mappedRM = isom.get(rightMost);
                    int mappedRMlabel = g.getVLabel(mappedRM);
                    for (Vertex x : g.getAllNeighbors(mappedRM)) {
                        Integer invertedX = (Integer)invertedISOM.get(x.getId());
                        if (invertedX == null || !c.onRightMostPath(invertedX) || !c.notPreOfRM(invertedX) || c.containEdge(rightMost, invertedX)) continue;
                        ExtendedEdge ee = new ExtendedEdge(rightMost, invertedX, mappedRMlabel, x.getLabel(), g.getEdgeLabel(mappedRM, x.getId()));
                        if (extensions.get(ee) == null) {
                            extensions.put(ee, new HashSet());
                        }
                        ((Set)extensions.get(ee)).add(g.getId());
                    }
                    Collection<Integer> mappedVertices = isom.values();
                    for (int v : c.getRightMostPath()) {
                        int mappedV = isom.get(v);
                        int mappedVlabel = g.getVLabel(mappedV);
                        for (Vertex x : g.getAllNeighbors(mappedV)) {
                            if (mappedVertices.contains(x.getId())) continue;
                            ExtendedEdge ee = new ExtendedEdge(v, rightMost + 1, mappedVlabel, x.getLabel(), g.getEdgeLabel(mappedV, x.getId()));
                            if (extensions.get(ee) == null) {
                                extensions.put(ee, new HashSet());
                            }
                            Set setOfGraphIDs = (Set)extensions.get(ee);
                            setOfGraphIDs.add(g.getId());
                            if (setOfGraphIDs.size() <= highestSupport) continue;
                            highestSupport = setOfGraphIDs.size();
                        }
                    }
                }
                if (highestSupport + remaininggraphCount < this.minSup) {
                    ++this.skipStrategyCount;
                    extensions = null;
                    break;
                }
                --remaininggraphCount;
            }
        }
        return extensions;
    }

    private void gSpan(List<Graph> graphDB, boolean outputFrequentVertices) throws IOException, ClassNotFoundException {
        if (!outputFrequentVertices) {
            // empty if block
        }
        this.findAllOnlyOneVertex(graphDB, outputFrequentVertices);
        for (Graph g : graphDB) {
            g.precalculateVertexList();
        }
        this.removeInfrequentVertexPairs(graphDB);
        HashSet<Integer> graphIds = new HashSet<Integer>();
        for (int i = 0; i < graphDB.size(); ++i) {
            Graph g = graphDB.get(i);
            if (g.vertices == null || g.vertices.length != 0) {
                if (this.infrequentVerticesRemovedCount > 0) {
                    g.precalculateVertexList();
                }
                graphIds.add(i);
                g.precalculateVertexNeighbors();
                g.precalculateLabelsToVertices();
                continue;
            }
            ++this.emptyGraphsRemoved;
        }
        if (this.frequentVertexLabels.size() != 0) {
            this.gSpanDFS(new DFSCode(), graphDB, graphIds);
        }
    }

    private void removeInfrequentVertexPairs(List<Graph> graphDB) {
        int labelV2;
        int v2;
        int labelV1;
        Vertex v1;
        int i;
        Vertex[] vertices;
        SparseTriangularMatrix matrix = new SparseTriangularMatrix();
        HashSet<Pair> alreadySeenPair = new HashSet<Pair>();
        HashMap<Integer, Integer> mapEdgeLabelToSupport = new HashMap<Integer, Integer>();
        HashSet<Integer> alreadySeenEdgeLabel = new HashSet<Integer>();
        for (Graph g : graphDB) {
            vertices = g.getAllVertices();
            for (i = 0; i < vertices.length; ++i) {
                v1 = vertices[i];
                labelV1 = v1.getLabel();
                for (Edge edge : v1.getEdgeList()) {
                    int edgeLabel;
                    v2 = edge.another(v1.getId());
                    labelV2 = g.getVLabel(v2);
                    Pair pair = new Pair(labelV1, labelV2);
                    boolean seen = alreadySeenPair.contains(pair);
                    if (!seen) {
                        matrix.incrementCount(labelV1, labelV2);
                        alreadySeenPair.add(pair);
                    }
                    if (alreadySeenEdgeLabel.contains(edgeLabel = edge.getEdgeLabel())) continue;
                    alreadySeenEdgeLabel.add(edgeLabel);
                    Integer edgeSupport = (Integer)mapEdgeLabelToSupport.get(edgeLabel);
                    if (edgeSupport == null) {
                        mapEdgeLabelToSupport.put(edgeLabel, 1);
                        continue;
                    }
                    mapEdgeLabelToSupport.put(edgeLabel, edgeSupport + 1);
                }
            }
            alreadySeenPair.clear();
            alreadySeenEdgeLabel.clear();
        }
        alreadySeenPair = null;
        matrix.removeInfrequentEntriesFromMatrix(this.minSup);
        for (Graph g : graphDB) {
            vertices = g.getAllVertices();
            for (i = 0; i < vertices.length; ++i) {
                v1 = vertices[i];
                labelV1 = v1.getLabel();
                Iterator<Edge> iter = v1.getEdgeList().iterator();
                while (iter.hasNext()) {
                    Edge edge;
                    edge = iter.next();
                    v2 = edge.another(v1.getId());
                    labelV2 = g.getVLabel(v2);
                    int count = matrix.getSupportForItems(labelV1, labelV2);
                    if (count < this.minSup) {
                        iter.remove();
                        ++this.infrequentVertexPairsRemoved;
                        continue;
                    }
                    if ((Integer)mapEdgeLabelToSupport.get(edge.getEdgeLabel()) >= this.minSup) continue;
                    iter.remove();
                    ++this.edgeRemovedByLabel;
                }
            }
        }
    }

    private void gSpanDFS(DFSCode c, List<Graph> graphDB, Set<Integer> graphIds) throws IOException, ClassNotFoundException {
        if (c.size() == this.maxNumberOfEdges - 1) {
            return;
        }
        Map<ExtendedEdge, Set<Integer>> extensions = this.rightMostPathExtensions(c, graphDB, graphIds);
        if (extensions != null) {
            for (Map.Entry<ExtendedEdge, Set<Integer>> entry : extensions.entrySet()) {
                Set<Integer> newGraphIDs = entry.getValue();
                int sup = newGraphIDs.size();
                if (sup < this.minSup) continue;
                DFSCode newC = c.copy();
                ExtendedEdge extension = entry.getKey();
                newC.add(extension);
                if (!this.isCanonical(newC)) continue;
                FrequentSubgraph subgraph = new FrequentSubgraph(newC, newGraphIDs, sup);
                this.frequentSubgraphs.add(subgraph);
                this.gSpanDFS(newC, graphDB, newGraphIDs);
            }
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private boolean isCanonical(DFSCode c) {
        DFSCode canC = new DFSCode();
        for (int i = 0; i < c.size(); ++i) {
            Map<ExtendedEdge, Set<Integer>> extensions = this.rightMostPathExtensionsFromSingle(canC, new Graph(c));
            ExtendedEdge minEE = null;
            for (ExtendedEdge ee : extensions.keySet()) {
                if (!ee.smallerThan(minEE)) continue;
                minEE = ee;
            }
            if (minEE.smallerThan(c.getAt(i))) {
                return false;
            }
            canC.add(minEE);
        }
        return true;
    }

    private void findAllOnlyOneVertex(List<Graph> graphDB, boolean outputFrequentVertices) {
        this.frequentVertexLabels = new ArrayList<Integer>();
        HashMap<Integer, HashSet<Integer>> labelM = new HashMap<Integer, HashSet<Integer>>();
        for (Graph graph : graphDB) {
            for (Vertex v : graph.getNonPrecalculatedAllVertices()) {
                if (v.getEdgeList().isEmpty()) continue;
                Integer vLabel = v.getLabel();
                HashSet<Integer> set = (HashSet<Integer>)labelM.get(vLabel);
                if (set == null) {
                    set = new HashSet<Integer>();
                    labelM.put(vLabel, set);
                }
                set.add(graph.getId());
            }
        }
        for (Map.Entry entry : labelM.entrySet()) {
            int label = (Integer)entry.getKey();
            Set tempSupG = (Set)entry.getValue();
            int sup = tempSupG.size();
            if (sup >= this.minSup) {
                this.frequentVertexLabels.add(label);
                if (!outputFrequentVertices) continue;
                DFSCode tempD = new DFSCode();
                tempD.add(new ExtendedEdge(0, 0, label, label, -1));
                this.frequentSubgraphs.add(new FrequentSubgraph(tempD, tempSupG, sup));
                continue;
            }
            for (Integer graphid : tempSupG) {
                Graph g = graphDB.get(graphid);
                g.removeInfrequentLabel(label);
                ++this.infrequentVerticesRemovedCount;
            }
        }
    }

    public void printStats() {
        System.out.println("=============  GSPAN v2.40 - STATS =============");
        System.out.println(" Number of graph in the input database: " + this.graphCount);
        System.out.println(" Frequent subgraph count : " + this.patternCount);
        System.out.println(" Total time ~ " + this.runtime + " s");
        System.out.println(" Minsup : " + this.minSup + " graphs");
        System.out.println(" Maximum memory usage : " + this.maxmemory + " mb");
        System.out.println("===================================================");
    }

    class Pair {
        int x;
        int y;

        Pair(int x, int y) {
            if (x < y) {
                this.x = x;
                this.y = y;
            } else {
                this.x = y;
                this.y = x;
            }
        }

        public boolean equals(Object obj) {
            Pair other = (Pair)obj;
            return other.x == this.x && other.y == this.y;
        }

        public int hashCode() {
            return this.x + 100 * this.y;
        }
    }
}

