/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tkg;

import ca.pfv.spmf.algorithms.graph_mining.tkg.ExtendedEdge;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class DFSCode
implements Serializable {
    private static final long serialVersionUID = -3332379071310578036L;
    private int rightMost = -1;
    private Stack<Integer> rightMostPath = new Stack();
    private List<ExtendedEdge> eeL = new LinkedList<ExtendedEdge>();
    private int size = 0;

    public DFSCode copy() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        DFSCode clonedObj = (DFSCode)ois.readObject();
        ois.close();
        return clonedObj;
    }

    public boolean notPreOfRM(int v) {
        if (this.rightMostPath.size() <= 1) {
            return true;
        }
        return v != (Integer)this.rightMostPath.elementAt(this.rightMostPath.size() - 2);
    }

    public List<Integer> getAllVLabels() {
        ArrayList<Integer> labels = new ArrayList<Integer>();
        LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
        for (ExtendedEdge ee : this.eeL) {
            int v1 = ee.getV1();
            int v1L = ee.getvLabel1();
            int v2 = ee.getV2();
            int v2L = ee.getvLabel2();
            map.put(v1, v1L);
            map.put(v2, v2L);
        }
        int count = 0;
        Set vSet = map.keySet();
        while (vSet.contains(count)) {
            labels.add((Integer)map.get(count));
            ++count;
        }
        return labels;
    }

    public void add(ExtendedEdge ee) {
        if (this.size == 0) {
            this.rightMost = 1;
            this.rightMostPath.push(0);
            this.rightMostPath.push(1);
        } else {
            int v2;
            int v1 = ee.getV1();
            if (v1 < (v2 = ee.getV2())) {
                this.rightMost = v2;
                while (!this.rightMostPath.isEmpty() && this.rightMostPath.peek() > v1) {
                    this.rightMostPath.pop();
                }
                this.rightMostPath.push(v2);
            }
        }
        this.eeL.add(ee);
        ++this.size;
    }

    public ExtendedEdge getAt(int i) {
        return this.eeL.get(i);
    }

    public boolean onRightMostPath(int v) {
        return this.rightMostPath.contains(v);
    }

    public boolean containEdge(int v1, int v2) {
        for (ExtendedEdge ee : this.eeL) {
            int eeV1 = ee.getV1();
            int eeV2 = ee.getV2();
            if ((eeV1 != v1 || eeV2 != v2) && (eeV1 != v2 || eeV2 != v1)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.eeL.isEmpty();
    }

    public int getRightMost() {
        return this.rightMost;
    }

    public Iterable<Integer> getRightMostPath() {
        return this.rightMostPath;
    }

    public List<ExtendedEdge> getEeL() {
        return this.eeL;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DFSCode: ");
        for (ExtendedEdge ee : this.eeL) {
            sb.append(ee).append(" ");
        }
        return sb.toString();
    }
}

