/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tseqminer;

import ca.pfv.spmf.algorithms.graph_mining.tseqminer.AttributedGraph;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.ItemAttributedGraph;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.ItemVertex;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.ParametersSetting;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.ReadGraph;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Preprocess {
    private static String[] trends = new String[]{"-", "=", "+"};
    static Map<Integer, String> attrMapping;
    static Map<Integer, String> eventTypeMapping;
    static Map<String, Integer> eventTypeMappingRe;
    static Map<Integer, ItemAttributedGraph> itDyAG;
    static double INCRE_THRESHOLD;
    private static String ATTRI_MAPPING_PATH;
    private static int DISCRET_FLAG;
    private static int PASS_FLAG;
    private static String EVENTTYPE_MAPPING_PATH;
    private static Map<Integer, Map<Integer, List<Double>>> vertexMapAttrMapVals;

    private static void repeatGraph(Map<Integer, ItemAttributedGraph> tempItemDyAG) {
        int repeatNum = ParametersSetting.REPEAT;
        int oriSize = tempItemDyAG.size();
        for (int timeStamp = 0; timeStamp < oriSize; ++timeStamp) {
            ItemAttributedGraph itemAG = tempItemDyAG.get(timeStamp);
            for (int i = 1; i < repeatNum; ++i) {
                tempItemDyAG.put(oriSize * i + timeStamp, itemAG);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        Preprocess.findEventTypeMapping();
        Preprocess.writeEventTypeMapping();
    }

    public static Map<Integer, String> readAttrMapping() throws IOException {
        LinkedHashMap<Integer, String> attrMap = new LinkedHashMap<Integer, String>();
        File attrMapFile = new File(ATTRI_MAPPING_PATH);
        if (!attrMapFile.exists()) {
            attrMapFile.createNewFile();
        }
        BufferedReader br = new BufferedReader(new FileReader(ATTRI_MAPPING_PATH));
        int count = 1;
        String line = br.readLine();
        while (line != null) {
            attrMap.put(count++, line);
            line = br.readLine();
        }
        return attrMap;
    }

    private static void findEventTypeMapping() throws IOException {
        attrMapping = Preprocess.readAttrMapping();
        int count = 1;
        for (int attrType : attrMapping.keySet()) {
            String attrName = attrMapping.get(attrType);
            for (String trend : trends) {
                String eventName = attrName + trend;
                eventTypeMapping.put(count, eventName);
                eventTypeMappingRe.put(eventName, count);
                ++count;
            }
        }
    }

    public static void writeEventTypeMapping() throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(EVENTTYPE_MAPPING_PATH));
        for (int eventType : eventTypeMapping.keySet()) {
            bw.write(eventTypeMapping.get(eventType));
            bw.newLine();
        }
        bw.close();
    }

    private static void acquireAllVals(Map<Integer, AttributedGraph> oriDyAG) {
        vertexMapAttrMapVals = new HashMap<Integer, Map<Integer, List<Double>>>();
        for (int i = 0; i < oriDyAG.size() - 1; ++i) {
            Map<Object, Object> attrMapVal;
            AttributedGraph aG = oriDyAG.get(i);
            if (i == 0) {
                for (Integer vId : aG.getAllVerticeId()) {
                    attrMapVal = new HashMap();
                    vertexMapAttrMapVals.put(vId, attrMapVal);
                    Map<Integer, Double> attrMap = aG.getVertex(vId).getAttrDouMap();
                    for (int attrType : attrMap.keySet()) {
                        attrMapVal.put(attrType, new LinkedList());
                    }
                }
            }
            for (Integer vId : aG.getAllVerticeId()) {
                attrMapVal = aG.getVertex(vId).getAttrDouMap();
                for (Integer n : attrMapVal.keySet()) {
                    vertexMapAttrMapVals.get(vId).get(n).add((Double)attrMapVal.get(n));
                }
            }
        }
    }

    private static void computeMeanStdDev() {
        for (int vId : vertexMapAttrMapVals.keySet()) {
            Map<Integer, List<Double>> attrMapVals = vertexMapAttrMapVals.get(vId);
            for (int attrType : attrMapVals.keySet()) {
                List<Double> vals = attrMapVals.get(attrType);
                double mean = 0.0;
                double preVal = 0.0;
                double stdDev = 0.0;
                int count = 0;
                for (double val : vals) {
                    mean += (val - preVal) / (double)(++count);
                }
                for (double val : vals) {
                    stdDev += (val - mean) * (val - mean);
                }
                stdDev = Math.sqrt(stdDev / (double)vals.size());
                vals.clear();
                vals.add(mean);
                vals.add(stdDev);
            }
        }
    }

    public static Map<Integer, ItemAttributedGraph> convertToItDyAGCase() throws IOException {
        Preprocess.findEventTypeMapping();
        Map<Integer, AttributedGraph> oriDyAG = ReadGraph.readGraph();
        if (DISCRET_FLAG == 1) {
            Preprocess.acquireAllVals(oriDyAG);
            Preprocess.computeMeanStdDev();
        }
        HashMap<Integer, ItemAttributedGraph> tempDyAG = new HashMap<Integer, ItemAttributedGraph>();
        for (int i = 0; i < oriDyAG.size() - 1; ++i) {
            AttributedGraph aG1 = oriDyAG.get(i);
            AttributedGraph aG2 = oriDyAG.get(i + 1);
            HashMap<Integer, ItemVertex> vMap = new HashMap<Integer, ItemVertex>();
            for (int vId : aG1.getAllVerticeId()) {
                Map<Integer, Double> attrMap1 = aG1.getVertex(vId).getAttrDouMap();
                Map<Integer, Double> attrMap2 = aG2.getVertex(vId).getAttrDouMap();
                LinkedList<Integer> eventTypeList = new LinkedList<Integer>();
                for (int attrType : attrMap1.keySet()) {
                    double val2;
                    double val1;
                    int trendFlag = Preprocess.findTrendFlag(DISCRET_FLAG, vId, attrType, val1 = attrMap1.get(attrType).doubleValue(), val2 = attrMap2.get(attrType).doubleValue());
                    if (trendFlag == PASS_FLAG) continue;
                    String eventName = attrMapping.get(attrType) + trends[trendFlag];
                    int eventType = eventTypeMappingRe.get(eventName);
                    eventTypeList.add(eventType);
                }
                ItemVertex iV = new ItemVertex(vId);
                iV.addItems(eventTypeList);
                vMap.put(vId, iV);
            }
            ItemAttributedGraph iAG = new ItemAttributedGraph(i, vMap, aG1.getEdgesMap());
            tempDyAG.put(i, iAG);
        }
        Preprocess.repeatGraph(tempDyAG);
        HashMap<Integer, ItemAttributedGraph> subItDyAG = new HashMap<Integer, ItemAttributedGraph>();
        for (int j = 0; j < tempDyAG.size(); ++j) {
            subItDyAG.put(j, (ItemAttributedGraph)tempDyAG.get(j));
        }
        itDyAG = subItDyAG;
        return subItDyAG;
    }

    private static int findTrendFlag(int discretFlag, int vId, int attrType, double val1, double val2) {
        int trendFlag = PASS_FLAG;
        switch (discretFlag) {
            case 0: {
                double diff = val2 - val1;
                if (diff >= INCRE_THRESHOLD) {
                    trendFlag = 2;
                } else if (diff <= -INCRE_THRESHOLD) {
                    trendFlag = 0;
                } else if (val1 > 0.0) {
                    trendFlag = 1;
                }
                return trendFlag;
            }
            case 1: {
                double diff = val2 - val1;
                double scale = ParametersSetting.SCALE;
                double stdDev = vertexMapAttrMapVals.get(vId).get(attrType).get(1);
                trendFlag = diff > 2.0 * scale * stdDev ? 4 : (diff > scale * stdDev ? 3 : (diff < -2.0 * scale * stdDev ? 0 : (diff < scale * stdDev ? 1 : PASS_FLAG)));
                return trendFlag;
            }
        }
        return 999;
    }

    static {
        eventTypeMapping = new LinkedHashMap<Integer, String>();
        eventTypeMappingRe = new LinkedHashMap<String, Integer>();
        itDyAG = new LinkedHashMap<Integer, ItemAttributedGraph>();
        INCRE_THRESHOLD = ParametersSetting.INCRE_THRESHOLD;
        ATTRI_MAPPING_PATH = ParametersSetting.ATTRI_MAPPING_PATH;
        DISCRET_FLAG = ParametersSetting.DISCRE_FLAG;
        PASS_FLAG = -999;
        EVENTTYPE_MAPPING_PATH = ParametersSetting.EVENTTYPE_MAPPING_PATH;
        switch (DISCRET_FLAG) {
            case 0: {
                trends = new String[]{"-", "0", "+"};
                break;
            }
            case 1: {
                trends = new String[]{"--", "-", "0", "+", "++"};
            }
        }
    }
}

