/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.profile.Profile;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;

public class DatabaseHelper {
    private String basePath;
    private SequenceDatabase database;

    public DatabaseHelper(String basePath) {
        this.basePath = basePath;
        this.database = new SequenceDatabase();
    }

    public SequenceDatabase getDatabase() {
        return this.database;
    }

    public void loadDataset(String fileName, int maxCount) {
        if (this.database == null) {
            this.database = new SequenceDatabase();
        } else {
            this.database.clear();
        }
        try {
            Format datasetFormat = Format.valueOf(fileName);
            this.loadPredefinedDataset(datasetFormat, maxCount);
        }
        catch (IllegalArgumentException e) {
            this.loadCustomDataset(fileName, maxCount);
        }
        Collections.shuffle(this.database.getSequences());
    }

    private void loadCustomDataset(String fileName, int maxCount) {
        try {
            this.database.loadFileCustomFormat(this.fileToPath(fileName), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"));
        }
        catch (IOException e) {
            System.out.println("Could not load dataset, IOExeption");
            e.printStackTrace();
        }
    }

    private void loadPredefinedDataset(Format format, int maxCount) {
        try {
            switch (format) {
                case BMS: {
                    this.database.loadFileBMSFormat(this.fileToPath("BMS.dat"), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"));
                    break;
                }
                case KOSARAK: {
                    this.database.loadFileCustomFormat(this.fileToPath("kosarak.dat"), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"));
                    break;
                }
                case FIFA: {
                    this.database.loadFileFIFAFormat(this.fileToPath("FIFA_large.dat"), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"));
                    break;
                }
                case MSNBC: {
                    this.database.loadFileMsnbsFormat(this.fileToPath("msnbc.seq"), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"));
                    break;
                }
                case SIGN: {
                    this.database.loadFileSignLanguage(this.fileToPath("sign_language.txt"), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"));
                    break;
                }
                case CANADARM1: {
                    this.database.loadFileSPMFFormat(this.fileToPath("Canadarm1_actions.txt"), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"));
                    break;
                }
                case CANADARM2: {
                    this.database.loadFileSPMFFormat(this.fileToPath("Canadarm2_states.txt"), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"));
                    break;
                }
                case SNAKE: {
                    this.database.loadSnakeDataset(this.fileToPath("snake.dat"), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"));
                    break;
                }
                case BIBLE_CHAR: {
                    this.database.loadFileLargeTextFormatAsCharacter(this.fileToPath("Bible.txt"), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"));
                    break;
                }
                case BIBLE_WORD: {
                    this.database.loadFileLargeTextFormatAsWords(this.fileToPath("Bible.txt"), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"), true);
                    break;
                }
                case KORAN_WORD: {
                    this.database.loadFileLargeTextFormatAsWords(this.fileToPath("koran.txt"), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"), false);
                    break;
                }
                case LEVIATHAN_WORD: {
                    this.database.loadFileLargeTextFormatAsWords(this.fileToPath("leviathan.txt"), maxCount, Profile.paramInt("sequenceMinSize"), Profile.paramInt("sequenceMaxSize"), false);
                    break;
                }
                default: {
                    System.out.println("Could not load dataset, unknown format.");
                    break;
                }
            }
        }
        catch (IOException e) {
            System.out.println("Could not load dataset, IOExeption");
            e.printStackTrace();
        }
    }

    public String fileToPath(String filename) throws UnsupportedEncodingException {
        return this.basePath + File.separator + filename;
    }

    public static enum Format {
        BMS,
        KOSARAK,
        FIFA,
        MSNBC,
        SIGN,
        CANADARM1,
        CANADARM2,
        SNAKE,
        BIBLE_CHAR,
        BIBLE_WORD,
        KORAN_WORD,
        LEVIATHAN_WORD,
        CUSTOM;

    }
}

