/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.profile.Profile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SequenceDatabase {
    private List<Sequence> sequences = new ArrayList<Sequence>();

    public void setSequences(List<Sequence> newSequences) {
        this.sequences = new ArrayList<Sequence>(newSequences);
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public int size() {
        return this.sequences.size();
    }

    public void clear() {
        this.sequences.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFileCustomFormat(String filepath, int maxCount, int minSize, int maxSize) throws IOException {
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new FileReader(filepath));
            int count = 0;
            while ((line = reader.readLine()) != null && count < maxCount) {
                String[] split = line.split(" ");
                if (split.length < minSize || split.length > maxSize) continue;
                Sequence sequence = new Sequence(-1);
                for (String value : split) {
                    Item item = new Item(Integer.valueOf(value));
                    if (item.val.equals(-1)) continue;
                    sequence.addItem(item);
                }
                this.sequences.add(sequence);
                ++count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFileBMSFormat(String filepath, int maxCount, int minSize, int maxSize) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(filepath));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int lastId = 0;
            int count = 0;
            Sequence sequence = null;
            while ((thisLine = myInput.readLine()) != null && count < maxCount) {
                String[] split = thisLine.split(" ");
                int id = Integer.parseInt(split[0]);
                int val = Integer.parseInt(split[1]);
                if (lastId != id) {
                    if (lastId != 0 && sequence.size() >= minSize && sequence.size() <= maxSize) {
                        this.sequences.add(sequence);
                        ++count;
                    }
                    sequence = new Sequence(id);
                    lastId = id;
                }
                Item item = new Item(val);
                sequence.addItem(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFileFIFAFormat(String filepath, int maxCount, int minSize, int maxSize) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(filepath));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int i = 0;
            while ((thisLine = myInput.readLine()) != null) {
                String[] split = thisLine.split(" ");
                if (maxCount == i) {
                    break;
                }
                if (split.length < minSize || split.length > maxSize) continue;
                Sequence sequence = new Sequence(-1);
                HashSet<Integer> alreadySeen = new HashSet<Integer>();
                int lastValue = -1;
                for (String value : split) {
                    int intVal = Integer.valueOf(value);
                    if (Profile.paramInt("removeDuplicatesMethod") == 2) {
                        if (alreadySeen.contains(intVal)) continue;
                        alreadySeen.add(intVal);
                    } else if (Profile.paramInt("removeDuplicatesMethod") == 1) {
                        if (lastValue == intVal) continue;
                        lastValue = intVal;
                    }
                    Item item = new Item(intVal);
                    sequence.addItem(item);
                }
                ++i;
                this.sequences.add(sequence);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFileMsnbsFormat(String filepath, int maxCount, int minSize, int maxSize) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(filepath));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int i = 0;
            while ((thisLine = myInput.readLine()) != null) {
                HashSet<Integer> alreadySeen = new HashSet<Integer>();
                String[] split = thisLine.trim().split(" ");
                if (maxCount == i) {
                    break;
                }
                Sequence sequence = new Sequence(-1);
                int lastValue = 0;
                for (String val : split) {
                    int value = Integer.valueOf(val);
                    if (Profile.paramInt("removeDuplicatesMethod") == 2) {
                        if (alreadySeen.contains(value)) continue;
                        alreadySeen.add(value);
                    } else if (Profile.paramInt("removeDuplicatesMethod") == 1) {
                        if (lastValue == value) continue;
                        lastValue = value;
                    }
                    sequence.addItem(new Item(value));
                }
                if (sequence.size() < minSize || sequence.size() > maxSize) continue;
                this.sequences.add(sequence);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFileLargeTextFormatAsCharacter(String filepath, int maxCount, int minSize, int maxSize) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(filepath));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int i = 0;
            while ((thisLine = myInput.readLine()) != null) {
                if (maxCount == i) {
                    break;
                }
                if (thisLine.length() < minSize || thisLine.length() > maxSize) continue;
                Sequence sequence = new Sequence(-1);
                for (int k = 0; k < thisLine.length(); ++k) {
                    char value = thisLine.charAt(k);
                    sequence.addItem(new Item(Integer.valueOf(value)));
                }
                ++i;
                this.sequences.add(sequence);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFileLargeTextFormatAsWords(String filepath, int maxCount, int minSize, int maxSize, boolean doNotAllowSentenceToContinueOnNextLine) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(filepath));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int seqCount = 0;
            int lastWordID = 1;
            HashMap<String, Integer> mapWordToID = new HashMap<String, Integer>();
            Sequence sequence = new Sequence(-1);
            while ((thisLine = myInput.readLine()) != null) {
                if (maxCount == seqCount) {
                    break;
                }
                StringBuffer modifiedLine = new StringBuffer(thisLine.length());
                for (int i = 0; i < thisLine.length(); ++i) {
                    char currentChar = thisLine.charAt(i);
                    if (!Character.isLetter(currentChar) && currentChar != '.' && currentChar != '?' && currentChar != ':' && currentChar != ' ') continue;
                    modifiedLine.append(currentChar);
                }
                String[] split = modifiedLine.toString().split(" ");
                for (int i = 0; i < split.length; ++i) {
                    Integer itemID;
                    boolean containsPunctuation;
                    String token = split[i];
                    boolean bl = containsPunctuation = token.contains(".") || token.contains("?") || token.contains(":");
                    if (containsPunctuation) {
                        ++seqCount;
                        if (containsPunctuation || i == split.length - 1 && doNotAllowSentenceToContinueOnNextLine) {
                            token = token.substring(0, token.length() - 1);
                        }
                        if ((itemID = (Integer)mapWordToID.get(token)) == null) {
                            itemID = lastWordID++;
                            mapWordToID.put(token, itemID);
                        }
                        sequence.addItem(new Item(itemID));
                        if (sequence.size() >= minSize && sequence.size() <= maxSize) {
                            this.sequences.add(sequence);
                        }
                        sequence = new Sequence(-1);
                        continue;
                    }
                    itemID = (Integer)mapWordToID.get(token);
                    if (itemID == null) {
                        itemID = lastWordID++;
                        mapWordToID.put(token, itemID);
                    }
                    sequence.addItem(new Item(itemID));
                }
            }
        }
    }

    public void loadFileSignLanguage(String fileToPath, int maxCount, int minsize, int maxsize) {
        BufferedReader myInput = null;
        try {
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(fileToPath));
            myInput = new BufferedReader(new InputStreamReader(fin));
            String oldUtterance = "-1";
            Sequence sequence = null;
            int count = 0;
            HashSet<Integer> alreadySeen = new HashSet<Integer>();
            int id = 0;
            int lastValue = -1;
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.length() >= 1 && thisLine.charAt(0) != '#') {
                    String[] tokens = thisLine.split(" ");
                    String currentUtterance = tokens[0];
                    if (!currentUtterance.equals(oldUtterance)) {
                        if (sequence != null && sequence.size() >= minsize && sequence.size() <= maxsize) {
                            this.sequences.add(sequence);
                            ++count;
                        }
                        sequence = new Sequence(id++);
                        alreadySeen = new HashSet();
                        oldUtterance = currentUtterance;
                    }
                    for (int j = 1; j < tokens.length; ++j) {
                        int character = Integer.parseInt(tokens[j]);
                        if (character == -11 || character == -12) continue;
                        if (Profile.paramInt("removeDuplicatesMethod") == 2) {
                            if (alreadySeen.contains(character)) continue;
                            alreadySeen.add(character);
                        } else if (Profile.paramInt("removeDuplicatesMethod") == 1) {
                            if (lastValue == character) continue;
                            lastValue = character;
                        }
                        sequence.getItems().add(new Item(character));
                    }
                }
                if (maxCount != count) continue;
            }
            if (sequence.size() >= minsize && sequence.size() <= maxsize) {
                this.sequences.add(sequence);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFileSPMFFormat(String path, int maxCount, int minSize, int maxSize) {
        BufferedReader myInput = null;
        try {
            String thisLine;
            int count = 0;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null && count < maxCount) {
                Sequence sequence = new Sequence(this.sequences.size());
                for (String entier : thisLine.split(" ")) {
                    if (entier.equals("-1")) continue;
                    if (entier.equals("-2")) {
                        if (sequence.size() < minSize || sequence.size() > maxSize) continue;
                        this.sequences.add(sequence);
                        ++count;
                        continue;
                    }
                    int val = Integer.parseInt(entier);
                    sequence.getItems().add(new Item(val));
                }
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSnakeDataset(String filepath, int nbLine, int minSize, int maxSize) {
        BufferedReader myInput = null;
        try {
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(filepath));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.length() < 50) continue;
                Sequence sequence = new Sequence(this.sequences.size());
                for (int i = 0; i < thisLine.length(); ++i) {
                    int character = thisLine.toCharArray()[i] - 65;
                    sequence.addItem(new Item(character));
                }
                if (sequence.size() >= minSize && sequence.size() <= maxSize) {
                    this.sequences.add(sequence);
                }
                this.sequences.add(sequence);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

