/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.helpers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Stats {
    private String name;
    private Map<String, Map<String, String>> data;

    public Stats(String name, List<String> rows) {
        this.name = name;
        this.data = new HashMap<String, Map<String, String>>();
        for (String row : rows) {
            this.data.put(row, this.prepareRow());
        }
    }

    public HashMap<String, String> prepareRow() {
        HashMap<String, String> row = new HashMap<String, String>();
        return row;
    }

    public void set(String row, String column, String value) {
        if (this.data.containsKey(row)) {
            this.data.put(row, new HashMap());
        }
        this.data.put(row, this.prepareRow());
        this.data.get(row).put(column, value);
    }

    public String get(String row, String column) {
        if (this.data.containsKey(row) && this.data.get(row).containsKey(column)) {
            return this.data.get(row).get(column);
        }
        return "0";
    }

    public String toString() {
        String output = "----" + this.name + "----\n";
        boolean columnDisplayed = false;
        for (Map.Entry<String, Map<String, String>> pairRow : this.data.entrySet()) {
            Map.Entry<String, String> pairColumn;
            String row = pairRow.getKey();
            Iterator<Map.Entry<String, String>> columns = this.data.get(row).entrySet().iterator();
            if (!columnDisplayed) {
                output = output + "\t";
                while (columns.hasNext()) {
                    pairColumn = columns.next();
                    output = output + "\t" + pairColumn.getKey();
                }
                output = output + "\n";
                columnDisplayed = true;
                columns = this.data.get(row).entrySet().iterator();
            }
            output = output + row + ":";
            while (columns.hasNext()) {
                pairColumn = columns.next();
                output = output + "\t" + pairColumn.getValue();
            }
            output = output + "\n";
        }
        return output;
    }

    public void Inc(String row, String column) {
        if (this.data.containsKey(row)) {
            String val = this.data.get(row).get(column);
            if (val != null) {
                Integer newVal = 1 + Integer.valueOf(val);
                this.data.get(row).put(column, newVal.toString());
            } else {
                this.data.get(row).put(column, "1");
            }
        } else {
            this.data.put(row, this.prepareRow());
            this.data.get(row).put(column, "1");
        }
    }

    public void Divide(String row, String column, float divisor) {
        if (this.data.containsKey(row)) {
            String val = this.data.get(row).get(column);
            if (val != null) {
                Float newVal = Float.valueOf(Float.valueOf(val).floatValue() / divisor);
                this.data.get(row).put(column, newVal.toString());
            } else {
                this.data.get(row).put(column, "0");
            }
        } else {
            this.data.put(row, this.prepareRow());
            this.data.get(row).put(column, "0");
        }
    }
}

