/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.helpers;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.helpers.Algo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class StatsLogger {
    private List<String> statsNames;
    private List<Algo> algorithms;
    private boolean useSteps;

    public StatsLogger(List<String> statsNames, List<String> algoNames, boolean useSteps) {
        useSteps = false;
        this.statsNames = statsNames;
        this.algorithms = new ArrayList<Algo>();
        this.useSteps = useSteps;
        for (String algoName : algoNames) {
            this.algorithms.add(new Algo(algoName, useSteps));
        }
    }

    public void addStep() {
        for (Algo algo : this.algorithms) {
            algo.addStep();
        }
    }

    public void set(String stat, String algoName, double value) {
        this.getAlgoByName(algoName).set(stat, value);
    }

    public void inc(String stat, String algoName) {
        double value = this.getAlgoByName(algoName).get(stat);
        this.getAlgoByName(algoName).set(stat, value += 1.0);
    }

    public void divide(String stat, String algoName, long divisor) {
        double value = this.getAlgoByName(algoName).get(stat);
        this.getAlgoByName(algoName).set(stat, value /= (double)divisor);
    }

    public double get(String stat, String algoName) {
        return this.getAlgoByName(algoName).get(stat);
    }

    public double get(String stat, String algoName, int step) {
        return this.getAlgoByName(algoName).get(step, stat);
    }

    private Algo getAlgoByName(String algoName) {
        for (Algo algo : this.algorithms) {
            if (algo.name.compareTo(algoName) != 0) continue;
            return algo;
        }
        return null;
    }

    public String toString() {
        String output = "";
        if (!this.useSteps) {
            output = output + "\t\t";
            for (Algo algo : this.algorithms) {
                output = output + "" + algo.name + "\t";
            }
            output = output + "\n";
            for (String stat : this.statsNames) {
                DecimalFormat tenForm = new DecimalFormat("##.###");
                String empty = "          ";
                output = output + (stat.length() < 9 ? stat + empty.substring(stat.length()) : stat.substring(0, 9));
                for (Algo algo : this.algorithms) {
                    double value = algo.get(stat) * 100.0;
                    output = output + "\t" + (value == 0.0 ? "00.000" : tenForm.format(value));
                }
                output = output + "\n";
            }
        }
        return output;
    }

    public String toJsonString() {
        String output = "";
        if (!this.useSteps) {
            output = output + "\"algorithms\": [";
            for (Algo algo : this.algorithms) {
                output = output + "\"" + algo.name + "\",";
            }
            output = output.substring(0, output.length() - 1);
            output = output + "], ";
            output = output + "\"resuls\": [";
            for (String stat : this.statsNames) {
                DecimalFormat tenForm = new DecimalFormat("##.###");
                output = output + "{\"name\": \"" + stat + "\",";
                output = output + "\"data\": [";
                for (Algo algo : this.algorithms) {
                    double value = algo.get(stat) * 100.0;
                    output = output + "" + (value == 0.0 ? "00.000" : tenForm.format(value)) + ",";
                }
                output = output.substring(0, output.length() - 1);
                output = output + "]},";
            }
            output = output.substring(0, output.length() - 1);
            output = output + "]";
        }
        return "{" + output + "}";
    }
}

