/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPT;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import java.util.ArrayList;
import java.util.List;

public class CPTHelper {
    public static void RecursiveDivider(List<Sequence> result, Sequence target, int minSize) {
        int size = target.size();
        result.add(target);
        if (size <= minSize) {
            return;
        }
        for (int toHide = 0; toHide < size; ++toHide) {
            Sequence newSequence = new Sequence(-1);
            for (int toUse = 0; toUse < size; ++toUse) {
                if (toUse == toHide) continue;
                newSequence.addItem(target.get(toUse));
            }
            CPTHelper.RecursiveDivider(result, newSequence, minSize);
        }
    }

    public static List<Sequence> sliceBasic(Sequence sequence, int length) {
        ArrayList<Sequence> cutted = new ArrayList<Sequence>();
        if (sequence.size() <= length) {
            cutted.add(sequence);
            return cutted;
        }
        cutted.add(new Sequence(0, sequence.getItems().subList(sequence.size() - length, sequence.size())));
        return cutted;
    }

    public static List<Sequence> slice(Sequence sequence, int length) {
        int i;
        ArrayList<Sequence> cutted = new ArrayList<Sequence>();
        if (sequence.size() <= length) {
            cutted.add(sequence);
            return cutted;
        }
        List<Item> items = sequence.getItems();
        int maxSlices = (int)Math.floor(items.size() / length);
        int offset = (int)Math.floor(length / 2);
        for (i = 1; i < maxSlices; ++i) {
            cutted.add(new Sequence(0, items.subList(i * length, (i + 1) * length)));
        }
        maxSlices = (int)Math.floor((items.size() - offset) / length);
        for (i = 0; i < maxSlices; ++i) {
            cutted.add(new Sequence(0, items.subList(i * length + offset, (i + 1) * length + offset)));
        }
        if (items.size() % length > 0 && (items.size() - offset) % length > 0) {
            cutted.add(new Sequence(0, items.subList(items.size() - length, items.size())));
        }
        return cutted;
    }
}

