/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.Bitvector;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.CPTHelper;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.CountTable;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.Encoder;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.FIFRaw;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.PredictionTree;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Paramable;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Predictor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CPTPlusPredictor
extends Predictor {
    public PredictionTree Root = new PredictionTree();
    public Map<Integer, PredictionTree> LT = new HashMap<Integer, PredictionTree>();
    public Map<Integer, Bitvector> II = new HashMap<Integer, Bitvector>();
    protected CPTHelper helper;
    protected long nodeNumber = 0L;
    private boolean CCF = false;
    private boolean CBS = true;
    public Encoder encoder;
    protected boolean seqEncoding = false;
    public Paramable parameters = new Paramable();
    private String TAG = "CPT+";
    private Map<Integer, Float> lastCountTable = null;

    public CPTPlusPredictor() {
        this.helper = new CPTHelper(this);
    }

    public CPTPlusPredictor(String tag) {
        this();
        this.TAG = tag;
    }

    public CPTPlusPredictor(String tag, String params) {
        this(tag);
        this.parameters.setParameter(params);
    }

    @Override
    public String getTAG() {
        return this.TAG;
    }

    @Override
    public Boolean Train(List<Sequence> trainingSequences) {
        this.Root = new PredictionTree();
        this.LT = new HashMap<Integer, PredictionTree>();
        this.II = new HashMap<Integer, Bitvector>();
        this.encoder = new Encoder();
        this.helper.setEncoded(this.encoder);
        this.nodeNumber = 0L;
        int seqId = 0;
        FIFRaw finder = new FIFRaw();
        if (this.parameters.paramBoolOrDefault("CCF", this.CCF)) {
            List<List<Item>> itemsets = finder.findFrequentItemsets(trainingSequences, this.parameters.paramInt("CCFmin"), this.parameters.paramInt("CCFmax"), this.parameters.paramInt("CCFsup"));
            for (List<Item> itemset2 : itemsets) {
                this.encoder.addEntry(itemset2);
            }
        }
        for (Sequence seq : trainingSequences) {
            if (this.parameters.paramInt("splitMethod") > 0) {
                seq = this.helper.keepLastItems(seq, this.parameters.paramInt("splitLength"));
            }
            Sequence seqCompressed = new Sequence(seq);
            seqCompressed = this.encoder.encode(seqCompressed);
            PredictionTree curNode = this.Root;
            for (Item itemCompressed : seqCompressed.getItems()) {
                List<Item> itemset3 = this.encoder.getEntry(itemCompressed.val);
                for (Item item : itemset3) {
                    if (!this.II.containsKey(item.val)) {
                        Bitvector tmpBitset = new Bitvector();
                        this.II.put(item.val, tmpBitset);
                    }
                    this.II.get(item.val).setBit(seqId);
                }
                if (!curNode.hasChild(itemCompressed).booleanValue()) {
                    curNode.addChild(itemCompressed);
                    ++this.nodeNumber;
                    curNode = curNode.getChild(itemCompressed);
                    continue;
                }
                curNode = curNode.getChild(itemCompressed);
            }
            this.LT.put(seqId, curNode);
            ++seqId;
        }
        if (this.parameters.paramBoolOrDefault("CBS", this.CBS)) {
            this.pathCollapse();
        }
        return true;
    }

    @Override
    public Sequence Predict(Sequence target) {
        target = this.helper.removeUnseenItems(target);
        CountTable ct = null;
        ct = this.predictionByActiveNoiseReduction(target);
        Sequence predicted = ct.getBestSequence(1);
        this.lastCountTable = ct.getTable();
        return predicted;
    }

    protected CountTable predictionByActiveNoiseReduction(Sequence target) {
        Sequence seq;
        HashSet<Sequence> seen = new HashSet<Sequence>();
        LinkedList<Sequence> queue = new LinkedList<Sequence>();
        queue.add(target);
        int maxPredictionCount = 1 + (int)((double)target.size() * this.parameters.paramDouble("minPredictionRatio"));
        int predictionCount = 0;
        double noiseRatio = this.parameters.paramDouble("noiseRatio");
        int initialTargetSize = target.size();
        CountTable ct = new CountTable(this.helper);
        ct.update(target.getItems().toArray(new Item[0]), target.size());
        Sequence predicted = ct.getBestSequence(1);
        if (predicted.size() > 0) {
            ++predictionCount;
        }
        while ((seq = (Sequence)queue.poll()) != null && predictionCount < maxPredictionCount) {
            if (seen.contains(seq)) continue;
            seen.add(seq);
            List<Item> noises = this.getNoise(seq, noiseRatio);
            for (Item noise : noises) {
                Item[] candidateItems;
                int branches;
                Sequence candidate = seq.clone();
                for (int i = 0; i < candidate.getItems().size(); ++i) {
                    if (!candidate.getItems().get(i).equals(noise)) continue;
                    candidate.getItems().remove(i);
                    break;
                }
                if (candidate.size() > 1) {
                    queue.add(candidate);
                }
                if ((branches = ct.update(candidateItems = candidate.getItems().toArray(new Item[0]), initialTargetSize)) <= 0 || (predicted = ct.getBestSequence(1)).size() <= 0) continue;
                ++predictionCount;
            }
        }
        return ct;
    }

    protected List<Item> getNoise(Sequence target, double noiseRatio) {
        int noiseCount = (int)Math.floor((double)target.size() * noiseRatio);
        if (noiseCount <= 0) {
            int minSup = Integer.MAX_VALUE;
            int itemVal = -1;
            for (Item item : target.getItems()) {
                if (this.II.get(item.val).cardinality() >= minSup) continue;
                minSup = this.II.get(item.val).cardinality();
                itemVal = item.val;
            }
            ArrayList<Item> noises = new ArrayList<Item>();
            noises.add(new Item(itemVal));
            return noises;
        }
        List noises = target.getItems().stream().sorted((i1, i2) -> Integer.compare(this.II.get(i2.val).cardinality(), this.II.get(i1.val).cardinality())).collect(Collectors.toList());
        return noises.subList(target.size() - noiseCount, target.size());
    }

    protected void pathCollapse() {
        int nodeSaved = 0;
        for (Map.Entry<Integer, PredictionTree> entry : this.LT.entrySet()) {
            PredictionTree cur;
            PredictionTree leaf = cur = entry.getValue();
            PredictionTree last = null;
            ArrayList<Item> itemset2 = new ArrayList<Item>();
            int pathLength = 0;
            boolean singlePath = true;
            if (cur.getChildren().size() != 0) continue;
            while (singlePath) {
                if (cur.getChildren().size() > 1 || cur == null) {
                    if (pathLength != 1) {
                        Integer newId = this.encoder.getIdorAdd(itemset2);
                        leaf.Item = new Item(newId);
                        leaf.Parent = cur;
                        cur.removeChild(last.Item);
                        cur.addChild(leaf);
                        nodeSaved += pathLength - 1;
                    }
                    singlePath = false;
                    continue;
                }
                List<Item> curItemset = this.encoder.getEntry(cur.Item.val);
                ArrayList<Item> tmp = itemset2;
                itemset2 = new ArrayList();
                itemset2.addAll(curItemset);
                itemset2.addAll(tmp);
                cur.getChildren().clear();
                ++pathLength;
                last = cur;
                cur = cur.Parent;
            }
        }
        this.nodeNumber -= (long)nodeSaved;
    }

    @Override
    public long size() {
        return this.nodeNumber;
    }

    @Override
    public float memoryUsage() {
        float sizePredictionTree = this.nodeNumber * 3L * 4L;
        float sizeInvertedIndex = (float)((double)this.II.size() * (Math.ceil(this.LT.size() / 8) + 4.0));
        float sizeLookupTable = this.LT.size() * 2 * 4;
        return sizePredictionTree + sizeInvertedIndex + sizeLookupTable;
    }

    public Map<Integer, Float> getCountTable() {
        return this.lastCountTable;
    }
}

