/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.LZ78;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.LZ78.LZNode;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Predictor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LZ78Predictor
extends Predictor {
    private int count;
    private int order;
    private HashMap<List<Integer>, LZNode> mDictionary;

    public LZ78Predictor() {
        this.TAG = "LZ78";
    }

    public LZ78Predictor(String tag) {
        this.TAG = tag;
    }

    @Override
    public Boolean Train(List<Sequence> trainingSequences) {
        this.mDictionary = new HashMap();
        this.order = 0;
        for (Sequence seq : trainingSequences) {
            List<Item> items = seq.getItems();
            ArrayList<Integer> lzPhrase = new ArrayList<Integer>();
            ArrayList<Integer> prefix = new ArrayList<Integer>();
            for (int offset = 0; offset < items.size(); ++offset) {
                Integer cur = items.get((int)offset).val;
                lzPhrase = new ArrayList(prefix);
                lzPhrase.add(cur);
                LZNode node = this.mDictionary.get(lzPhrase);
                if (node != null) {
                    node.inc();
                    this.mDictionary.put(lzPhrase, node);
                    int n = this.order = lzPhrase.size() > this.order ? lzPhrase.size() : this.order;
                    if (prefix.size() > 0 && this.mDictionary.get(prefix) != null) {
                        this.mDictionary.get(prefix).incChildSupport();
                    }
                    prefix.add(cur);
                    continue;
                }
                if (prefix.size() > 0 && this.mDictionary.get(prefix) != null) {
                    this.mDictionary.get(prefix).addChild(cur);
                }
                this.mDictionary.put(lzPhrase, new LZNode(cur));
                prefix.clear();
                ++this.count;
            }
        }
        return true;
    }

    @Override
    public Sequence Predict(Sequence target) {
        HashMap<Integer, Double> results = new HashMap<Integer, Double>();
        ArrayList<Integer> lzPhrase = new ArrayList<Integer>();
        ArrayList<Integer> prefix = new ArrayList<Integer>();
        List<Item> lastItems = target.getLastItems(this.order, 0).getItems();
        Collections.reverse(lastItems);
        for (Item item : lastItems) {
            prefix.add(0, item.val);
            LZNode parent = this.mDictionary.get(prefix);
            if (parent == null) continue;
            int escapeK = parent.getSup() - parent.getChildSup();
            for (Integer value : parent.children) {
                lzPhrase = new ArrayList(prefix);
                lzPhrase.add(value);
                LZNode child = this.mDictionary.get(lzPhrase);
                if (child == null) continue;
                Double probK1 = results.getOrDefault(value, 0.0);
                Double probK = (double)child.getSup() / (double)parent.getSup() + (double)escapeK * probK1;
                results.put(value, probK);
            }
        }
        Double highestScore = 0.0;
        Integer mostProbableItem = null;
        for (Map.Entry entry : results.entrySet()) {
            if (!((Double)entry.getValue() > highestScore)) continue;
            highestScore = (Double)entry.getValue();
            mostProbableItem = (Integer)entry.getKey();
        }
        Sequence predicted = new Sequence(-1);
        if (mostProbableItem != null) {
            predicted.addItem(new Item(mostProbableItem));
        }
        return predicted;
    }

    @Override
    public long size() {
        return this.count;
    }

    @Override
    public float memoryUsage() {
        float size = 0.0f;
        for (LZNode node : this.mDictionary.values()) {
            size += (float)(12 + 4 * node.children.size());
        }
        return size;
    }

    public static void main(String ... args) {
        Sequence s1 = new Sequence(1);
        s1.addItem(new Item(1));
        s1.addItem(new Item(1));
        s1.addItem(new Item(1));
        s1.addItem(new Item(2));
        s1.addItem(new Item(1));
        s1.addItem(new Item(2));
        s1.addItem(new Item(2));
        s1.addItem(new Item(2));
        s1.addItem(new Item(2));
        s1.addItem(new Item(2));
        s1.addItem(new Item(1));
        s1.addItem(new Item(1));
        s1.addItem(new Item(2));
        s1.addItem(new Item(3));
        s1.addItem(new Item(3));
        s1.addItem(new Item(4));
        s1.addItem(new Item(4));
        s1.addItem(new Item(3));
        s1.addItem(new Item(2));
        s1.addItem(new Item(1));
        s1.addItem(new Item(1));
        s1.addItem(new Item(1));
        s1.addItem(new Item(1));
        LinkedList<Sequence> training = new LinkedList<Sequence>();
        training.add(s1);
        LZ78Predictor lz = new LZ78Predictor();
        lz.Train(training);
        System.out.println(lz.size());
        System.out.println(lz.memoryUsage() + " bytes");
    }
}

