/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Markov;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Markov.MarkovState;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Paramable;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Predictor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MarkovAllKPredictor
extends Predictor {
    private int K = 5;
    private HashMap<String, MarkovState> mDictionary;
    public Paramable parameters;

    public MarkovAllKPredictor() {
        this.TAG = "AKOM";
        this.parameters = new Paramable();
    }

    public MarkovAllKPredictor(String tag) {
        this.TAG = tag;
        this.parameters = new Paramable();
    }

    public MarkovAllKPredictor(String tag, String params) {
        this(tag);
        this.parameters.setParameter(params);
    }

    @Override
    public Boolean Train(List<Sequence> trainingSequences) {
        this.mDictionary = new HashMap();
        for (Sequence seq : trainingSequences) {
            List<Item> items = seq.getItems();
            for (int i = 0; i < items.size() - 1; ++i) {
                int k = this.parameters.paramIntOrDefault("order", this.K);
                k = items.size() - i > k ? k : items.size() - i - 1;
                for (int c = 1; c <= k; ++c) {
                    String key = "";
                    for (int j = 0; j < c; ++j) {
                        key = key + items.get((int)(i + j)).val.toString() + "_";
                    }
                    MarkovState state = this.mDictionary.get(key = key.substring(0, key.length() - 1));
                    if (state == null) {
                        state = new MarkovState();
                    }
                    state.addTransition(items.get((int)(i + c)).val);
                    this.mDictionary.put(key, state);
                }
            }
        }
        return true;
    }

    @Override
    public Sequence Predict(Sequence target) {
        int k = this.parameters.paramIntOrDefault("order", this.K);
        for (int i = k = target.size() >= k ? k : target.size(); i > 0; --i) {
            String key = "";
            for (int j = target.size() - i; j < target.size(); ++j) {
                key = key + target.get(j) + "_";
            }
            MarkovState state = this.mDictionary.get(key = key.substring(0, key.length() - 1));
            if (state == null) continue;
            Integer nextState = state.getBestNextState();
            Sequence predicted = new Sequence(-1);
            predicted.addItem(new Item(nextState));
            if (i < this.K) {
                // empty if block
            }
            return predicted;
        }
        return new Sequence(-1);
    }

    @Override
    public long size() {
        long nodeCount = 0L;
        for (MarkovState state : this.mDictionary.values()) {
            nodeCount += (long)(1 + state.getTransitionCount());
        }
        return nodeCount;
    }

    @Override
    public float memoryUsage() {
        float size = 0.0f;
        for (MarkovState state : this.mDictionary.values()) {
            size += (float)(4 + 8 * state.getTransitionCount());
        }
        return size;
    }

    public static void main(String[] args) {
        MarkovAllKPredictor predictor = new MarkovAllKPredictor();
        ArrayList<Sequence> training = new ArrayList<Sequence>();
        Sequence seq1 = new Sequence(-1);
        seq1.addItem(new Item(1));
        seq1.addItem(new Item(2));
        seq1.addItem(new Item(3));
        seq1.addItem(new Item(4));
        training.add(seq1);
        Sequence seq2 = new Sequence(-1);
        seq2.addItem(new Item(1));
        seq2.addItem(new Item(2));
        seq2.addItem(new Item(3));
        seq2.addItem(new Item(4));
        training.add(seq2);
        Sequence seq3 = new Sequence(-1);
        seq3.addItem(new Item(1));
        seq3.addItem(new Item(2));
        seq3.addItem(new Item(3));
        seq3.addItem(new Item(4));
        training.add(seq3);
        Sequence seq4 = new Sequence(-1);
        seq4.addItem(new Item(0));
        seq4.addItem(new Item(1));
        seq4.addItem(new Item(2));
        seq4.addItem(new Item(4));
        training.add(seq4);
        predictor.Train(training);
        Sequence seqT = new Sequence(-1);
        seqT.addItem(new Item(0));
        seqT.addItem(new Item(1));
        seqT.addItem(new Item(2));
        Sequence result = predictor.Predict(seqT);
        System.out.println(result.toString());
    }
}

