/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.TDAG;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Predictor;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.TDAG.TDAGNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TDAGPredictor
extends Predictor {
    private List<TDAGNode> state;
    private TDAGNode root;
    private Integer size;
    private final Integer maxTreeHeight = 6;
    private HashMap<List<Integer>, TDAGNode> mDictionary;

    public TDAGPredictor() {
        this.TAG = "TDAG";
    }

    public TDAGPredictor(String tag) {
        this.TAG = tag;
    }

    @Override
    public Boolean Train(List<Sequence> trainingSequences) {
        this.root = new TDAGNode(0, new ArrayList<Integer>());
        this.size = 1;
        this.state = new ArrayList<TDAGNode>();
        this.mDictionary = new HashMap();
        for (Sequence seq : trainingSequences) {
            this.state.clear();
            this.state.add(this.root);
            for (Item item : seq.getItems()) {
                ArrayList<TDAGNode> newState = new ArrayList<TDAGNode>();
                newState.add(this.root);
                for (TDAGNode node : this.state) {
                    if (node.pathFromRoot.size() > this.maxTreeHeight) continue;
                    if (!node.hasChild(item.val)) {
                        Integer n = this.size;
                        this.size = this.size + 1;
                    }
                    TDAGNode child = node.addChild(item.val);
                    this.mDictionary.put(child.pathFromRoot, child);
                    newState.add(child);
                }
                this.state = newState;
            }
        }
        this.state.clear();
        return true;
    }

    @Override
    public Sequence Predict(Sequence target) {
        Sequence predicted = new Sequence(-1);
        ArrayList<Integer> symbols = new ArrayList<Integer>();
        symbols.add(0);
        for (Item item : target.getItems()) {
            symbols.add(item.val);
        }
        TDAGNode context = this.mDictionary.get(symbols);
        while (context == null && symbols.size() > 1) {
            symbols.remove(1);
            context = this.mDictionary.get(symbols);
            if (context == null || context.children.size() != 0) continue;
            context = null;
        }
        if (context != null) {
            TDAGNode candidate1 = null;
            TDAGNode candidate2 = null;
            for (Map.Entry<Integer, TDAGNode> entry : context.children.entrySet()) {
                double score = (double)entry.getValue().inCount.intValue() / (double)context.outCount.intValue();
                entry.getValue().score = score;
                if (candidate1 == null || candidate1.score < score) {
                    candidate2 = candidate1;
                    candidate1 = entry.getValue();
                    continue;
                }
                if (candidate2 != null && !(candidate2.score < score)) continue;
                candidate2 = entry.getValue();
            }
            Double treshold = 0.0;
            if (candidate1 != null && (candidate2 == null || candidate1.score - candidate2.score >= treshold)) {
                predicted.addItem(new Item(candidate1.symbol));
            }
        }
        return predicted;
    }

    @Override
    public long size() {
        return this.size.intValue();
    }

    @Override
    public float memoryUsage() {
        return this.size * 16;
    }

    public static void main(String ... args) {
        Sequence A = new Sequence(1);
        A.addItem(new Item(1));
        A.addItem(new Item(2));
        A.addItem(new Item(3));
        Sequence B = new Sequence(2);
        B.addItem(new Item(1));
        B.addItem(new Item(3));
        B.addItem(new Item(2));
        ArrayList<Sequence> trainingSet = new ArrayList<Sequence>();
        trainingSet.add(A);
        trainingSet.add(B);
        TDAGPredictor p = new TDAGPredictor();
        p.Train(trainingSet);
        Sequence X = new Sequence(3);
        X.addItem(new Item(4));
        Sequence predicted = p.Predict(X);
        System.out.println("Predicted " + predicted);
    }
}

