/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.cmrules;

import ca.pfv.spmf.algorithms.sequential_rules.cmrules.AlgoAprioriTID_forCMRules;
import ca.pfv.spmf.algorithms.sequential_rules.cmrules.Rule;
import ca.pfv.spmf.datastructures.triangularmatrix.TriangularMatrix;
import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoCMRules {
    int associationRulesCount = 0;
    int ruleCount;
    long timeStart = 0L;
    long timeEnd = 0L;
    long timeEndConvert = 0L;
    long timeEndApriori = 0L;
    long timeEndSequentialMeasures = 0L;
    long timeBeginCalculateSequentialMeasures = 0L;
    long timeEndPreprocessing = 0L;
    public int minCSupRelative = 0;
    public double minSeqConfidence;
    SequenceDatabase sequences;
    int minLeftSize = 0;
    int maxLeftSize = 500;
    int minRightSize = 0;
    int maxRightSize = 500;
    int maxItemId = 0;
    Map<Integer, Set<Integer>> mapItemCount = new HashMap<Integer, Set<Integer>>();
    List<Integer> listFrequentsSize1 = new ArrayList<Integer>();
    private Itemsets patterns;
    private TriangularMatrix matrix;
    BufferedWriter writer = null;

    public void runAlgorithm(String input, String output, double absoluteMinSupport, double minConfidence) throws IOException {
        this.sequences = new SequenceDatabase();
        this.sequences.loadFile(input);
        this.minCSupRelative = (int)Math.ceil(absoluteMinSupport * (double)this.sequences.size());
        this.runAlgorithm(this.minCSupRelative, minConfidence, input, output);
    }

    public void runAlgorithm(int relativeSupport, double minConfidence, String input, String output) throws IOException {
        MemoryLogger.getInstance().reset();
        this.minSeqConfidence = minConfidence;
        this.minCSupRelative = relativeSupport;
        if (this.minCSupRelative == 0) {
            this.minCSupRelative = 1;
        }
        if (this.sequences == null) {
            this.sequences = new SequenceDatabase();
            this.sequences.loadFile(input);
        }
        this.writer = new BufferedWriter(new FileWriter(output));
        this.timeStart = System.currentTimeMillis();
        if (this.maxLeftSize >= 1 && this.maxRightSize >= 1) {
            this.removeItemsThatAreNotFrequent(this.sequences);
            for (int i = 0; i <= this.maxItemId; ++i) {
                if (this.mapItemCount.get(i) == null || this.mapItemCount.get(i).size() < this.minCSupRelative) continue;
                this.listFrequentsSize1.add(i);
            }
            Collections.sort(this.listFrequentsSize1);
        }
        this.timeEndPreprocessing = System.currentTimeMillis();
        TransactionDatabase context = this.convert(this.sequences);
        this.timeEndConvert = System.currentTimeMillis();
        AlgoAprioriTID_forCMRules apriori = new AlgoAprioriTID_forCMRules(context, this.matrix);
        apriori.setMaxItemsetSize(this.maxLeftSize + this.maxRightSize);
        this.patterns = apriori.runAlgorithm(this.minCSupRelative, this.listFrequentsSize1, this.mapItemCount);
        MemoryLogger.getInstance().checkMemory();
        this.timeEndApriori = System.currentTimeMillis();
        this.generateRules(this.patterns);
        MemoryLogger.getInstance().checkMemory();
        this.timeEnd = System.currentTimeMillis();
        this.sequences = null;
        this.writer.close();
    }

    private Map<Integer, Set<Integer>> removeItemsThatAreNotFrequent(SequenceDatabase sequences) {
        this.mapItemCount = new HashMap<Integer, Set<Integer>>();
        for (Sequence sequence : sequences.getSequences()) {
            for (List<Integer> itemset2 : sequence.getItemsets()) {
                for (int i = 0; i < itemset2.size(); ++i) {
                    Set<Integer> ids = this.mapItemCount.get(itemset2.get(i));
                    if (ids == null) {
                        ids = new HashSet<Integer>();
                        this.mapItemCount.put(itemset2.get(i), ids);
                        if (itemset2.get(i) > this.maxItemId) {
                            this.maxItemId = itemset2.get(i);
                        }
                    }
                    ids.add(sequence.getId());
                }
            }
        }
        for (Sequence sequence : sequences.getSequences()) {
            int i = 0;
            while (i < sequence.getItemsets().size()) {
                List<Integer> itemset2;
                itemset2 = sequence.getItemsets().get(i);
                int j = 0;
                while (j < itemset2.size()) {
                    double count = this.mapItemCount.get(itemset2.get(j)).size();
                    if (count < (double)this.minCSupRelative) {
                        itemset2.remove(j);
                        continue;
                    }
                    ++j;
                }
                if (itemset2.size() == 0) {
                    sequence.getItemsets().remove(i);
                    continue;
                }
                ++i;
            }
        }
        return this.mapItemCount;
    }

    private void calculateSequentialMeasures(Rule rule, Sequence sequence) {
        int item;
        int j;
        List<Integer> itemset2;
        int i;
        HashSet<Integer> setAlreadySeen = new HashSet<Integer>(rule.getItemset1().size() * 3);
        block0: for (i = 0; i < sequence.getItemsets().size(); ++i) {
            itemset2 = sequence.get(i);
            for (j = 0; j < itemset2.size(); ++j) {
                item = itemset2.get(j);
                if (!rule.getItemset1().contains(item)) continue;
                setAlreadySeen.add(item);
                if (setAlreadySeen.size() == rule.getItemset1().size()) break block0;
            }
        }
        ++i;
        setAlreadySeen.clear();
        while (i < sequence.getItemsets().size()) {
            itemset2 = sequence.get(i);
            for (j = 0; j < itemset2.size(); ++j) {
                item = itemset2.get(j);
                if (!rule.getItemset2().contains(item)) continue;
                setAlreadySeen.add(item);
                if (setAlreadySeen.size() != rule.getItemset2().size()) continue;
                ++rule.sequentialTransactionCount;
                return;
            }
            ++i;
        }
    }

    private TransactionDatabase convert(SequenceDatabase sequences) {
        TransactionDatabase transactionDatabase = new TransactionDatabase();
        for (Sequence sequence : sequences.getSequences()) {
            ArrayList<Integer> transaction = new ArrayList<Integer>();
            for (List<Integer> itemset2 : sequence.getItemsets()) {
                transaction.addAll(itemset2);
            }
            transactionDatabase.addTransaction(transaction);
        }
        return transactionDatabase;
    }

    public void printStats() {
        System.out.println("=============  CMRULES - STATS =============");
        System.out.println("Association rules count: " + this.associationRulesCount);
        System.out.println("Sequential rules count: " + this.ruleCount);
        System.out.println("Total time : " + (this.timeEnd - this.timeStart) + " ms");
        System.out.println("Max memory: " + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("===================================================");
    }

    void checkRule(Rule rule) throws IOException {
        ++this.associationRulesCount;
        for (Integer seqId : rule.getItemset1().getTransactionsIds()) {
            this.calculateSequentialMeasures(rule, this.sequences.getSequences().get(seqId));
        }
        if (rule.sequentialTransactionCount >= this.minCSupRelative && rule.getSequentialConfidence() >= this.minSeqConfidence) {
            this.saveRule(rule);
        }
    }

    void generateRules(Itemsets patterns) throws IOException {
        for (int k = 2; k < patterns.getLevels().size(); ++k) {
            for (Itemset lk : patterns.getLevels().get(k)) {
                HashSet<Itemset> H1 = new HashSet<Itemset>();
                for (Itemset itemsetSize1 : patterns.getLevels().get(1)) {
                    if (!lk.contains(itemsetSize1.getItems()[0])) continue;
                    H1.add(itemsetSize1);
                }
                HashSet<Itemset> H1_for_recursion = new HashSet<Itemset>();
                for (Itemset hm_P_1 : H1) {
                    Itemset itemset_Lk_minus_hm_P_1 = lk.cloneItemSetMinusAnItemset(hm_P_1);
                    this.calculateSupport(itemset_Lk_minus_hm_P_1);
                    double conf = (double)lk.getAbsoluteSupport() / (double)itemset_Lk_minus_hm_P_1.getAbsoluteSupport();
                    if (!(conf >= this.minSeqConfidence)) continue;
                    int leftsize = lk.size() - 1;
                    if (leftsize <= this.maxLeftSize && leftsize >= this.minLeftSize && 1 >= this.minRightSize && 1 <= this.maxRightSize) {
                        Rule rule = new Rule(itemset_Lk_minus_hm_P_1, hm_P_1, lk.getAbsoluteSupport(), conf);
                        this.checkRule(rule);
                    }
                    if (1 == this.maxRightSize || leftsize == this.minLeftSize) continue;
                    H1_for_recursion.add(hm_P_1);
                }
                if (1 == this.maxRightSize || lk.size() - 1 == this.minLeftSize) continue;
                this.apGenrules(k, 1, lk, H1_for_recursion);
            }
        }
    }

    private void saveRule(Rule rule) throws IOException {
        int i;
        ++this.ruleCount;
        StringBuilder buffer = new StringBuilder();
        for (i = 0; i < rule.getItemset1().size(); ++i) {
            buffer.append(rule.getItemset1().get(i));
            if (i == rule.getItemset1().size() - 1) continue;
            buffer.append(",");
        }
        buffer.append(" ==> ");
        for (i = 0; i < rule.getItemset2().size(); ++i) {
            buffer.append(rule.getItemset2().get(i));
            if (i == rule.getItemset2().size() - 1) continue;
            buffer.append(",");
        }
        buffer.append(" #SUP: ");
        buffer.append(rule.getSequentialAbsoluteSeqSupport());
        buffer.append(" #CONF: ");
        buffer.append(rule.getConfidence());
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void apGenrules(int k, int m, Itemset lk, Set<Itemset> Hm) throws IOException {
        if (k > m + 1) {
            int leftsize = lk.size() - (1 + m);
            Set<Itemset> Hm_plus_1 = this.generateCandidateSizeK(Hm);
            HashSet<Itemset> Hm_plus_1_for_recursion = new HashSet<Itemset>();
            for (Itemset hm_P_1 : Hm_plus_1) {
                Itemset itemset_Lk_minus_hm_P_1 = lk.cloneItemSetMinusAnItemset(hm_P_1);
                this.calculateSupport(itemset_Lk_minus_hm_P_1);
                double conf = (double)lk.getAbsoluteSupport() / (double)itemset_Lk_minus_hm_P_1.getAbsoluteSupport();
                if (!(conf >= this.minSeqConfidence)) continue;
                if (leftsize <= this.maxLeftSize && leftsize >= this.minLeftSize && m + 1 >= this.minRightSize && m + 1 <= this.maxRightSize) {
                    Rule rule = new Rule(itemset_Lk_minus_hm_P_1, hm_P_1, lk.getAbsoluteSupport(), conf);
                    this.checkRule(rule);
                }
                if (1 + m == this.maxRightSize || leftsize == this.minLeftSize) continue;
                Hm_plus_1_for_recursion.add(hm_P_1);
            }
            if (1 + m != this.maxRightSize && leftsize != this.minLeftSize) {
                this.apGenrules(k, m + 1, lk, Hm_plus_1_for_recursion);
            }
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void calculateSupport(Itemset itemset_Lk_minus_hm_P_1) {
        for (Itemset itemset2 : this.patterns.getLevels().get(itemset_Lk_minus_hm_P_1.size())) {
            if (!itemset2.isEqualTo(itemset_Lk_minus_hm_P_1)) continue;
            itemset_Lk_minus_hm_P_1.setTIDs(itemset2.getTransactionsIds());
            return;
        }
    }

    protected Set<Itemset> generateCandidateSizeK(Set<Itemset> levelK_1) {
        HashSet<Itemset> candidates = new HashSet<Itemset>();
        for (Itemset itemset1 : levelK_1) {
            for (Itemset itemset2 : levelK_1) {
                Integer missing = itemset1.allTheSameExceptLastItem(itemset2);
                if (missing == null) continue;
                int[] newItemset = new int[itemset1.size() + 1];
                System.arraycopy(itemset1.itemset, 0, newItemset, 0, itemset1.size());
                newItemset[itemset1.size()] = missing;
                Itemset candidate = new Itemset(newItemset);
                if (!this.allSubsetsOfSizeK_1AreFrequent(candidate, levelK_1)) continue;
                candidates.add(candidate);
            }
        }
        return candidates;
    }

    protected boolean allSubsetsOfSizeK_1AreFrequent(Itemset candidate, Set<Itemset> levelK_1) {
        if (candidate.size() == 1) {
            return true;
        }
        int[] nArray = candidate.getItems();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer item = nArray[i];
            Itemset subset = candidate.cloneItemSetMinusOneItem(item);
            boolean found = false;
            for (Itemset itemset2 : levelK_1) {
                if (!itemset2.isEqualTo(subset)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void setMinLeftSize(int minLeftSize) {
        this.minLeftSize = minLeftSize;
    }

    public void setMaxLeftSize(int maxLeftSize) {
        this.maxLeftSize = maxLeftSize;
    }

    public void setMinRightSize(int minRightSize) {
        this.minRightSize = minRightSize;
    }

    public void setMaxRightSize(int maxRightSize) {
        this.maxRightSize = maxRightSize;
    }
}

