/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.husrm;

import ca.pfv.spmf.algorithms.sequential_rules.husrm.SequenceWithUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SequenceDatabaseWithUtility {
    private List<SequenceWithUtility> sequences = new ArrayList<SequenceWithUtility>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path, int maximumNumberOfSequences) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int i = 0;
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(" ");
                this.addSequence(split);
                if (++i != maximumNumberOfSequences) continue;
                break;
            }
        }
    }

    void addSequence(String[] tokens) {
        HashSet<Integer> alreadySeenItems = new HashSet<Integer>();
        int profitExtraItemOccurrences = 0;
        SequenceWithUtility sequence = new SequenceWithUtility(this.sequences.size());
        ArrayList<Integer> itemset2 = new ArrayList<Integer>();
        ArrayList<Double> itemsetProfit = new ArrayList<Double>();
        for (String token : tokens) {
            String profitWithoutBrackets;
            String profit;
            String[] strings;
            if (token.isEmpty()) continue;
            if (token.charAt(0) == 'S') {
                strings = token.split(":");
                String exactUtility = strings[1];
                sequence.exactUtility = Double.parseDouble(exactUtility) - (double)profitExtraItemOccurrences;
                continue;
            }
            if (token.equals("-1")) {
                sequence.addItemset(itemset2);
                sequence.addItemsetProfit(itemsetProfit);
                itemset2 = new ArrayList();
                itemsetProfit = new ArrayList();
                continue;
            }
            if (token.equals("-2")) {
                this.sequences.add(sequence);
                continue;
            }
            strings = token.split("\\[");
            String item = strings[0];
            int itemInt = Integer.parseInt(item);
            if (!alreadySeenItems.contains(itemInt)) {
                profit = strings[1];
                profitWithoutBrackets = profit.substring(0, profit.length() - 1);
                itemset2.add(itemInt);
                itemsetProfit.add(Double.parseDouble(profitWithoutBrackets));
                alreadySeenItems.add(itemInt);
                continue;
            }
            profit = strings[1];
            profitWithoutBrackets = profit.substring(0, profit.length() - 1);
            profitExtraItemOccurrences = (int)((double)profitExtraItemOccurrences + Double.parseDouble(profitWithoutBrackets));
        }
    }

    public void addSequence(SequenceWithUtility sequence) {
        this.sequences.add(sequence);
    }

    public void print() {
        System.out.println("============  SEQUENCE DATABASE ==========");
        for (SequenceWithUtility sequence : this.sequences) {
            System.out.print(sequence.getId() + ":  ");
            sequence.print();
            System.out.println("");
        }
    }

    public void printDatabaseStats() {
        System.out.println("============  STATS ==========");
        System.out.println("Number of sequences : " + this.sequences.size());
        long size = 0L;
        for (SequenceWithUtility sequence : this.sequences) {
            size += (long)sequence.size();
        }
        double meansize = (float)size / (float)this.sequences.size();
        System.out.println("mean size" + meansize);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (SequenceWithUtility sequence : this.sequences) {
            r.append(sequence.getId());
            r.append(":  ");
            r.append(sequence.toString());
            r.append('\n');
        }
        return r.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<SequenceWithUtility> getSequences() {
        return this.sequences;
    }

    public Set<Integer> getSequenceIDs() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (SequenceWithUtility sequence : this.getSequences()) {
            set.add(sequence.getId());
        }
        return set;
    }
}

