/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.rulegen;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.AlgoPrefixSpan;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.SequentialPatterns;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class AlgoRuleGen {
    private long startTime;
    private long endTime;
    private int patternCount;
    BufferedWriter writer = null;

    public void runAlgorithm(int minsup, double minconf, String input, String output) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(output));
        this.startTime = System.currentTimeMillis();
        AlgoPrefixSpan algo = new AlgoPrefixSpan();
        SequentialPatterns patternsLists = algo.runAlgorithm(input, null, minsup);
        for (int i = 0; i < patternsLists.getLevels().size(); ++i) {
            for (int j = 0; j < patternsLists.getLevel(i).size(); ++j) {
                SequentialPattern pattern1 = patternsLists.getLevel(i).get(j);
                for (int k = i + 1; k < patternsLists.getLevels().size(); ++k) {
                    for (int m = 0; m < patternsLists.getLevel(k).size(); ++m) {
                        SequentialPattern pattern2 = patternsLists.getLevel(k).get(m);
                        this.tryToGenerateRule(pattern1, pattern2, minconf);
                        this.tryToGenerateRule(pattern2, pattern1, minconf);
                    }
                }
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTime = System.currentTimeMillis();
        this.writer.close();
    }

    private void tryToGenerateRule(SequentialPattern pattern1, SequentialPattern pattern2, double minconf) throws IOException {
        if (!this.strictlyContains(pattern2, pattern1)) {
            return;
        }
        double conf = (double)pattern2.getAbsoluteSupport() / (double)pattern1.getAbsoluteSupport();
        if (conf < minconf) {
            return;
        }
        ++this.patternCount;
        StringBuilder buffer = new StringBuilder();
        buffer.append(pattern1.itemsetsToString());
        buffer.append(" ==> ");
        buffer.append(pattern2.itemsetsToString());
        buffer.append(" #SUP: ");
        buffer.append(pattern2.getAbsoluteSupport());
        buffer.append(" #CONF: ");
        buffer.append(conf);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    boolean strictlyContains(SequentialPattern pattern1, SequentialPattern pattern2) {
        if (pattern1.size() <= pattern2.size()) {
            return false;
        }
        int i = 0;
        int j = 0;
        do {
            if (pattern1.getItemsets().get(j).containsAll(pattern2.get(i)) && ++i == pattern2.size()) {
                return true;
            }
            if (++j < pattern1.size()) continue;
            return false;
        } while (pattern1.size() - j >= pattern2.size() - i);
        return false;
    }

    public void printStats() {
        System.out.println("=============  SEQUENTIAL RULES - STATS =============");
        System.out.println("Sequential rules count: " + this.patternCount);
        System.out.println("Total time : " + (this.endTime - this.startTime) + " ms");
        System.out.println("Max memory: " + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("===================================================");
    }
}

