/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.rulegrowth;

import ca.pfv.spmf.algorithms.sequential_rules.rulegrowth.Occurence;
import ca.pfv.spmf.algorithms.sequential_rules.rulegrowth.Rule;
import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoRULEGROWTH {
    long timeStart = 0L;
    long timeEnd = 0L;
    int ruleCount;
    double minConfidence;
    int minsuppRelative;
    SequenceDatabase database;
    Map<Integer, Map<Integer, Occurence>> mapItemCount;
    BufferedWriter writer = null;
    static List<Rule> allRulesFoundForDEBUG = new ArrayList<Rule>();
    boolean DEBUG = false;
    int maxAntecedentSize = Integer.MAX_VALUE;
    int maxConsequentSize = Integer.MAX_VALUE;

    public void runAlgorithm(double minSupport, double minConfidence, String input, String output) throws IOException {
        try {
            this.database = new SequenceDatabase();
            this.database.loadFile(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minsuppRelative = (int)Math.ceil(minSupport * (double)this.database.size());
        this.runAlgorithm(input, output, this.minsuppRelative, minConfidence);
    }

    public void runAlgorithm(String input, String output, int relativeMinsup, double minConfidence) throws IOException {
        int i;
        this.minConfidence = minConfidence;
        this.ruleCount = 0;
        if (this.database == null) {
            try {
                this.database = new SequenceDatabase();
                this.database.loadFile(input);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MemoryLogger.getInstance().reset();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.minsuppRelative = relativeMinsup;
        if (this.minsuppRelative == 0) {
            this.minsuppRelative = 1;
        }
        this.timeStart = System.currentTimeMillis();
        this.removeItemsThatAreNotFrequent(this.database);
        ArrayList<Integer> listFrequents = new ArrayList<Integer>();
        for (Map.Entry<Integer, Map<Integer, Occurence>> entry : this.mapItemCount.entrySet()) {
            if (entry.getValue().size() < this.minsuppRelative) continue;
            listFrequents.add(entry.getKey());
        }
        for (i = 0; i < listFrequents.size(); ++i) {
            Integer intI = (Integer)listFrequents.get(i);
            Map<Integer, Occurence> occurencesI = this.mapItemCount.get(intI);
            Set<Integer> tidsI = occurencesI.keySet();
            for (int j = i + 1; j < listFrequents.size(); ++j) {
                Rule rule;
                Integer intJ = (Integer)listFrequents.get(j);
                Map<Integer, Occurence> occurencesJ = this.mapItemCount.get(intJ);
                Set<Integer> tidsJ = occurencesJ.keySet();
                HashSet<Integer> tidsIJ = new HashSet<Integer>();
                HashSet<Integer> tidsJI = new HashSet<Integer>();
                for (Map.Entry<Integer, Occurence> entryOccI : occurencesI.entrySet()) {
                    Occurence occJ = occurencesJ.get(entryOccI.getKey());
                    if (occJ == null) continue;
                    if (occJ.firstItemset < entryOccI.getValue().lastItemset) {
                        tidsJI.add(entryOccI.getKey());
                    }
                    if (entryOccI.getValue().firstItemset >= occJ.lastItemset) continue;
                    tidsIJ.add(entryOccI.getKey());
                }
                if (tidsIJ.size() >= this.minsuppRelative) {
                    double confIJ = (double)tidsIJ.size() / (double)occurencesI.size();
                    int[] itemsetI = new int[]{intI};
                    int[] itemsetJ = new int[]{intJ};
                    if (confIJ >= minConfidence) {
                        this.saveRule(tidsIJ, confIJ, itemsetI, itemsetJ);
                        if (this.DEBUG) {
                            rule = new Rule(itemsetI, itemsetJ, tidsI, tidsJ, tidsIJ, occurencesI, occurencesJ);
                            allRulesFoundForDEBUG.add(rule);
                        }
                    }
                    if (itemsetI.length < this.maxAntecedentSize) {
                        this.expandLeft(itemsetI, itemsetJ, tidsI, tidsIJ, occurencesJ);
                    }
                    if (itemsetJ.length < this.maxConsequentSize) {
                        this.expandRight(itemsetI, itemsetJ, tidsI, tidsJ, tidsIJ, occurencesI, occurencesJ);
                    }
                }
                if (tidsJI.size() < this.minsuppRelative) continue;
                int[] itemsetI = new int[]{intI};
                int[] itemsetJ = new int[]{intJ};
                double confJI = (double)tidsJI.size() / (double)occurencesJ.size();
                if (confJI >= minConfidence) {
                    this.saveRule(tidsJI, confJI, itemsetJ, itemsetI);
                    if (this.DEBUG) {
                        rule = new Rule(itemsetJ, itemsetI, tidsJ, tidsI, tidsJI, occurencesJ, occurencesI);
                        allRulesFoundForDEBUG.add(rule);
                    }
                }
                if (itemsetI.length < this.maxConsequentSize) {
                    this.expandRight(itemsetJ, itemsetI, tidsJ, tidsI, tidsJI, occurencesJ, occurencesI);
                }
                if (itemsetJ.length >= this.maxAntecedentSize) continue;
                this.expandLeft(itemsetJ, itemsetI, tidsJ, tidsJI, occurencesI);
            }
        }
        if (this.DEBUG) {
            for (i = 0; i < allRulesFoundForDEBUG.size(); ++i) {
                for (int j = i + 1; j < allRulesFoundForDEBUG.size(); ++j) {
                    Rule rule1 = allRulesFoundForDEBUG.get(i);
                    Rule rule2 = allRulesFoundForDEBUG.get(j);
                    Arrays.sort(rule1.itemsetI);
                    Arrays.sort(rule1.itemsetJ);
                    Arrays.sort(rule2.itemsetI);
                    Arrays.sort(rule2.itemsetJ);
                    if (!Arrays.equals(rule1.itemsetI, rule2.itemsetI) || !Arrays.equals(rule1.itemsetJ, rule2.itemsetJ)) continue;
                    throw new RuntimeException(" DUPLICATE RULES FOUND");
                }
            }
        }
        this.timeEnd = System.currentTimeMillis();
        this.writer.close();
        this.database = null;
    }

    private void saveRule(Set<Integer> tidsIJ, double confIJ, int[] itemsetI, int[] itemsetJ) throws IOException {
        int i;
        ++this.ruleCount;
        StringBuilder buffer = new StringBuilder();
        for (i = 0; i < itemsetI.length; ++i) {
            buffer.append(itemsetI[i]);
            if (i == itemsetI.length - 1) continue;
            buffer.append(",");
        }
        buffer.append(" ==> ");
        for (i = 0; i < itemsetJ.length; ++i) {
            buffer.append(itemsetJ[i]);
            if (i == itemsetJ.length - 1) continue;
            buffer.append(",");
        }
        buffer.append(" #SUP: ");
        buffer.append(tidsIJ.size());
        buffer.append(" #CONF: ");
        buffer.append(confIJ);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void expandLeft(int[] itemsetI, int[] itemsetJ, Collection<Integer> tidsI, Collection<Integer> tidsIJ, Map<Integer, Occurence> occurencesJ) throws IOException {
        HashMap<Integer, HashSet<Integer>> frequentItemsC = new HashMap<Integer, HashSet<Integer>>();
        int left = tidsIJ.size();
        for (Integer n : tidsIJ) {
            Sequence sequence = this.database.getSequences().get(n);
            Occurence end = occurencesJ.get(n);
            block1: for (int k = 0; k < end.lastItemset; ++k) {
                List<Integer> itemset2 = sequence.get(k);
                for (int m = 0; m < itemset2.size(); ++m) {
                    Integer itemC = itemset2.get(m);
                    if (this.containsLEXPlus(itemsetI, itemC) || this.containsLEX(itemsetJ, itemC)) continue;
                    HashSet<Integer> tidsItemC = (HashSet<Integer>)frequentItemsC.get(itemC);
                    if (tidsItemC == null) {
                        if (left < this.minsuppRelative) {
                            continue block1;
                        }
                    } else if (tidsItemC.size() + left < this.minsuppRelative) {
                        tidsItemC.remove(itemC);
                        continue block1;
                    }
                    if (tidsItemC == null) {
                        tidsItemC = new HashSet<Integer>(tidsIJ.size());
                        frequentItemsC.put(itemC, tidsItemC);
                    }
                    tidsItemC.add(n);
                }
            }
            --left;
        }
        for (Map.Entry entry : frequentItemsC.entrySet()) {
            Integer itemC = (Integer)entry.getKey();
            Set tidsIC_J = (Set)entry.getValue();
            if (tidsIC_J.size() < this.minsuppRelative) continue;
            HashSet<Integer> tidsIC = new HashSet<Integer>(tidsI.size());
            for (Integer tid : tidsI) {
                if (!this.mapItemCount.get(itemC).containsKey(tid)) continue;
                tidsIC.add(tid);
            }
            double confIC_J = (double)tidsIC_J.size() / (double)tidsIC.size();
            int[] itemsetIC = new int[itemsetI.length + 1];
            System.arraycopy(itemsetI, 0, itemsetIC, 0, itemsetI.length);
            itemsetIC[itemsetI.length] = itemC;
            if (confIC_J >= this.minConfidence) {
                this.saveRule(tidsIC_J, confIC_J, itemsetIC, itemsetJ);
                if (this.DEBUG) {
                    Rule newRule = new Rule(itemsetIC, itemsetJ, tidsIC, null, tidsIC_J, null, occurencesJ);
                    allRulesFoundForDEBUG.add(newRule);
                }
            }
            if (itemsetI.length >= this.maxAntecedentSize) continue;
            this.expandLeft(itemsetIC, itemsetJ, tidsIC, tidsIC_J, occurencesJ);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void expandRight(int[] itemsetI, int[] itemsetJ, Set<Integer> tidsI, Collection<Integer> tidsJ, Collection<Integer> tidsIJ, Map<Integer, Occurence> occurencesI, Map<Integer, Occurence> occurencesJ) throws IOException {
        HashMap<Integer, HashSet<Integer>> frequentItemsC = new HashMap<Integer, HashSet<Integer>>();
        int left = tidsIJ.size();
        for (Integer n : tidsIJ) {
            Sequence sequence = this.database.getSequences().get(n);
            Occurence first = occurencesI.get(n);
            for (int k = first.firstItemset + 1; k < sequence.size(); ++k) {
                List<Integer> itemset2 = sequence.get(k);
                for (int m = 0; m < itemset2.size(); ++m) {
                    Integer itemC = itemset2.get(m);
                    if (this.containsLEX(itemsetI, itemC) || this.containsLEXPlus(itemsetJ, itemC)) continue;
                    HashSet<Integer> tidsItemC = (HashSet<Integer>)frequentItemsC.get(itemC);
                    if (tidsItemC == null) {
                        if (left < this.minsuppRelative) {
                            continue;
                        }
                    } else if (tidsItemC.size() + left < this.minsuppRelative) {
                        tidsItemC.remove(itemC);
                        continue;
                    }
                    if (tidsItemC == null) {
                        tidsItemC = new HashSet<Integer>(tidsIJ.size());
                        frequentItemsC.put(itemC, tidsItemC);
                    }
                    tidsItemC.add(n);
                }
            }
            --left;
        }
        for (Map.Entry entry : frequentItemsC.entrySet()) {
            Integer itemC = (Integer)entry.getKey();
            Set tidsI_JC = (Set)entry.getValue();
            if (tidsI_JC.size() < this.minsuppRelative) continue;
            HashSet<Integer> tidsJC = new HashSet<Integer>(tidsJ.size());
            HashMap<Integer, Occurence> occurencesJC = new HashMap<Integer, Occurence>();
            for (Integer tid : tidsJ) {
                Occurence occurenceC = this.mapItemCount.get(itemC).get(tid);
                if (occurenceC == null) continue;
                tidsJC.add(tid);
                Occurence occurenceJ = occurencesJ.get(tid);
                if (occurenceC.lastItemset < occurenceJ.lastItemset) {
                    occurencesJC.put(tid, occurenceC);
                    continue;
                }
                occurencesJC.put(tid, occurenceJ);
            }
            double confI_JC = (double)tidsI_JC.size() / (double)tidsI.size();
            int[] itemsetJC = new int[itemsetJ.length + 1];
            System.arraycopy(itemsetJ, 0, itemsetJC, 0, itemsetJ.length);
            itemsetJC[itemsetJ.length] = itemC;
            if (confI_JC >= this.minConfidence) {
                this.saveRule(tidsI_JC, confI_JC, itemsetI, itemsetJC);
                if (this.DEBUG) {
                    Rule newRule = new Rule(itemsetI, itemsetJC, tidsI, tidsJC, tidsI_JC, occurencesI, occurencesJC);
                    allRulesFoundForDEBUG.add(newRule);
                }
            }
            if (itemsetJC.length < this.maxConsequentSize) {
                this.expandRight(itemsetI, itemsetJC, tidsI, tidsJC, tidsI_JC, occurencesI, occurencesJC);
            }
            if (itemsetI.length >= this.maxAntecedentSize) continue;
            this.expandLeft(itemsetI, itemsetJC, tidsI, tidsI_JC, occurencesJC);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private Map<Integer, Map<Integer, Occurence>> removeItemsThatAreNotFrequent(SequenceDatabase database) {
        List<Integer> itemset2;
        this.mapItemCount = new HashMap<Integer, Map<Integer, Occurence>>();
        for (int k = 0; k < database.size(); ++k) {
            Sequence sequence = database.getSequences().get(k);
            for (short j = 0; j < sequence.getItemsets().size(); j = (short)((short)(j + 1))) {
                itemset2 = sequence.get(j);
                for (int i = 0; i < itemset2.size(); ++i) {
                    Occurence occurence;
                    Integer itemI = itemset2.get(i);
                    Map<Integer, Occurence> occurences = this.mapItemCount.get(itemI);
                    if (occurences == null) {
                        occurences = new HashMap<Integer, Occurence>();
                        this.mapItemCount.put(itemI, occurences);
                    }
                    if ((occurence = occurences.get(k)) == null) {
                        occurence = new Occurence(j, j);
                        occurences.put(k, occurence);
                        continue;
                    }
                    occurence.lastItemset = j;
                }
            }
        }
        for (Sequence sequence : database.getSequences()) {
            for (int i = 0; i < sequence.getItemsets().size(); ++i) {
                itemset2 = sequence.getItemsets().get(i);
                int j = 0;
                while (j < itemset2.size()) {
                    if (this.mapItemCount.get(itemset2.get(j)).size() < this.minsuppRelative) {
                        itemset2.remove(j);
                        continue;
                    }
                    ++j;
                }
            }
        }
        return this.mapItemCount;
    }

    boolean containsLEXPlus(int[] itemset2, int item) {
        for (int i = 0; i < itemset2.length; ++i) {
            if (itemset2[i] == item) {
                return true;
            }
            if (itemset2[i] <= item) continue;
            return true;
        }
        return false;
    }

    boolean containsLEX(int[] itemset2, int item) {
        for (int i = 0; i < itemset2.length; ++i) {
            if (itemset2[i] == item) {
                return true;
            }
            if (itemset2[i] <= item) continue;
            return false;
        }
        return false;
    }

    public void setMaxAntecedentSize(int maxAntecedentSize) {
        this.maxAntecedentSize = maxAntecedentSize;
    }

    public void setMaxConsequentSize(int maxConsequentSize) {
        this.maxConsequentSize = maxConsequentSize;
    }

    public void printStats() {
        System.out.println("=============  RULEGROWTH - STATS ========");
        System.out.println("Sequential rules count: " + this.ruleCount);
        System.out.println("Total time: " + (this.timeEnd - this.timeStart) + " ms");
        System.out.println("Max memory: " + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("==========================================");
    }
}

