/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.topseqrules_and_tns;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.sequential_rules.topseqrules_and_tns.Rule;
import ca.pfv.spmf.datastructures.redblacktree.RedBlackTree;
import ca.pfv.spmf.input.sequence_database_array_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AlgoTNS {
    long timeStart = 0L;
    long timeEnd = 0L;
    double minConfidence;
    double delta;
    double initialK;
    SequenceDatabase database;
    int minsuppRelative;
    int k = 0;
    RedBlackTree<Rule> kRules;
    RedBlackTree<Rule> candidates;
    int maxCandidateCount = 0;
    Map<Integer, Short>[] arrayMapItemCountFirst;
    Map<Integer, Short>[] arrayMapItemCountLast;
    private int totalremovedCount;
    private int notAdded;
    int maxAntecedentSize = Integer.MAX_VALUE;
    int maxConsequentSize = Integer.MAX_VALUE;

    public RedBlackTree<Rule> runAlgorithm(int k, SequenceDatabase database, double minConfidence, int delta) {
        this.delta = delta;
        this.database = database;
        this.minConfidence = minConfidence;
        this.initialK = k;
        this.k = k + delta;
        MemoryLogger.getInstance().reset();
        this.maxCandidateCount = 0;
        this.totalremovedCount = 0;
        this.notAdded = 0;
        this.minsuppRelative = 1;
        this.arrayMapItemCountFirst = new Map[database.maxItem + 1];
        this.arrayMapItemCountLast = new Map[database.maxItem + 1];
        this.kRules = new RedBlackTree();
        this.candidates = new RedBlackTree();
        this.timeStart = System.currentTimeMillis();
        if (this.maxAntecedentSize >= 1 && this.maxConsequentSize >= 1) {
            this.scanDatabase(database);
            this.start();
            this.cleanResult();
        }
        this.timeEnd = System.currentTimeMillis();
        return this.kRules;
    }

    private void cleanResult() {
        while ((double)this.kRules.size() > this.initialK) {
            this.kRules.popMinimum();
        }
        this.minsuppRelative = this.kRules.minimum().getAbsoluteSupport();
    }

    private void start() {
        Rule rule;
        for (int itemI = this.database.minItem; itemI <= this.database.maxItem; ++itemI) {
            Set<Integer> tidsI;
            Map<Integer, Short> occurrencesIfirst = this.arrayMapItemCountFirst[itemI];
            if (occurrencesIfirst == null || (tidsI = occurrencesIfirst.keySet()).size() < this.minsuppRelative) continue;
            block1: for (int itemJ = itemI + 1; itemJ <= this.database.maxItem; ++itemJ) {
                int supJI;
                int supIJ;
                int left;
                Set<Integer> tidsJ;
                Map<Integer, Short> occurrencesJfirst = this.arrayMapItemCountFirst[itemJ];
                if (occurrencesJfirst == null || (tidsJ = occurrencesJfirst.keySet()).size() < this.minsuppRelative) continue;
                HashSet<Integer> tidsIJ = new HashSet<Integer>();
                HashSet<Integer> tidsJI = new HashSet<Integer>();
                Map<Integer, Short> occurrencesJlast = this.arrayMapItemCountLast[itemJ];
                Map<Integer, Short> occurrencesIlast = this.arrayMapItemCountLast[itemI];
                if (tidsI.size() > tidsJ.size()) {
                    left = tidsJ.size();
                    for (Integer tid : occurrencesJfirst.keySet()) {
                        Short occIFirst = occurrencesIfirst.get(tid);
                        if (occIFirst != null) {
                            Short occJFirst = occurrencesJfirst.get(tid);
                            Short occJLast = occurrencesJlast.get(tid);
                            if (occIFirst < occJLast) {
                                tidsIJ.add(tid);
                            }
                            Short occILast = occurrencesIlast.get(tid);
                            if (occJFirst < occILast) {
                                tidsJI.add(tid);
                            }
                        }
                        if (--left + tidsIJ.size() >= this.minsuppRelative || left + tidsJI.size() >= this.minsuppRelative) continue;
                        continue block1;
                    }
                } else {
                    left = tidsI.size();
                    for (Integer tid : occurrencesIfirst.keySet()) {
                        Short occJFirst = occurrencesJfirst.get(tid);
                        if (occJFirst != null) {
                            Short occIFirst = occurrencesIfirst.get(tid);
                            Short occILast = occurrencesIlast.get(tid);
                            if (occJFirst < occILast) {
                                tidsJI.add(tid);
                            }
                            Short occJLast = occurrencesJlast.get(tid);
                            if (occIFirst < occJLast) {
                                tidsIJ.add(tid);
                            }
                        }
                        if (--left + tidsIJ.size() >= this.minsuppRelative || left + tidsJI.size() >= this.minsuppRelative) continue;
                        continue block1;
                    }
                }
                if ((supIJ = tidsIJ.size()) >= this.minsuppRelative) {
                    double confIJ = (double)tidsIJ.size() / (double)occurrencesIfirst.size();
                    int[] itemsetI = new int[]{itemI};
                    int[] itemsetJ = new int[]{itemJ};
                    Rule ruleIJ = new Rule(itemsetI, itemsetJ, confIJ, supIJ, tidsI, tidsJ, tidsIJ, occurrencesIfirst, occurrencesJlast);
                    if (confIJ >= this.minConfidence) {
                        this.save(ruleIJ, supIJ);
                    }
                    if (ruleIJ.getItemset1().length < this.maxAntecedentSize || ruleIJ.getItemset2().length < this.maxConsequentSize) {
                        this.registerAsCandidate(true, ruleIJ);
                    }
                }
                if ((supJI = tidsJI.size()) < this.minsuppRelative) continue;
                int[] itemsetI = new int[]{itemI};
                int[] itemsetJ = new int[]{itemJ};
                double confJI = (double)tidsJI.size() / (double)occurrencesJfirst.size();
                Rule ruleJI = new Rule(itemsetJ, itemsetI, confJI, supJI, tidsJ, tidsI, tidsJI, occurrencesJfirst, occurrencesIlast);
                if (confJI >= this.minConfidence) {
                    this.save(ruleJI, supJI);
                }
                if (ruleJI.getItemset1().length >= this.maxAntecedentSize && ruleJI.getItemset2().length >= this.maxConsequentSize) continue;
                this.registerAsCandidate(true, ruleJI);
            }
        }
        while (!this.candidates.isEmpty() && (rule = this.candidates.popMaximum()).getAbsoluteSupport() >= this.minsuppRelative) {
            if (rule.expandLR) {
                this.expandL(rule);
                this.expandR(rule);
                continue;
            }
            this.expandL(rule);
        }
    }

    private void save(Rule rule, int support) {
        RedBlackTree.Node lowerRuleNode = this.kRules.lowerNode(new Rule(null, null, 0.0, support + 1, null, null, null, null, null));
        HashSet<Rule> rulesToDelete = new HashSet<Rule>();
        while (lowerRuleNode != null && lowerRuleNode.key != null && ((Rule)lowerRuleNode.key).getAbsoluteSupport() == support) {
            if (rule.getConfidence() == ((Rule)lowerRuleNode.key).getConfidence() && this.subsume((Rule)lowerRuleNode.key, rule)) {
                ++this.notAdded;
                return;
            }
            if (rule.getConfidence() == ((Rule)lowerRuleNode.key).getConfidence() && this.subsume(rule, (Rule)lowerRuleNode.key)) {
                rulesToDelete.add((Rule)lowerRuleNode.key);
                ++this.totalremovedCount;
            }
            lowerRuleNode = this.kRules.lowerNode((Rule)lowerRuleNode.key);
        }
        for (Rule ruleX : rulesToDelete) {
            this.kRules.remove(ruleX);
        }
        this.kRules.add(rule);
        if (this.kRules.size() > this.k) {
            if (support > this.minsuppRelative) {
                Rule lower;
                while ((lower = this.kRules.lower(new Rule(null, null, 0.0, this.minsuppRelative + 1, null, null, null, null, null))) != null) {
                    this.kRules.remove(lower);
                    if (this.kRules.size() > this.k) continue;
                }
            }
            this.minsuppRelative = this.kRules.minimum().getAbsoluteSupport();
        }
    }

    private boolean subsume(Rule rule1, Rule rule2) {
        if (rule1.getItemset1().length <= rule2.getItemset1().length && rule1.getItemset2().length >= rule2.getItemset2().length) {
            boolean cond1 = this.containsOrEquals(rule2.getItemset1(), rule1.getItemset1());
            boolean cond2 = this.containsOrEquals(rule1.getItemset2(), rule2.getItemset2());
            return cond1 && cond2;
        }
        return false;
    }

    boolean containsOrEquals(int[] array1, int[] array2) {
        block0: for (int i = 0; i < array2.length; ++i) {
            for (int j = 0; j < array1.length; ++j) {
                if (array1[j] == array2[i]) continue block0;
                if (array1[j] <= array2[i]) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void registerAsCandidate(boolean expandLR, Rule ruleLR) {
        ruleLR.expandLR = expandLR;
        this.candidates.add(ruleLR);
        if (this.candidates.size() >= this.maxCandidateCount) {
            this.maxCandidateCount = this.candidates.size();
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void expandL(Rule rule) {
        if (rule.getItemset1().length == this.maxAntecedentSize) {
            return;
        }
        HashMap<Integer, HashSet<Integer>> frequentItemsC = new HashMap<Integer, HashSet<Integer>>();
        int left = rule.tidsIJ.size();
        for (Integer n : rule.tidsIJ) {
            Sequence sequence = this.database.getSequences().get(n);
            Short end = rule.occurrencesJlast.get(n);
            block1: for (int k = 0; k < end; ++k) {
                Integer[] itemset2 = sequence.get(k);
                for (int m = 0; m < itemset2.length; ++m) {
                    Integer itemC = itemset2[m];
                    if (ArraysAlgos.containsLEXPlus(rule.getItemset1(), itemC) || ArraysAlgos.containsLEX(rule.getItemset2(), itemC)) continue;
                    HashSet<Integer> tidsItemC = (HashSet<Integer>)frequentItemsC.get(itemC);
                    if (tidsItemC == null) {
                        if (left < this.minsuppRelative) {
                            continue block1;
                        }
                    } else if (tidsItemC.size() + left < this.minsuppRelative) {
                        tidsItemC.remove(itemC);
                        continue block1;
                    }
                    if (tidsItemC == null) {
                        tidsItemC = new HashSet<Integer>(rule.tidsIJ.size());
                        frequentItemsC.put(itemC, tidsItemC);
                    }
                    tidsItemC.add(n);
                }
            }
            --left;
        }
        for (Map.Entry entry : frequentItemsC.entrySet()) {
            Set tidsIC_J = (Set)entry.getValue();
            if (tidsIC_J.size() < this.minsuppRelative) continue;
            Integer itemC = (Integer)entry.getKey();
            HashSet<Integer> tidsIC = new HashSet<Integer>(rule.tidsI.size());
            for (Integer tid : rule.tidsI) {
                if (!this.arrayMapItemCountFirst[itemC].containsKey(tid)) continue;
                tidsIC.add(tid);
            }
            double confIC_J = (double)tidsIC_J.size() / (double)tidsIC.size();
            int[] itemsetIC = new int[rule.getItemset1().length + 1];
            System.arraycopy(rule.getItemset1(), 0, itemsetIC, 0, rule.getItemset1().length);
            itemsetIC[rule.getItemset1().length] = itemC;
            Rule candidate = new Rule(itemsetIC, rule.getItemset2(), confIC_J, tidsIC_J.size(), tidsIC, null, tidsIC_J, null, rule.occurrencesJlast);
            if (confIC_J >= this.minConfidence) {
                this.save(candidate, tidsIC_J.size());
            }
            this.registerAsCandidate(false, candidate);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void expandR(Rule rule) {
        if (rule.getItemset2().length == this.maxConsequentSize) {
            return;
        }
        HashMap<Integer, HashSet<Integer>> frequentItemsC = new HashMap<Integer, HashSet<Integer>>();
        int left = rule.tidsIJ.size();
        for (Integer n : rule.tidsIJ) {
            Sequence sequence = this.database.getSequences().get(n);
            Short first = rule.occurrencesIfirst.get(n);
            for (int k = first + 1; k < sequence.size(); ++k) {
                Integer[] itemset2 = sequence.get(k);
                for (int m = 0; m < itemset2.length; ++m) {
                    Integer itemC = itemset2[m];
                    if (ArraysAlgos.containsLEX(rule.getItemset1(), itemC) || ArraysAlgos.containsLEXPlus(rule.getItemset2(), itemC)) continue;
                    HashSet<Integer> tidsItemC = (HashSet<Integer>)frequentItemsC.get(itemC);
                    if (tidsItemC == null) {
                        if (left < this.minsuppRelative) {
                            continue;
                        }
                    } else if (tidsItemC.size() + left < this.minsuppRelative) {
                        tidsItemC.remove(itemC);
                        continue;
                    }
                    if (tidsItemC == null) {
                        tidsItemC = new HashSet<Integer>(rule.tidsIJ.size());
                        frequentItemsC.put(itemC, tidsItemC);
                    }
                    tidsItemC.add(n);
                }
            }
            --left;
        }
        for (Map.Entry entry : frequentItemsC.entrySet()) {
            Set tidsI_JC = (Set)entry.getValue();
            if (tidsI_JC.size() < this.minsuppRelative) continue;
            Integer itemC = (Integer)entry.getKey();
            HashSet<Integer> tidsJC = new HashSet<Integer>(rule.tidsJ.size());
            HashMap<Integer, Short> occurrencesJC = new HashMap<Integer, Short>();
            for (Integer tid : rule.tidsJ) {
                Short occurrenceCLast = this.arrayMapItemCountLast[itemC].get(tid);
                if (occurrenceCLast == null) continue;
                tidsJC.add(tid);
                Short occurrenceJlast = rule.occurrencesJlast.get(tid);
                if (occurrenceCLast < occurrenceJlast) {
                    occurrencesJC.put(tid, occurrenceCLast);
                    continue;
                }
                occurrencesJC.put(tid, occurrenceJlast);
            }
            double confI_JC = (double)tidsI_JC.size() / (double)rule.tidsI.size();
            int[] itemsetJC = new int[rule.getItemset2().length + 1];
            System.arraycopy(rule.getItemset2(), 0, itemsetJC, 0, rule.getItemset2().length);
            itemsetJC[rule.getItemset2().length] = itemC;
            Rule candidate = new Rule(rule.getItemset1(), itemsetJC, confI_JC, tidsI_JC.size(), rule.tidsI, tidsJC, tidsI_JC, rule.occurrencesIfirst, occurrencesJC);
            if (confI_JC >= this.minConfidence) {
                this.save(candidate, tidsI_JC.size());
            }
            this.registerAsCandidate(true, candidate);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void scanDatabase(SequenceDatabase database) {
        for (int tid = 0; tid < database.size(); ++tid) {
            Sequence sequence = database.getSequences().get(tid);
            for (short j = 0; j < sequence.getItemsets().size(); j = (short)((short)(j + 1))) {
                Integer[] itemset2 = sequence.get(j);
                for (int i = 0; i < itemset2.length; ++i) {
                    Short oldPosition;
                    Integer itemI = itemset2[i];
                    if (this.arrayMapItemCountFirst[itemI] == null) {
                        this.arrayMapItemCountFirst[itemI.intValue()] = new HashMap<Integer, Short>();
                        this.arrayMapItemCountLast[itemI.intValue()] = new HashMap<Integer, Short>();
                    }
                    if ((oldPosition = this.arrayMapItemCountFirst[itemI].get(tid)) == null) {
                        this.arrayMapItemCountFirst[itemI].put(tid, j);
                        this.arrayMapItemCountLast[itemI].put(tid, j);
                        continue;
                    }
                    this.arrayMapItemCountLast[itemI].put(tid, j);
                }
            }
        }
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        if (this.kRules.size() > 0) {
            for (Rule rule : this.kRules) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(rule.toString());
                buffer.append(" #SUP: ");
                buffer.append(rule.getAbsoluteSupport());
                buffer.append(" #CONF: ");
                buffer.append(rule.getConfidence());
                writer.write(buffer.toString());
                writer.newLine();
            }
        }
        writer.close();
    }

    public void printStats() {
        System.out.println("=============  TNS - STATS ========");
        System.out.println("Minsup : " + this.minsuppRelative);
        System.out.println("Rules count: " + this.kRules.size());
        System.out.println("Max candidates: " + this.maxCandidateCount);
        System.out.println("Sequential rules count: " + this.kRules.size());
        System.out.println("-");
        System.out.println("Total time: " + (double)(this.timeEnd - this.timeStart) / 1000.0 + " s");
        System.out.println("Max memory: " + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("Rules eliminated by strategy 1: " + this.notAdded);
        System.out.println("Rules eliminated by strategy 2: " + this.totalremovedCount);
    }

    public double getTotalTime() {
        return this.timeEnd - this.timeStart;
    }

    public void setMaxAntecedentSize(int maxAntecedentSize) {
        this.maxAntecedentSize = maxAntecedentSize;
    }

    public void setMaxConsequentSize(int maxConsequentSize) {
        this.maxConsequentSize = maxConsequentSize;
    }
}

