/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.topseqrules_and_tns;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.sequential_rules.topseqrules_and_tns.ClassRule;
import ca.pfv.spmf.datastructures.redblacktree.RedBlackTree;
import ca.pfv.spmf.input.sequence_database_array_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AlgoTopSeqClassRules {
    long timeStart = 0L;
    long timeEnd = 0L;
    double minConfidence;
    int k = 0;
    SequenceDatabase database;
    int minsuppRelative;
    RedBlackTree<ClassRule> kRules;
    RedBlackTree<ClassRule> candidates;
    int maxCandidateCount = 0;
    Map<Integer, Short>[] arrayMapItemCountFirst;
    Map<Integer, Short>[] arrayMapItemCountLast;
    int maxAntecedentSize = Integer.MAX_VALUE;
    int[] itemToBeUsedAsConsequent;

    public RedBlackTree<ClassRule> runAlgorithm(int k, SequenceDatabase database, double minConfidence, int[] itemToBeUsedAsConsequent) {
        this.database = database;
        this.minConfidence = minConfidence;
        this.k = k;
        this.itemToBeUsedAsConsequent = itemToBeUsedAsConsequent;
        MemoryLogger.getInstance().reset();
        this.maxCandidateCount = 0;
        this.minsuppRelative = 1;
        this.arrayMapItemCountFirst = new HashMap[database.maxItem + 1];
        this.arrayMapItemCountLast = new HashMap[database.maxItem + 1];
        this.kRules = new RedBlackTree();
        this.candidates = new RedBlackTree();
        this.timeStart = System.currentTimeMillis();
        if (this.maxAntecedentSize >= 1) {
            this.scanDatabase(database);
            this.start();
        }
        this.timeEnd = System.currentTimeMillis();
        return this.kRules;
    }

    private void start() {
        ClassRule rule;
        for (int itemI = this.database.minItem; itemI <= this.database.maxItem; ++itemI) {
            Set<Integer> tidsI;
            Map<Integer, Short> occurrencesIfirst = this.arrayMapItemCountFirst[itemI];
            if (occurrencesIfirst == null || (tidsI = occurrencesIfirst.keySet()).size() < this.minsuppRelative) continue;
            block1: for (int itemJ : this.itemToBeUsedAsConsequent) {
                int supIJ;
                Integer tid;
                int left;
                Set<Integer> tidsJ;
                Map<Integer, Short> occurrencesJfirst;
                if (itemJ == itemI || (occurrencesJfirst = this.arrayMapItemCountFirst[itemJ]) == null || (tidsJ = occurrencesJfirst.keySet()).size() < this.minsuppRelative) continue;
                HashSet<Integer> tidsIJ = new HashSet<Integer>();
                HashSet<Integer> tidsJI = new HashSet<Integer>();
                Map<Integer, Short> occurrencesJlast = this.arrayMapItemCountLast[itemJ];
                Map<Integer, Short> occurrencesIlast = this.arrayMapItemCountLast[itemI];
                if (tidsI.size() > tidsJ.size()) {
                    left = tidsJ.size();
                    for (Map.Entry<Integer, Short> entry : occurrencesJfirst.entrySet()) {
                        tid = entry.getKey();
                        Short occIFirst = occurrencesIfirst.get(tid);
                        if (occIFirst != null) {
                            Short occJFirst = occurrencesJfirst.get(tid);
                            Short occJLast = occurrencesJlast.get(tid);
                            if (occIFirst < occJLast) {
                                tidsIJ.add(tid);
                            }
                            Short occILast = occurrencesIlast.get(tid);
                            if (occJFirst < occILast) {
                                tidsJI.add(tid);
                            }
                        }
                        if (--left + tidsIJ.size() >= this.minsuppRelative || left + tidsJI.size() >= this.minsuppRelative) continue;
                        continue block1;
                    }
                } else {
                    left = tidsI.size();
                    for (Map.Entry<Integer, Short> entry : occurrencesIfirst.entrySet()) {
                        tid = entry.getKey();
                        Short occJFirst = occurrencesJfirst.get(tid);
                        if (occJFirst != null) {
                            Short occIFirst = occurrencesIfirst.get(tid);
                            Short occILast = occurrencesIlast.get(tid);
                            if (occJFirst < occILast) {
                                tidsJI.add(tid);
                            }
                            Short occJLast = occurrencesJlast.get(tid);
                            if (occIFirst < occJLast) {
                                tidsIJ.add(tid);
                            }
                        }
                        if (--left + tidsIJ.size() >= this.minsuppRelative || left + tidsJI.size() >= this.minsuppRelative) continue;
                        continue block1;
                    }
                }
                if ((supIJ = tidsIJ.size()) < this.minsuppRelative) continue;
                double confIJ = (double)tidsIJ.size() / (double)occurrencesIfirst.size();
                int[] itemsetI = new int[]{itemI};
                ClassRule ruleIJ = new ClassRule(itemsetI, itemJ, confIJ, supIJ, tidsI, tidsJ, tidsIJ, occurrencesJlast);
                if (confIJ >= this.minConfidence) {
                    this.save(ruleIJ, supIJ);
                }
                this.registerAsCandidate(ruleIJ);
            }
        }
        while (!this.candidates.isEmpty() && (rule = this.candidates.popMaximum()).getAbsoluteSupport() >= this.minsuppRelative) {
            this.expandL(rule);
        }
    }

    private void save(ClassRule rule, int support) {
        this.kRules.add(rule);
        if (this.kRules.size() > this.k) {
            if (support > this.minsuppRelative) {
                ClassRule lower;
                while ((lower = this.kRules.lower(new ClassRule(null, null, 0.0, this.minsuppRelative + 1, null, null, null, null))) != null) {
                    this.kRules.remove(lower);
                    if (this.kRules.size() > this.k) continue;
                }
            }
            this.minsuppRelative = this.kRules.minimum().getAbsoluteSupport();
        }
    }

    private void registerAsCandidate(ClassRule ruleLR) {
        this.candidates.add(ruleLR);
        if (this.candidates.size() >= this.maxCandidateCount) {
            this.maxCandidateCount = this.candidates.size();
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void expandL(ClassRule rule) {
        if (rule.getItemset1().length == this.maxAntecedentSize) {
            return;
        }
        HashMap<Integer, HashSet<Integer>> frequentItemsC = new HashMap<Integer, HashSet<Integer>>();
        int left = rule.tidsIJ.size();
        for (Integer n : rule.tidsIJ) {
            Sequence sequence = this.database.getSequences().get(n);
            Short end = rule.occurrencesJlast.get(n);
            block1: for (int k = 0; k < end; ++k) {
                Integer[] itemset2 = sequence.get(k);
                for (int m = 0; m < itemset2.length; ++m) {
                    Integer itemC = itemset2[m];
                    if (ArraysAlgos.containsLEXPlus(rule.getItemset1(), itemC) || rule.getItemset2() == itemC.intValue()) continue;
                    HashSet<Integer> tidsItemC = (HashSet<Integer>)frequentItemsC.get(itemC);
                    if (tidsItemC == null) {
                        if (left < this.minsuppRelative) {
                            continue block1;
                        }
                    } else if (tidsItemC.size() + left < this.minsuppRelative) {
                        tidsItemC.remove(itemC);
                        continue block1;
                    }
                    if (tidsItemC == null) {
                        tidsItemC = new HashSet<Integer>(rule.tidsIJ.size());
                        frequentItemsC.put(itemC, tidsItemC);
                    }
                    tidsItemC.add(n);
                }
            }
            --left;
        }
        for (Map.Entry entry : frequentItemsC.entrySet()) {
            Set tidsIC_J = (Set)entry.getValue();
            if (tidsIC_J.size() < this.minsuppRelative) continue;
            Integer itemC = (Integer)entry.getKey();
            HashSet<Integer> tidsIC = new HashSet<Integer>(rule.tidsI.size());
            for (Integer tid : rule.tidsI) {
                if (!this.arrayMapItemCountFirst[itemC].containsKey(tid)) continue;
                tidsIC.add(tid);
            }
            double confIC_J = (double)tidsIC_J.size() / (double)tidsIC.size();
            int[] itemsetIC = new int[rule.getItemset1().length + 1];
            System.arraycopy(rule.getItemset1(), 0, itemsetIC, 0, rule.getItemset1().length);
            itemsetIC[rule.getItemset1().length] = itemC;
            ClassRule candidate = new ClassRule(itemsetIC, rule.getItemset2(), confIC_J, tidsIC_J.size(), tidsIC, null, tidsIC_J, rule.occurrencesJlast);
            if (confIC_J >= this.minConfidence) {
                this.save(candidate, tidsIC_J.size());
            }
            this.registerAsCandidate(candidate);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void scanDatabase(SequenceDatabase database) {
        for (int tid = 0; tid < database.size(); ++tid) {
            Sequence sequence = database.getSequences().get(tid);
            for (short j = 0; j < sequence.getItemsets().size(); j = (short)((short)(j + 1))) {
                Integer[] itemset2 = sequence.get(j);
                for (int i = 0; i < itemset2.length; ++i) {
                    Short oldPosition;
                    Integer itemI = itemset2[i];
                    if (this.arrayMapItemCountFirst[itemI] == null) {
                        this.arrayMapItemCountFirst[itemI.intValue()] = new HashMap<Integer, Short>();
                        this.arrayMapItemCountLast[itemI.intValue()] = new HashMap<Integer, Short>();
                    }
                    if ((oldPosition = this.arrayMapItemCountFirst[itemI].get(tid)) == null) {
                        this.arrayMapItemCountFirst[itemI].put(tid, j);
                        this.arrayMapItemCountLast[itemI].put(tid, j);
                        continue;
                    }
                    this.arrayMapItemCountLast[itemI].put(tid, j);
                }
            }
        }
    }

    public void printStats() {
        System.out.println("=============  TOPSEQRULES - STATS ========");
        System.out.println("Max candidates: " + this.maxCandidateCount);
        System.out.println("Sequential rules count: " + this.kRules.size());
        System.out.println("-");
        System.out.println("Total time: " + (double)(this.timeEnd - this.timeStart) / 1000.0 + " s");
        System.out.println("Max memory: " + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("Minsup relative: " + this.minsuppRelative);
        System.out.println("==========================================");
    }

    public double getTotalTime() {
        return this.timeEnd - this.timeStart;
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        if (this.kRules.size() > 0) {
            for (ClassRule rule : this.kRules) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(rule.toString());
                buffer.append(" #SUP: ");
                buffer.append(rule.getAbsoluteSupport());
                buffer.append(" #CONF: ");
                buffer.append(rule.getConfidence());
                writer.write(buffer.toString());
                writer.newLine();
            }
        }
        writer.close();
    }

    public void setMaxAntecedentSize(int maxAntecedentSize) {
        this.maxAntecedentSize = maxAntecedentSize;
    }
}

