/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.topseqrules_and_tns;

import java.util.Map;
import java.util.Set;

public class ClassRule
implements Comparable<ClassRule> {
    private int[] itemset1;
    private Integer itemset2;
    int transactioncount;
    Set<Integer> tidsI;
    Set<Integer> tidsJ;
    Set<Integer> tidsIJ;
    Map<Integer, Short> occurrencesJlast;
    private double confidence;

    public ClassRule(int[] itemset1, Integer itemset2, double confidence, int transactioncount, Set<Integer> tidsI, Set<Integer> tidsJ, Set<Integer> tidsIJ, Map<Integer, Short> occurrencesJlast) {
        this.itemset1 = itemset1;
        this.itemset2 = itemset2;
        this.confidence = confidence;
        this.transactioncount = transactioncount;
        this.tidsI = tidsI;
        this.tidsJ = tidsJ;
        this.tidsIJ = tidsIJ;
        this.occurrencesJlast = occurrencesJlast;
    }

    public int[] getItemset1() {
        return this.itemset1;
    }

    public int getItemset2() {
        return this.itemset2;
    }

    public int getAbsoluteSupport() {
        return this.transactioncount;
    }

    public double getRelativeSupport(int sequencecount) {
        return (double)this.transactioncount / (double)sequencecount;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.itemset1.length; ++i) {
            buffer.append(this.itemset1[i]);
            if (i == this.itemset1.length - 1) continue;
            buffer.append(",");
        }
        buffer.append(" ==> ");
        buffer.append(this.itemset2);
        return buffer.toString();
    }

    public double getConfidence() {
        return this.confidence;
    }

    @Override
    public int compareTo(ClassRule o) {
        int itemset1sizeB;
        if (o == this) {
            return 0;
        }
        int compare = this.getAbsoluteSupport() - o.getAbsoluteSupport();
        if (compare != 0) {
            return compare;
        }
        int itemset1sizeA = this.itemset1 == null ? 0 : this.itemset1.length;
        int compare2 = itemset1sizeA - (itemset1sizeB = o.itemset1 == null ? 0 : o.itemset1.length);
        if (compare2 != 0) {
            return compare2;
        }
        int compare4 = Double.compare(this.confidence, o.confidence);
        if (compare4 != 0) {
            return compare4;
        }
        return this.hashCode() - o.hashCode();
    }

    public boolean equals(Object o) {
        ClassRule ruleX = (ClassRule)o;
        if (ruleX.itemset1.length != this.itemset1.length) {
            return false;
        }
        for (int i = 0; i < this.itemset1.length; ++i) {
            if (this.itemset1[i] == ruleX.itemset1[i]) continue;
            return false;
        }
        return this.itemset2 == ruleX.itemset2;
    }
}

