/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.trulegrowth_with_strings;

import ca.pfv.spmf.algorithms.sequential_rules.trulegrowth.Occurence;
import ca.pfv.spmf.input.sequence_database_list_strings.Sequence;
import ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoTRuleGrowth_withStrings {
    long timeStart = 0L;
    long timeEnd = 0L;
    Map<String, Map<Integer, Occurence>> mapItemCount;
    SequenceDatabase database;
    double minconf;
    int minsuppRelative;
    int windowSize = 0;
    int ruleCount;
    BufferedWriter writer = null;
    int maxAntecedentSize = Integer.MAX_VALUE;
    int maxConsequentSize = Integer.MAX_VALUE;

    public void runAlgorithm(double minSupport, double minConfidence, String input, String output, int windowSize) throws IOException {
        try {
            this.database = new SequenceDatabase();
            this.database.loadFile(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minsuppRelative = (int)Math.ceil(minSupport * (double)this.database.size());
        this.runAlgorithm(input, output, this.minsuppRelative, minConfidence, windowSize);
    }

    public void runAlgorithm(String input, String output, int relativeMinSupport, double minConfidence, int windowSize) throws IOException {
        this.minconf = minConfidence;
        if (this.database == null) {
            try {
                this.database = new SequenceDatabase();
                this.database.loadFile(input);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.windowSize = windowSize + 1;
        this.minsuppRelative = relativeMinSupport;
        if (this.minsuppRelative == 0) {
            this.minsuppRelative = 1;
        }
        MemoryLogger.getInstance().reset();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.timeStart = System.currentTimeMillis();
        this.removeItemsThatAreNotFrequent(this.database);
        ArrayList<String> listFrequents = new ArrayList<String>();
        for (Map.Entry<String, Map<Integer, Occurence>> entry : this.mapItemCount.entrySet()) {
            if (entry.getValue().size() < this.minsuppRelative) continue;
            listFrequents.add(entry.getKey());
        }
        for (int i = 0; i < listFrequents.size(); ++i) {
            String intI = (String)listFrequents.get(i);
            Map<Integer, Occurence> occurencesI = this.mapItemCount.get(intI);
            for (int j = i + 1; j < listFrequents.size(); ++j) {
                String[] itemset1;
                String intJ = (String)listFrequents.get(j);
                Map<Integer, Occurence> occurencesJ = this.mapItemCount.get(intJ);
                HashSet<Integer> tidsI = new HashSet<Integer>();
                HashSet<Integer> tidsJ = null;
                HashSet<Integer> tidsIJ = new HashSet<Integer>();
                HashSet<Integer> tidsJI = new HashSet<Integer>();
                block5: for (Occurence occI : occurencesI.values()) {
                    tidsI.add(occI.sequenceID);
                    Occurence occJ = occurencesJ.get(occI.sequenceID);
                    if (occJ == null) continue;
                    boolean addedIJ = false;
                    boolean addedJI = false;
                    for (Short posI : occI.occurences) {
                        for (Short posJ : occJ.occurences) {
                            if (posI.equals(posJ) || Math.abs(posI - posJ) > windowSize) continue;
                            if (posI <= posJ) {
                                tidsIJ.add(occI.sequenceID);
                                addedIJ = true;
                            } else {
                                tidsJI.add(occI.sequenceID);
                                addedJI = true;
                            }
                            if (!addedIJ || !addedJI) continue;
                            continue block5;
                        }
                    }
                }
                if (tidsIJ.size() >= this.minsuppRelative) {
                    double confIJ = (double)tidsIJ.size() / (double)occurencesI.size();
                    itemset1 = new String[]{intI};
                    String[] itemset2 = new String[]{intJ};
                    if (confIJ >= minConfidence) {
                        this.saveRule(tidsIJ, confIJ, itemset1, itemset2);
                    }
                    tidsJ = new HashSet<Integer>();
                    for (Occurence occJ : occurencesJ.values()) {
                        tidsJ.add(occJ.sequenceID);
                    }
                    if (itemset1.length < this.maxAntecedentSize) {
                        this.expandLeft(itemset1, itemset2, tidsI, tidsIJ);
                    }
                    if (itemset2.length < this.maxConsequentSize) {
                        this.expandRight(itemset1, itemset2, tidsI, tidsJ, tidsIJ);
                    }
                }
                if (tidsJI.size() < this.minsuppRelative) continue;
                double confJI = (double)tidsJI.size() / (double)occurencesJ.size();
                itemset1 = new String[]{intI};
                String[] itemset2 = new String[]{intJ};
                if (confJI >= minConfidence) {
                    this.saveRule(tidsJI, confJI, itemset2, itemset1);
                }
                if (tidsJ == null) {
                    tidsJ = new HashSet();
                    for (Occurence occJ : occurencesJ.values()) {
                        tidsJ.add(occJ.sequenceID);
                    }
                }
                if (itemset1.length < this.maxConsequentSize) {
                    this.expandRight(itemset2, itemset1, tidsJ, tidsI, tidsJI);
                }
                if (itemset2.length >= this.maxAntecedentSize) continue;
                this.expandLeft(itemset2, itemset1, tidsJ, tidsJI);
            }
        }
        this.timeEnd = System.currentTimeMillis();
        this.writer.close();
        this.database = null;
    }

    /*
     * WARNING - void declaration
     */
    private void expandLeft(String[] itemsetI, String[] itemsetJ, Collection<Integer> tidsI, Collection<Integer> tidsIJ) throws IOException {
        if (itemsetI.length == 2 && itemsetI[0].equals("a") && itemsetI[1].equals("b") && itemsetJ[0].equals("d")) {
            System.out.println();
        }
        HashMap<String, HashSet<Integer>> frequentItemsC = new HashMap<String, HashSet<Integer>>();
        for (Integer n : tidsIJ) {
            Sequence sequence = this.database.getSequences().get(n);
            LinkedHashMap<String, Integer> mapMostLeftFromI = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, Integer> mapMostLeftFromJ = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, LinkedList<Integer>> mapMostRightFromJ = new LinkedHashMap<String, LinkedList<Integer>>();
            int lastItemsetScannedForC = Integer.MAX_VALUE;
            int k = sequence.size() - 1;
            do {
                void var19_34;
                int fistElementOfWindow = k;
                int lastElementOfWindow = k + this.windowSize - 1;
                int previousJSize = mapMostLeftFromJ.size();
                this.removeElementOutsideWindow(mapMostLeftFromJ, lastElementOfWindow);
                int currentJSize = mapMostLeftFromJ.size();
                if (previousJSize == itemsetJ.length && previousJSize != currentJSize) {
                    mapMostLeftFromI.clear();
                }
                this.removeElementOutsideWindow(mapMostLeftFromI, lastElementOfWindow);
                for (String string : sequence.get(k)) {
                    if (mapMostLeftFromJ.size() == itemsetJ.length && this.contains(itemsetI, string)) {
                        this.addToLinked(mapMostLeftFromI, string, k);
                        continue;
                    }
                    if (!this.contains(itemsetJ, string)) continue;
                    this.addToLinked(mapMostLeftFromJ, string, k);
                    LinkedList<Integer> list = (LinkedList)mapMostRightFromJ.get(string);
                    if (list == null) {
                        list = new LinkedList<Integer>();
                        this.addToLinked(mapMostRightFromJ, string, list);
                    }
                    list.add(k);
                }
                if (mapMostLeftFromI.size() != itemsetI.length || mapMostLeftFromJ.size() != itemsetJ.length) continue;
                int minimum = Integer.MAX_VALUE;
                for (LinkedList<Integer> list : mapMostRightFromJ.values()) {
                    Integer last;
                    while ((last = (Integer)list.getLast()) > lastElementOfWindow) {
                        list.removeLast();
                    }
                    if (last >= minimum) continue;
                    minimum = last - 1;
                }
                int n2 = minimum;
                if (n2 >= lastItemsetScannedForC) {
                    int n3 = lastItemsetScannedForC - 1;
                }
                while (var19_34 >= fistElementOfWindow) {
                    for (String itemC : sequence.get((int)var19_34)) {
                        if (this.containsLEXPlus(itemsetI, itemC) || this.containsLEX(itemsetJ, itemC)) continue;
                        HashSet<Integer> tidsItemC = (HashSet<Integer>)frequentItemsC.get(itemC);
                        if (tidsItemC == null) {
                            tidsItemC = new HashSet<Integer>();
                            frequentItemsC.put(itemC, tidsItemC);
                        }
                        tidsItemC.add(n);
                    }
                    --var19_34;
                }
                lastItemsetScannedForC = fistElementOfWindow;
            } while (--k >= 0 && lastItemsetScannedForC > 0);
        }
        for (Map.Entry entry : frequentItemsC.entrySet()) {
            Set tidsIC_J = (Set)entry.getValue();
            if (tidsIC_J.size() < this.minsuppRelative) continue;
            String itemC = (String)entry.getKey();
            String[] itemsetIC = new String[itemsetI.length + 1];
            System.arraycopy(itemsetI, 0, itemsetIC, 0, itemsetI.length);
            itemsetIC[itemsetI.length] = itemC;
            if (itemC.equals("f") && itemsetIC[0].equals("a")) {
                System.out.println("6");
            }
            HashSet<Integer> tidsIC = new HashSet<Integer>();
            block8: for (Integer tid : tidsI) {
                Sequence sequence = this.database.getSequences().get(tid);
                LinkedHashMap<String, Integer> mapAlreadySeenFromIC = new LinkedHashMap<String, Integer>();
                for (int k = 0; k < sequence.size(); ++k) {
                    Map.Entry entryMap;
                    for (String item : sequence.get(k)) {
                        if (!this.contains(itemsetIC, item)) continue;
                        this.addToLinked(mapAlreadySeenFromIC, item, k);
                    }
                    Iterator iter = mapAlreadySeenFromIC.entrySet().iterator();
                    while (iter.hasNext() && (Integer)(entryMap = iter.next()).getValue() < k - this.windowSize + 1) {
                        iter.remove();
                    }
                    if (mapAlreadySeenFromIC.keySet().size() != itemsetIC.length) continue;
                    tidsIC.add(tid);
                    continue block8;
                }
            }
            double confIC_J = (double)tidsIC_J.size() / (double)tidsIC.size();
            if (confIC_J >= this.minconf) {
                this.saveRule(tidsIC_J, confIC_J, itemsetIC, itemsetJ);
            }
            if (itemsetIC.length >= this.maxConsequentSize) continue;
            this.expandLeft(itemsetIC, itemsetJ, tidsIC, tidsIC_J);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void addToLinked(LinkedHashMap<String, LinkedList<Integer>> mapMostLeftFromI, String key, LinkedList<Integer> value) {
        if (mapMostLeftFromI.containsKey(key)) {
            mapMostLeftFromI.remove(key);
        }
        mapMostLeftFromI.put(key, value);
    }

    private void addToLinked(LinkedHashMap<String, Integer> mapMostLeftFromI, String key, Integer value) {
        if (mapMostLeftFromI.containsKey(key)) {
            mapMostLeftFromI.remove(key);
        }
        mapMostLeftFromI.put(key, value);
    }

    private void removeElementOutsideWindow(LinkedHashMap<String, Integer> mapMostLeftFromI, int lastElementOfWindow) {
        Iterator<Map.Entry<String, Integer>> iter = mapMostLeftFromI.entrySet().iterator();
        while (iter.hasNext() && iter.next().getValue() > lastElementOfWindow) {
            iter.remove();
        }
    }

    private void removeElementOutsideWindowER(LinkedHashMap<String, Integer> mapMostRightfromI, int firstElementOfWindow) {
        Map.Entry<String, Integer> entry;
        Iterator<Map.Entry<String, Integer>> iter = mapMostRightfromI.entrySet().iterator();
        while (iter.hasNext() && (entry = iter.next()).getValue() < firstElementOfWindow) {
            iter.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void expandRight(String[] itemsetI, String[] itemsetJ, Set<Integer> tidsI, Collection<Integer> tidsJ, Collection<Integer> tidsIJ) throws IOException {
        HashMap<String, HashSet<Integer>> frequentItemsC = new HashMap<String, HashSet<Integer>>();
        for (Integer n : tidsIJ) {
            Sequence sequence = this.database.getSequences().get(n);
            LinkedHashMap<String, Integer> mapMostRightFromI = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, Integer> mapMostRightFromJ = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, LinkedList<Integer>> mapMostLeftFromI = new LinkedHashMap<String, LinkedList<Integer>>();
            int lastItemsetScannedForC = Integer.MIN_VALUE;
            int k = 0;
            do {
                void var20_35;
                int firstElementOfWindow = k - this.windowSize + 1;
                int lastElementOfWindow = k;
                int previousISize = mapMostRightFromI.size();
                this.removeElementOutsideWindowER(mapMostRightFromI, firstElementOfWindow);
                int currentISize = mapMostRightFromI.size();
                if (previousISize == itemsetJ.length && previousISize != currentISize) {
                    mapMostRightFromJ.clear();
                }
                this.removeElementOutsideWindowER(mapMostRightFromJ, firstElementOfWindow);
                for (String string : sequence.get(k)) {
                    if (mapMostRightFromI.size() == itemsetI.length && this.contains(itemsetJ, string)) {
                        this.addToLinked(mapMostRightFromJ, string, k);
                        continue;
                    }
                    if (!this.contains(itemsetI, string)) continue;
                    this.addToLinked(mapMostRightFromI, string, k);
                    LinkedList<Integer> list = (LinkedList)mapMostLeftFromI.get(string);
                    if (list == null) {
                        list = new LinkedList<Integer>();
                        this.addToLinked(mapMostLeftFromI, string, list);
                    }
                    list.add(k);
                }
                if (mapMostRightFromI.size() != itemsetI.length || mapMostRightFromJ.size() != itemsetJ.length) continue;
                int minimum = 1;
                for (LinkedList<Integer> list : mapMostLeftFromI.values()) {
                    Integer last;
                    while ((last = (Integer)list.getLast()) < firstElementOfWindow) {
                        list.removeLast();
                    }
                    if (last <= minimum) continue;
                    minimum = last + 1;
                }
                int n2 = minimum;
                if (n2 < lastItemsetScannedForC) {
                    int n3 = lastItemsetScannedForC + 1;
                }
                while (var20_35 <= lastElementOfWindow) {
                    for (String itemC : sequence.get((int)var20_35)) {
                        if (this.containsLEX(itemsetI, itemC) || this.containsLEXPlus(itemsetJ, itemC)) continue;
                        HashSet<Integer> tidsItemC = (HashSet<Integer>)frequentItemsC.get(itemC);
                        if (tidsItemC == null) {
                            tidsItemC = new HashSet<Integer>();
                            frequentItemsC.put(itemC, tidsItemC);
                        }
                        tidsItemC.add(n);
                    }
                    ++var20_35;
                }
                lastItemsetScannedForC = lastElementOfWindow;
            } while (++k < sequence.size() && lastItemsetScannedForC < sequence.size() - 1);
        }
        for (Map.Entry entry : frequentItemsC.entrySet()) {
            Set tidsI_JC = (Set)entry.getValue();
            if (tidsI_JC.size() < this.minsuppRelative) continue;
            String itemC = (String)entry.getKey();
            String[] itemsetJC = new String[itemsetJ.length + 1];
            System.arraycopy(itemsetJ, 0, itemsetJC, 0, itemsetJ.length);
            itemsetJC[itemsetJ.length] = itemC;
            HashSet<Integer> tidsJC = new HashSet<Integer>();
            block8: for (Integer tid : tidsJ) {
                Sequence sequence = this.database.getSequences().get(tid);
                LinkedHashMap<String, Integer> mapAlreadySeenFromJC = new LinkedHashMap<String, Integer>();
                for (int k = 0; k < sequence.size(); ++k) {
                    Map.Entry entryMap;
                    for (String item : sequence.get(k)) {
                        if (!this.contains(itemsetJC, item)) continue;
                        this.addToLinked(mapAlreadySeenFromJC, item, k);
                    }
                    Iterator iter = mapAlreadySeenFromJC.entrySet().iterator();
                    while (iter.hasNext() && (Integer)(entryMap = iter.next()).getValue() < k - this.windowSize + 1) {
                        iter.remove();
                    }
                    if (mapAlreadySeenFromJC.keySet().size() != itemsetJC.length) continue;
                    tidsJC.add(tid);
                    continue block8;
                }
            }
            double confI_JC = (double)tidsI_JC.size() / (double)tidsI.size();
            if (confI_JC >= this.minconf) {
                this.saveRule(tidsI_JC, confI_JC, itemsetI, itemsetJC);
            }
            if (itemsetJC.length < this.maxConsequentSize) {
                this.expandRight(itemsetI, itemsetJC, tidsI, tidsJC, tidsI_JC);
            }
            if (itemsetI.length >= this.maxAntecedentSize) continue;
            this.expandLeft(itemsetI, itemsetJC, tidsI, tidsI_JC);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private Map<String, Map<Integer, Occurence>> removeItemsThatAreNotFrequent(SequenceDatabase database) {
        List<String> itemset2;
        this.mapItemCount = new HashMap<String, Map<Integer, Occurence>>();
        for (Sequence sequence : database.getSequences()) {
            for (short j = 0; j < sequence.getItemsets().size(); j = (short)((short)(j + 1))) {
                itemset2 = sequence.get(j);
                for (int i = 0; i < itemset2.size(); ++i) {
                    Occurence occurence;
                    String itemI = itemset2.get(i);
                    Map<Integer, Occurence> occurences = this.mapItemCount.get(itemI);
                    if (occurences == null) {
                        occurences = new HashMap<Integer, Occurence>();
                        this.mapItemCount.put(itemI, occurences);
                    }
                    if ((occurence = occurences.get(sequence.getId())) == null) {
                        occurence = new Occurence(sequence.getId());
                        occurences.put(sequence.getId(), occurence);
                    }
                    occurence.add(j);
                }
            }
        }
        for (Sequence sequence : database.getSequences()) {
            for (int i = 0; i < sequence.getItemsets().size(); ++i) {
                itemset2 = sequence.getItemsets().get(i);
                int j = 0;
                while (j < itemset2.size()) {
                    double count = this.mapItemCount.get(itemset2.get(j)).size();
                    if (count < (double)this.minsuppRelative) {
                        itemset2.remove(j);
                        continue;
                    }
                    ++j;
                }
            }
        }
        return this.mapItemCount;
    }

    private void saveRule(Set<Integer> tidsIJ, double confIJ, String[] itemsetI, String[] itemsetJ) throws IOException {
        int i;
        ++this.ruleCount;
        StringBuilder buffer = new StringBuilder();
        for (i = 0; i < itemsetI.length; ++i) {
            buffer.append(itemsetI[i]);
            if (i == itemsetI.length - 1) continue;
            buffer.append(",");
        }
        buffer.append(" ==> ");
        for (i = 0; i < itemsetJ.length; ++i) {
            buffer.append(itemsetJ[i]);
            if (i == itemsetJ.length - 1) continue;
            buffer.append(",");
        }
        buffer.append(" #SUP: ");
        buffer.append(tidsIJ.size());
        buffer.append(" #CONF: ");
        buffer.append(confIJ);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    boolean contains(String[] itemset2, String item) {
        for (int i = 0; i < itemset2.length; ++i) {
            if (itemset2[i].equals(item)) {
                return true;
            }
            if (itemset2[i].compareTo(item) <= 0) continue;
            return false;
        }
        return false;
    }

    boolean containsLEXPlus(String[] itemset2, String item) {
        for (int i = 0; i < itemset2.length; ++i) {
            if (itemset2[i].equals(item)) {
                return true;
            }
            if (itemset2[i].compareTo(item) <= 0) continue;
            return true;
        }
        return false;
    }

    boolean containsLEX(String[] itemset2, String item) {
        for (int i = 0; i < itemset2.length; ++i) {
            if (itemset2[i].equals(item)) {
                return true;
            }
            if (itemset2[i].compareTo(item) <= 0) continue;
            return false;
        }
        return false;
    }

    public void setMaxAntecedentSize(int maxAntecedentSize) {
        this.maxAntecedentSize = maxAntecedentSize;
    }

    public void setMaxConsequentSize(int maxConsequentSize) {
        this.maxConsequentSize = maxConsequentSize;
    }

    public void printStats() {
        System.out.println("=============  TRULEGROWTH - STATS =============");
        System.out.println("Sequential rules count: " + this.ruleCount);
        System.out.println("Total time : " + (this.timeEnd - this.timeStart) + " ms");
        System.out.println("Max memory (mb)" + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("=====================================");
    }

    public double getTotalTime() {
        return this.timeEnd - this.timeStart;
    }
}

