/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan;

import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SequentialPattern
implements Comparable<SequentialPattern> {
    private final List<Itemset> itemsets;
    private Set<Integer> sequencesIds;
    private int itemCount = -1;

    public void setSequenceIDs(Set<Integer> sequencesIds) {
        this.sequencesIds = sequencesIds;
    }

    public SequentialPattern() {
        this.itemsets = new ArrayList<Itemset>();
    }

    public SequentialPattern(Itemset itemset2, Set<Integer> sequencesIds) {
        this.itemsets = new ArrayList<Itemset>();
        this.itemsets.add(itemset2);
        this.sequencesIds = sequencesIds;
    }

    public SequentialPattern(List<Itemset> itemsets, Set<Integer> sequencesIds) {
        this.itemsets = itemsets;
        this.sequencesIds = sequencesIds;
    }

    public String getRelativeSupportFormated(int sequencecount) {
        double relSupport = (double)this.sequencesIds.size() / (double)sequencecount;
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(relSupport);
    }

    public int getAbsoluteSupport() {
        return this.sequencesIds.size();
    }

    public void addItemset(Itemset itemset2) {
        this.itemsets.add(itemset2);
    }

    public SequentialPattern cloneSequence() {
        SequentialPattern sequence = new SequentialPattern();
        for (Itemset itemset2 : this.itemsets) {
            sequence.addItemset(itemset2.cloneItemSet());
        }
        return sequence;
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset2 : this.itemsets) {
            r.append('(');
            for (Integer item : itemset2.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append(')');
        }
        return r.append("    ").toString();
    }

    public String itemsetsToString() {
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset2 : this.itemsets) {
            r.append('{');
            for (Integer item : itemset2.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append('}');
        }
        return r.append("    ").toString();
    }

    public List<Itemset> getItemsets() {
        return this.itemsets;
    }

    public Itemset get(int index) {
        return this.itemsets.get(index);
    }

    public Integer getIthItem(int i) {
        for (int j = 0; j < this.itemsets.size(); ++j) {
            if (i < this.itemsets.get(j).size()) {
                return this.itemsets.get(j).get(i);
            }
            i -= this.itemsets.get(j).size();
        }
        return null;
    }

    public int size() {
        return this.itemsets.size();
    }

    public int getItemOccurencesTotalCount() {
        if (this.itemCount == -1) {
            this.itemCount = 0;
            for (Itemset itemset2 : this.itemsets) {
                this.itemCount += itemset2.size();
            }
        }
        return this.itemCount;
    }

    public Set<Integer> getSequenceIDs() {
        return this.sequencesIds;
    }

    @Override
    public int compareTo(SequentialPattern o) {
        if (o == this) {
            return 0;
        }
        int compare = this.getAbsoluteSupport() - o.getAbsoluteSupport();
        if (compare != 0) {
            return compare;
        }
        return this.hashCode() - o.hashCode();
    }
}

