/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.Itemset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SequentialPattern {
    private final List<Itemset> itemsets = new ArrayList<Itemset>();
    private int id;
    private Set<Integer> sequencesID = null;

    SequentialPattern(int id) {
        this.id = id;
    }

    public String getRelativeSupportFormated(int sequencecount) {
        double frequence = (double)this.sequencesID.size() / (double)sequencecount;
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(frequence);
    }

    public int getAbsoluteSupport() {
        return this.sequencesID.size();
    }

    void addItemset(Itemset itemset2) {
        this.itemsets.add(itemset2);
    }

    SequentialPattern cloneSequence() {
        SequentialPattern sequence = new SequentialPattern(this.getId());
        for (Itemset itemset2 : this.itemsets) {
            sequence.addItemset(itemset2.cloneItemSet());
        }
        return sequence;
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset2 : this.itemsets) {
            r.append('(');
            Iterator<String> iterator = itemset2.getItems().iterator();
            while (iterator.hasNext()) {
                String item;
                String string = item = iterator.next();
                r.append(string);
                r.append(' ');
            }
            r.append(')');
        }
        if (this.getSequencesID() != null) {
            r.append("  Sequence ID: ");
            for (Integer id : this.getSequencesID()) {
                r.append(id);
                r.append(' ');
            }
        }
        return r.append("    ").toString();
    }

    public String itemsetsToString() {
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset2 : this.itemsets) {
            Iterator<String> iterator = itemset2.getItems().iterator();
            while (iterator.hasNext()) {
                String item;
                String string = item = iterator.next();
                r.append(string);
                r.append(' ');
            }
            r.append('}');
        }
        return r.append("    ").toString();
    }

    public int getId() {
        return this.id;
    }

    public List<Itemset> getItemsets() {
        return this.itemsets;
    }

    public Itemset get(int index) {
        return this.itemsets.get(index);
    }

    public String getIthItem(int i) {
        for (int j = 0; j < this.itemsets.size(); ++j) {
            if (i < this.itemsets.get(j).size()) {
                return this.itemsets.get(j).get(i);
            }
            i -= this.itemsets.get(j).size();
        }
        return null;
    }

    public int size() {
        return this.itemsets.size();
    }

    public Set<Integer> getSequencesID() {
        return this.sequencesID;
    }

    void setSequencesID(Set<Integer> sequencesID) {
        this.sequencesID = sequencesID;
    }

    int getItemOccurencesTotalCount() {
        int count = 0;
        for (Itemset itemset2 : this.itemsets) {
            count += itemset2.size();
        }
        return count;
    }

    SequentialPattern cloneSequenceMinusItems(Map<String, Set<Integer>> mapSequenceID, double relativeMinSup) {
        SequentialPattern sequence = new SequentialPattern(this.getId());
        for (Itemset itemset2 : this.itemsets) {
            Itemset newItemset = itemset2.cloneItemSetMinusItems(mapSequenceID, relativeMinSup);
            if (newItemset.size() == 0) continue;
            sequence.addItemset(newItemset);
        }
        return sequence;
    }

    public void setID(int id2) {
        this.id = id2;
    }
}

