/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clofast;

import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.FastDataset;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.ListNode;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.SparseIdList;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.VerticalIdList;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree.ItemsetNode;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree.ItemsetTree;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree.SequenceNode;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree.SequenceTree;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AlgoFast {
    private FastDataset ds;
    private SequenceTree sequenceTree;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int patternCount = 0;
    float maxSup = Float.MAX_VALUE;

    private void run() {
        this.itemsetExtension();
        MemoryLogger.getInstance().checkMemory();
        this.sequenceTree = this.sequenceExtension();
    }

    public List<SequenceNode> getFrequentSequences() {
        return SequenceTree.visit(this.sequenceTree);
    }

    private void itemsetExtension() {
        ItemsetNode node;
        ItemsetTree tree = new ItemsetTree();
        ItemsetNode root = tree.getRoot();
        LinkedList<ItemsetNode> queue = new LinkedList<ItemsetNode>();
        int pos = 0;
        for (Map.Entry<String, SparseIdList> entry : this.ds.getFrequentItemsets().entrySet()) {
            node = tree.addChild(root, new Itemset(entry.getKey()), entry.getValue(), pos++);
            queue.add(node);
        }
        while (!queue.isEmpty()) {
            node = (ItemsetNode)queue.remove();
            this.itemsetExtension(tree, node);
            queue.addAll(node.getChildren());
        }
    }

    private void itemsetExtension(ItemsetTree tree, ItemsetNode n) {
        int pos = 0;
        List<ItemsetNode> children = n.getParent().getChildren();
        for (int i = n.getPosition() + 1; i < children.size(); ++i) {
            ItemsetNode rightBrother = children.get(i);
            SparseIdList sil = SparseIdList.IStep(n.getSil(), rightBrother.getSil());
            if (sil.getAbsoluteSupport() < this.ds.getAbsMinSup() || sil.getAbsoluteSupport() > this.ds.getAbsMaxSup()) continue;
            Itemset newItemset = n.getItemset().clone();
            newItemset.addItem(rightBrother.getItemset().getLast());
            this.ds.getFrequentItemsets().put(newItemset.concatenate(), sil);
            tree.addChild(n, newItemset, sil, pos);
            ++pos;
        }
    }

    private SequenceTree sequenceExtension() {
        SequenceNode node;
        this.sequenceTree = new SequenceTree(this.ds.getNumRows());
        LinkedList<SequenceNode> queue = new LinkedList<SequenceNode>();
        for (Map.Entry<String, SparseIdList> entry : this.ds.getFrequentItemsets().entrySet()) {
            Sequence s = new Sequence(new Itemset(entry.getKey().split(" ")));
            VerticalIdList vil = entry.getValue().getStartingVIL();
            node = this.sequenceTree.addChild(this.sequenceTree.getRoot(), s, vil, entry.getValue().getAbsoluteSupport());
            queue.add(node);
        }
        while (!queue.isEmpty()) {
            node = (SequenceNode)queue.remove();
            this.sequenceExtension(this.sequenceTree, node);
            queue.addAll(node.getChildren());
        }
        return this.sequenceTree;
    }

    private void sequenceExtension(SequenceTree tree, SequenceNode node) {
        int count = 0;
        VerticalIdList vilNode = node.getVerticalIdList();
        List<SequenceNode> brothers = node.getParent().getChildren();
        for (SequenceNode brotherNode : brothers) {
            ListNode[] newPosList = new ListNode[vilNode.getElements().length];
            VerticalIdList vilBrother = brotherNode.getVerticalIdList();
            for (int i = 0; i < vilNode.getElements().length; ++i) {
                ListNode listNodeBrother;
                ListNode listNode = vilNode.getElements()[i];
                if (listNode == null || listNodeBrother == null) continue;
                if (listNode.getColumn() < listNodeBrother.getColumn()) {
                    newPosList[i] = listNodeBrother;
                    ++count;
                    continue;
                }
                if (listNode.getColumn() < listNodeBrother.getColumn()) continue;
                for (listNodeBrother = vilBrother.getElements()[i]; listNodeBrother != null && listNode.getColumn() >= listNodeBrother.getColumn(); listNodeBrother = listNodeBrother.next()) {
                }
                if (listNodeBrother == null) continue;
                newPosList[i] = listNodeBrother;
                ++count;
            }
            if (count >= this.ds.getAbsMinSup() && count <= this.ds.getAbsMaxSup()) {
                Sequence sequence = node.getSequence().clone();
                sequence.add(brotherNode.getSequence().getLastItemset());
                tree.addChild(node, sequence, new VerticalIdList(newPosList, count), count);
            }
            count = 0;
        }
    }

    private void writePatterns(Path outputFile) throws IOException {
        BufferedWriter out = Files.newBufferedWriter(outputFile, new OpenOption[0]);
        List<SequenceNode> nodes = this.getFrequentSequences();
        for (SequenceNode node : nodes) {
            out.write(node.toString() + System.lineSeparator());
        }
        out.flush();
        out.close();
        this.patternCount = nodes.size();
    }

    public void runAlgorithm(String inputFile, String outputPath, float minsup) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        this.ds = FastDataset.fromPrefixspanSource(inputFile, minsup, this.maxSup);
        this.run();
        this.writePatterns(Paths.get(outputPath, new String[0]));
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void runAlgorithm(FastDataset dataset, String outputPath, float minsup) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        this.ds = dataset;
        this.run();
        this.writePatterns(Paths.get(outputPath, new String[0]));
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  Algorithm Fast v2.29 - STATISTICS =============\n");
        r.append("Pattern count : ");
        r.append(this.patternCount);
        r.append('\n');
        r.append("Total time: ");
        r.append((float)(this.endTimestamp - this.startTimestamp) / 1000.0f);
        r.append(" s \n");
        r.append("Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append('\n');
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public void setMaximumSupport(float maxSup) {
        this.maxSup = maxSup;
    }
}

