/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clofast;

import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.SparseIdList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class FastDataset {
    public static final String ITEMSET_SEPARATOR = "-1";
    public static final String SEQUENCE_SEPARATOR = "-2";
    private Map<String, SparseIdList> itemSILMap = new HashMap<String, SparseIdList>();
    private final long numRows;
    private final float minSup;
    private final float maxSup;
    private int absMinSup;
    private int absMaxSup;

    private FastDataset(long numRows, float minSup) {
        this.numRows = numRows;
        this.minSup = minSup;
        this.maxSup = 1.0f;
        this.absMinSup = this.absoluteSupport(minSup, numRows);
        if (this.absMinSup == 0) {
            this.absMinSup = 1;
        }
        this.absMaxSup = (int)numRows;
    }

    private FastDataset(long numRows, float minSup, float maxSup) {
        this.numRows = numRows;
        this.minSup = minSup;
        this.maxSup = maxSup;
        this.absMinSup = this.absoluteSupport(minSup, numRows);
        if (this.absMinSup == 0) {
            this.absMinSup = 1;
        }
        this.absMaxSup = this.absoluteSupport(maxSup, numRows);
        if (this.absMaxSup == 0) {
            this.absMaxSup = 1;
        }
    }

    private void computeFrequentItems() {
        TreeMap<String, SparseIdList> newMap = new TreeMap<String, SparseIdList>();
        this.itemSILMap.forEach((item, sparseIdList) -> {
            if (sparseIdList.getAbsoluteSupport() >= this.absMinSup && sparseIdList.getAbsoluteSupport() <= this.absMaxSup) {
                newMap.put((String)item, (SparseIdList)sparseIdList);
            }
        });
        this.itemSILMap = newMap;
    }

    public Map<String, SparseIdList> getFrequentItemsets() {
        return this.itemSILMap;
    }

    public SparseIdList getSparseIdList(String item) {
        return this.itemSILMap.get(item);
    }

    public long getNumRows() {
        return this.numRows;
    }

    public int getAbsMinSup() {
        return this.absMinSup;
    }

    public int getAbsMaxSup() {
        return this.absMaxSup;
    }

    public static FastDataset fromPrefixspanSource(String path, float relativeMinSupport, float relativeMaxSupport) throws IOException {
        String line;
        long numRows = 0L;
        LineNumberReader lnr = new LineNumberReader(new FileReader(new File(path)));
        while ((line = lnr.readLine()) != null) {
            if (line.isEmpty() || line.startsWith("#") || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            ++numRows;
        }
        lnr.close();
        FastDataset fastDataset = new FastDataset(numRows, relativeMinSupport, relativeMaxSupport);
        int lineNumber = 0;
        FileInputStream fin = new FileInputStream(new File(path));
        BufferedReader in = new BufferedReader(new InputStreamReader(fin));
        while ((line = in.readLine()) != null) {
            if (line.isEmpty() || line.startsWith("#") || line.charAt(0) == '%' || line.charAt(0) == '@' || line.length() == 0) continue;
            int transID = 1;
            StringTokenizer tokenizer = new StringTokenizer(line);
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                if (token.equals(ITEMSET_SEPARATOR)) {
                    ++transID;
                    continue;
                }
                if (token.equals(SEQUENCE_SEPARATOR)) break;
                SparseIdList inserted = fastDataset.itemSILMap.putIfAbsent(token, new SparseIdList((int)numRows));
                fastDataset.itemSILMap.get(token).addElement(lineNumber, transID);
            }
            ++lineNumber;
        }
        in.close();
        fastDataset.computeFrequentItems();
        return fastDataset;
    }

    public static FastDataset fromPrefixspanSource(Path path, float relativeMinSupport, float relativeMaxSupport) throws IOException {
        String line;
        long numRows = Files.lines(path).count();
        FastDataset fastDataset = new FastDataset(numRows, relativeMinSupport, relativeMaxSupport);
        int lineNumber = 0;
        BufferedReader in = Files.newBufferedReader(path);
        while ((line = in.readLine()) != null) {
            if (line.length() == 0) continue;
            int transID = 1;
            StringTokenizer tokenizer = new StringTokenizer(line);
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                if (token.equals(ITEMSET_SEPARATOR)) {
                    ++transID;
                    continue;
                }
                if (token.equals(SEQUENCE_SEPARATOR)) break;
                SparseIdList inserted = fastDataset.itemSILMap.putIfAbsent(token, new SparseIdList((int)numRows));
                fastDataset.itemSILMap.get(token).addElement(lineNumber, transID);
            }
            ++lineNumber;
        }
        fastDataset.computeFrequentItems();
        return fastDataset;
    }

    private static long countNumRowsSpamSource(Path path) throws IOException {
        Set custIds = Files.lines(path).filter(l -> l.length() > 0).map(l -> l.split(" ")[0]).collect(Collectors.toSet());
        return custIds.size();
    }

    public static FastDataset fromSpamSource(Path path, float relativeMinSupport, float relativeMaxSupport) throws IOException {
        long numRows = FastDataset.countNumRowsSpamSource(path);
        FastDataset fastDataset = new FastDataset(numRows, relativeMinSupport, relativeMaxSupport);
        Files.lines(path).filter(l -> l.length() > 0).forEach(l -> {
            String[] split = l.split(" ");
            int custId = Integer.parseInt(split[0]);
            int transId = Integer.parseInt(split[1]);
            SparseIdList inserted = fastDataset.itemSILMap.putIfAbsent(split[2], new SparseIdList((int)numRows));
            inserted.addElement(custId, transId);
        });
        fastDataset.computeFrequentItems();
        return fastDataset;
    }

    int absoluteSupport(float relativeSupport, long totalCount) {
        return (int)Math.ceil(relativeSupport * (float)totalCount);
    }
}

