/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model;

import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.Itemset;
import java.util.Iterator;
import java.util.LinkedList;

public class Sequence
implements Iterable<Itemset>,
Cloneable {
    private LinkedList<Itemset> elements = new LinkedList();

    public Sequence(Itemset ... itemset2) {
        for (Itemset i : itemset2) {
            this.elements.add(i);
        }
    }

    public void add(Itemset element) {
        this.elements.add(element);
    }

    public String getLastItem() {
        return this.getLastItemset().getLast();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (Itemset itemset2 : this.elements) {
            buff.append(itemset2.concatenate());
            buff.append(" -1 ");
        }
        return buff.toString() + "-2";
    }

    public Itemset getLastItemset() {
        return this.elements.getLast();
    }

    public int length() {
        return this.elements.size();
    }

    public Sequence clone() {
        Sequence other = new Sequence(new Itemset[0]);
        for (Itemset itemset2 : this.elements) {
            other.add(itemset2.clone());
        }
        return other;
    }

    @Override
    public Iterator<Itemset> iterator() {
        return this.elements.iterator();
    }

    public LinkedList<Itemset> getElements() {
        return this.elements;
    }

    public boolean containsItemset(Itemset itemset2) {
        return this.elements.stream().anyMatch(i -> i.contains(itemset2));
    }

    public boolean contains(Sequence other) {
        if (this.elements.size() < other.elements.size()) {
            return false;
        }
        int matchIndex = 0;
        for (Itemset itemset2 : other) {
            int nextIndex = -1;
            for (int i = matchIndex; i < this.elements.size(); ++i) {
                if (!this.elements.get(i).contains(itemset2)) continue;
                nextIndex = i;
                break;
            }
            if (nextIndex == -1) {
                return false;
            }
            matchIndex = nextIndex + 1;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sequence)) {
            return false;
        }
        Sequence sequence = (Sequence)o;
        return !(this.elements != null ? !this.elements.equals(sequence.elements) : sequence.elements != null);
    }

    public int hashCode() {
        return this.elements != null ? this.elements.hashCode() : 0;
    }
}

